/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;

public abstract class AbstractXMLDBTask
extends Task {
    protected String driver = "org.exist.xmldb.DatabaseImpl";
    protected String user = "guest";
    protected String password = "guest";
    protected String uri = null;
    protected boolean createDatabase = false;
    protected String configuration = null;
    protected boolean failonerror = true;

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setInitdb(boolean create) {
        this.createDatabase = create;
    }

    public void setConfiguration(String config) {
        this.configuration = config;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    protected void registerDatabase() throws BuildException {
        try {
            this.log("Registering database", 4);
            Database[] dbs = DatabaseManager.getDatabases();
            for (int i = 0; i < dbs.length; ++i) {
                if (!dbs[i].acceptsURI(this.uri)) continue;
                this.log("Database driver already registered.");
                return;
            }
            Class<?> clazz = Class.forName(this.driver);
            Database database = (Database)clazz.newInstance();
            database.setProperty("create-database", this.createDatabase ? "true" : "false");
            if (this.configuration != null) {
                database.setProperty("configuration", this.configuration);
            }
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            throw new BuildException("failed to initialize XMLDB database driver");
        }
    }
}

