/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.User;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.XMLDBException;

public class AddUserTask
extends UserTask {
    private String name;
    private String primaryGroup;
    private String home;
    private String secret;

    public void execute() throws BuildException {
        super.execute();
        if (this.name == null) {
            throw new BuildException("Must specify at leat a user name");
        }
        try {
            User usr = new User(this.name);
            if (this.secret != null) {
                usr.setPassword(this.secret);
            }
            if (this.home != null) {
                usr.setHome(XmldbURI.xmldbUriFor((String)this.home));
            }
            if (this.primaryGroup != null) {
                usr.addGroup(this.primaryGroup);
            }
            this.log("Adding user " + this.name, 2);
            this.service.addUser(usr);
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception caught: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new BuildException("XMLDB exception caught: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryGroup(String primaryGroup) {
        this.primaryGroup = primaryGroup;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }
}

