/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.xmldb.api.base.XMLDBException;

public class ListGroupsTask
extends UserTask {
    private String outputproperty = null;
    private String separator = ",";

    public void execute() throws BuildException {
        super.execute();
        try {
            this.log("Listing all groups", 4);
            String[] groups = this.service.getGroups();
            if (groups != null) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < groups.length; ++i) {
                    buf.append(groups[i]);
                    if (i >= groups.length - 1) continue;
                    buf.append(this.separator);
                }
                if (buf.length() > 0) {
                    this.log("Setting output property " + this.outputproperty + " to " + buf.toString(), 4);
                    this.getProject().setNewProperty(this.outputproperty, buf.toString());
                }
            }
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception caught: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setOutputproperty(String outputproperty) {
        this.outputproperty = outputproperty;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

