/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.User;
import org.xmldb.api.base.XMLDBException;

public class ListUsersTask
extends UserTask {
    private String outputproperty = null;
    private String separator = ",";

    public void execute() throws BuildException {
        super.execute();
        try {
            this.log("Listing all users", 4);
            User[] users = this.service.getUsers();
            if (users != null) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < users.length; ++i) {
                    buf.append(users[i].getName());
                    if (i >= users.length - 1) continue;
                    buf.append(this.separator);
                }
                if (buf.length() > 0) {
                    this.log("Setting output property " + this.outputproperty + " to " + buf.toString(), 4);
                    this.getProject().setNewProperty(this.outputproperty, buf.toString());
                }
            }
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception caught: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setOutputproperty(String outputproperty) {
        this.outputproperty = outputproperty;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

