/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.UserTask;
import org.exist.security.User;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class LockResourceTask
extends UserTask {
    private String name = null;
    private String resource = null;

    public void execute() throws BuildException {
        super.execute();
        if (this.resource == null || this.name == null) {
            throw new BuildException("Must specify user and resource name");
        }
        try {
            Resource res = this.base.getResource(this.resource);
            if (res == null) {
                throw new BuildException("Resource " + this.resource + " not found");
            }
            User usr = this.service.getUser(this.name);
            if (usr == null) {
                throw new BuildException("User " + this.name + " not found");
            }
            this.service.lockResource(res, usr);
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception caught: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setName(String user) {
        this.name = user;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

