/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.DirSet;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.backup.Restore;

public class RestoreTask
extends AbstractXMLDBTask {
    private File dir = null;
    private DirSet dirSet = null;
    private String restorePassword = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("You have to specify an XMLDB collection URI");
        }
        if (this.dir == null && this.dirSet == null) {
            throw new BuildException("Missing required argument: either dir or dirset required");
        }
        if (this.dir != null && !this.dir.canRead()) {
            throw new BuildException("Cannot read restore file: " + this.dir.getAbsolutePath());
        }
        this.registerDatabase();
        try {
            if (this.dir != null) {
                this.log("Restoring from " + this.dir.getAbsolutePath(), 2);
                File file = new File(this.dir, "__contents__.xml");
                if (!file.exists()) {
                    throw new BuildException("Did not found file " + file.getAbsolutePath());
                }
                Restore restore = new Restore(this.user, this.password, this.restorePassword, file, this.uri);
                restore.restore(false, null);
            } else if (this.dirSet != null) {
                DirectoryScanner scanner = this.dirSet.getDirectoryScanner(this.getProject());
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                this.log("Found " + files.length + " files.\n");
                File file = null;
                for (int i = 0; i < files.length; ++i) {
                    this.dir = new File(scanner.getBasedir() + File.separator + files[i]);
                    file = new File(this.dir, "__contents__.xml");
                    if (!file.exists()) {
                        throw new BuildException("Did not found file " + file.getAbsolutePath());
                    }
                    this.log("Restoring from " + file.getAbsolutePath() + " ...\n");
                    Restore restore = new Restore(this.user, this.password, this.restorePassword, file, this.uri);
                    restore.restore(false, null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Exception during restore: " + e.getMessage(), (Throwable)e);
        }
    }

    public DirSet createDirSet() {
        this.dirSet = new DirSet();
        return this.dirSet;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setRestorePassword(String pass) {
        this.restorePassword = pass;
    }
}

