/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBCreateTask
extends AbstractXMLDBTask {
    private String collection = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        this.registerDatabase();
        try {
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                throw new BuildException("Collection " + this.uri + " could not be found.");
            }
            Collection root = null;
            if (this.collection != null) {
                this.log("Creating collection " + this.collection + " in base collection " + this.uri, 4);
                root = this.mkcol(base, this.uri, this.collection);
            } else {
                root = base;
            }
            this.log("Created collection " + root.getName(), 2);
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception caught: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new BuildException("URISyntaxException: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    private final Collection mkcol(Collection root, String base, String relPath) throws XMLDBException, URISyntaxException {
        Collection current = root;
        XmldbURI baseUri = XmldbURI.xmldbUriFor((String)base);
        XmldbURI collPath = XmldbURI.xmldbUriFor((String)relPath);
        this.log("BASEURI=" + baseUri, 4);
        this.log("RELPATH=" + relPath, 4);
        XmldbURI[] segments = collPath.getPathSegments();
        for (int i = 0; i < segments.length; ++i) {
            baseUri = baseUri.append(segments[i]);
            this.log("Get collection " + baseUri, 4);
            Collection c = DatabaseManager.getCollection((String)baseUri.toString(), (String)this.user, (String)this.password);
            if (c == null) {
                this.log("Create collection management service for collection " + current.getName(), 4);
                CollectionManagementService mgtService = (CollectionManagementService)current.getService("CollectionManagementService", "1.0");
                this.log("Create child collection " + segments[i]);
                current = mgtService.createCollection(segments[i].toString());
                this.log("Created collection " + current.getName() + '.');
                continue;
            }
            current = c;
        }
        return current;
    }
}

