/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.exist.ant.AbstractXMLDBTask;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBExistTask
extends AbstractXMLDBTask
implements Condition {
    private String resource = null;

    public boolean eval() throws BuildException {
        boolean exist = false;
        if (this.uri == null) {
            throw new BuildException("You have to specify an XMLDB collection URI");
        }
        this.registerDatabase();
        try {
            this.log("Checking collection: " + this.uri, 2);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base != null) {
                this.log("Base collection found", 4);
                exist = true;
            }
            if (base != null && this.resource != null) {
                this.log("Checking resource: " + this.resource, 2);
                Resource res = base.getResource(this.resource);
                if (res == null) {
                    this.log("Resource not found", 4);
                    exist = false;
                }
            }
        }
        catch (XMLDBException e) {
            this.log("Resource or collection cannot be retrieved", 4);
            exist = false;
        }
        return exist;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

