/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.xml.sax.ContentHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XMLDBExtractTask
extends AbstractXMLDBTask {
    private String resource = null;
    private File destFile = null;
    private File destDir = null;
    private String type = "xml";
    private boolean createdirectories = false;
    private boolean subcollections = false;

    public void execute() throws BuildException {
        block14: {
            if (this.uri == null) {
                if (this.failonerror) {
                    throw new BuildException("you have to specify an XMLDB collection URI");
                }
            } else {
                this.registerDatabase();
                try {
                    Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
                    if (base == null) {
                        throw new BuildException("Collection " + this.uri + " could not be found.");
                    }
                    if (this.resource != null) {
                        this.log("Extracting resource: " + this.resource + " to " + this.destFile.getAbsolutePath(), 2);
                        XMLResource res = (XMLResource)base.getResource(this.resource);
                        if (res == null) {
                            if (this.failonerror) {
                                throw new BuildException("Resource " + this.resource + " not found.");
                            }
                        } else {
                            this.writeResource(res, this.destFile);
                        }
                    } else {
                        this.extractResources(base, null);
                        if (this.subcollections) {
                            this.extractSubCollections(base, null);
                        }
                    }
                }
                catch (XMLDBException e) {
                    if (this.failonerror) {
                        throw new BuildException("XMLDB exception caught while executing query: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!this.failonerror) break block14;
                    throw new BuildException("XMLDB exception caught while writing destination file: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void extractResources(Collection base, String path) throws XMLDBException, IOException {
        XMLResource res = null;
        String[] resources = base.listResources();
        if (resources != null) {
            File dir = this.destDir;
            this.log("Extracting to directory " + this.destDir.getAbsolutePath(), 4);
            if (path != null) {
                dir = new File(this.destDir, path);
            }
            for (int i = 0; i < resources.length; ++i) {
                res = (XMLResource)base.getResource(resources[i]);
                this.log("Extracting resource: " + res.getId(), 4);
                if (!dir.exists() && this.createdirectories) {
                    dir.mkdirs();
                }
                this.writeResource(res, dir);
            }
        }
    }

    private void extractSubCollections(Collection base, String path) throws XMLDBException, IOException {
        String[] childCols = base.listChildCollections();
        if (childCols != null) {
            Collection col = null;
            for (int i = 0; i < childCols.length; ++i) {
                String subdir;
                col = base.getChildCollection(childCols[i]);
                if (col == null) continue;
                this.log("Extracting collection: " + col.getName(), 4);
                File dir = this.destDir;
                if (path != null) {
                    dir = new File(this.destDir, path + File.separator + childCols[i]);
                    subdir = path + File.separator + childCols[i];
                } else {
                    subdir = childCols[i];
                }
                if (!dir.exists() && this.createdirectories) {
                    dir.mkdirs();
                }
                this.extractResources(col, subdir);
                if (!this.subcollections) continue;
                this.extractSubCollections(col, subdir);
            }
        }
    }

    private void writeResource(XMLResource resource, File dest) throws IOException, XMLDBException {
        FileWriter writer;
        SAXSerializer serializer;
        Properties outputProperties;
        if (dest != null || !dest.exists()) {
            outputProperties = new Properties();
            outputProperties.setProperty("indent", "yes");
            serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject((Object)SAXSerializer.class);
            writer = null;
            if (dest.isDirectory()) {
                String fname = resource.getId();
                if (!fname.endsWith("." + this.type)) {
                    fname = fname + "." + this.type;
                }
                File file = new File(dest, fname);
                writer = new FileWriter(file);
            } else {
                writer = new FileWriter(dest);
            }
        } else {
            throw new BuildException("Destionation target does not exist.");
        }
        this.log("Writing resource " + resource.getId() + " to destination " + dest.getAbsolutePath(), 4);
        serializer.setOutput((Writer)writer, outputProperties);
        resource.getContentAsSAX((ContentHandler)serializer);
        SerializerPool.getInstance().returnObject((Object)serializer);
        ((Writer)writer).close();
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setType(String type) {
        this.type = type;
        if (!"xml".equalsIgnoreCase(type)) {
            throw new BuildException("non-xml resource types are not supported currently");
        }
    }

    public void setCreatedirectories(boolean createdirectories) {
        this.createdirectories = createdirectories;
    }

    public void setSubcollections(boolean subcollections) {
        this.subcollections = subcollections;
    }
}

