/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBListTask
extends AbstractXMLDBTask {
    private boolean collections = false;
    private boolean resources = false;
    private String separator = ",";
    private String outputproperty;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("You have to specify an XMLDB collection URI");
        }
        if (!this.collections && !this.resources) {
            throw new BuildException("You have at least one of collections or resources or both");
        }
        this.registerDatabase();
        try {
            int i;
            String[] cols;
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                throw new BuildException("Collection " + this.uri + " could not be found.");
            }
            StringBuffer buf = new StringBuffer();
            if (this.collections && (cols = base.listChildCollections()) != null) {
                this.log("Listing child collections", 4);
                for (i = 0; i < cols.length; ++i) {
                    buf.append(cols[i]);
                    if (i >= cols.length - 1) continue;
                    buf.append(this.separator);
                }
            }
            if (this.resources) {
                this.log("Listing resources", 4);
                String[] res = base.listResources();
                if (res != null) {
                    if (buf.length() > 0) {
                        buf.append(this.separator);
                    }
                    for (i = 0; i < res.length; ++i) {
                        buf.append(res[i]);
                        if (i >= res.length - 1) continue;
                        buf.append(this.separator);
                    }
                }
            }
            if (buf.length() > 0) {
                this.log("Set property " + this.outputproperty, 2);
                this.getProject().setNewProperty(this.outputproperty, buf.toString());
            }
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception during remove: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setCollections(boolean collections) {
        this.collections = collections;
    }

    public void setResources(boolean resources) {
        this.resources = resources;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setOutputproperty(String outputproperty) {
        this.outputproperty = outputproperty;
    }
}

