/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBRemoveTask
extends AbstractXMLDBTask {
    private String resource = null;
    private String collection = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("You have to specify an XMLDB collection URI");
        }
        if (this.resource == null && this.collection == null) {
            throw new BuildException("Missing parameter: either resource or collection should be specified");
        }
        this.registerDatabase();
        try {
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                throw new BuildException("Collection " + this.uri + " could not be found.");
            }
            if (this.resource != null) {
                this.log("Removing resource: " + this.resource, 2);
                Resource res = base.getResource(this.resource);
                if (res == null) {
                    throw new BuildException("Resource " + this.resource + " not found.");
                }
                base.removeResource(res);
            } else {
                this.log("Removing collection: " + this.collection, 2);
                CollectionManagementService service = (CollectionManagementService)base.getService("CollectionManagementService", "1.0");
                service.removeCollection(this.collection);
            }
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception during remove: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

