/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import org.apache.tools.ant.BuildException;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.xmldb.DatabaseInstanceManager;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBShutdownTask
extends AbstractXMLDBTask {
    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        this.registerDatabase();
        try {
            this.log("Get base collection: " + this.uri, 4);
            Collection root = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (root == null) {
                throw new BuildException("Collection " + this.uri + " could not be found.");
            }
            DatabaseInstanceManager mgr = (DatabaseInstanceManager)root.getService("DatabaseInstanceManager", "1.0");
            this.log("Shutdown database instance", 2);
            mgr.shutdown();
        }
        catch (XMLDBException e) {
            throw new BuildException("Error during database shutdown: " + e.getMessage(), (Throwable)e);
        }
    }
}

