/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.EXistResource;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBStoreTask
extends AbstractXMLDBTask {
    private File srcFile = null;
    private String targetFile = null;
    private FileSet fileSet = null;
    private boolean createCollection = false;
    private boolean createSubcollections = false;
    private String type = null;

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        if (this.fileSet == null && this.srcFile == null) {
            throw new BuildException("no file set specified");
        }
        this.registerDatabase();
        int p = this.uri.indexOf("/db");
        if (p == -1) {
            throw new BuildException("invalid uri: '" + this.uri + "'");
        }
        try {
            String baseURI = this.uri.substring(0, p);
            String path = p == this.uri.length() - 3 ? "" : this.uri.substring(p + 3);
            Collection root = null;
            if (this.createCollection) {
                root = DatabaseManager.getCollection((String)(baseURI + "/db"), (String)this.user, (String)this.password);
                root = this.mkcol(root, baseURI, "/db", path);
            } else {
                root = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            }
            if (root == null) {
                throw new BuildException("Collection " + this.uri + " could not be found.");
            }
            MimeType mime = null;
            if (this.type != null) {
                mime = this.type.equals("xml") ? MimeType.XML_TYPE : (this.type.equals("binary") ? MimeType.BINARY_TYPE : MimeTable.getInstance().getContentType(this.type));
            }
            Collection col = root;
            String prevDir = null;
            String resourceType = "XMLResource";
            if (this.srcFile != null) {
                this.log("Storing single file " + this.srcFile.getAbsolutePath(), 4);
                if (mime == null) {
                    mime = MimeTable.getInstance().getContentTypeFor(this.srcFile.getName());
                }
                if (mime == null) {
                    throw new BuildException("Cannot find mime-type for " + this.srcFile.getName());
                }
                String string = resourceType = mime.isXMLType() ? "XMLResource" : "BinaryResource";
                if (this.targetFile == null) {
                    this.targetFile = this.srcFile.getName();
                }
                this.log("Creating resource " + this.targetFile + " in collection " + col.getName() + " of type " + resourceType + " with mime-type: " + mime.getName(), 4);
                Resource res = col.createResource(this.targetFile, resourceType);
                res.setContent((Object)this.srcFile);
                ((EXistResource)res).setMimeType(mime.getName());
                col.storeResource(res);
            } else {
                this.log("Storing fileset", 4);
                DirectoryScanner scanner = this.fileSet.getDirectoryScanner(this.getProject());
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                this.log("Found " + files.length + " files.\n");
                MimeType currentMime = mime;
                for (int i = 0; i < files.length; ++i) {
                    File file = new File(scanner.getBasedir() + File.separator + files[i]);
                    this.log("Storing " + files[i] + " ...\n");
                    p = files[i].lastIndexOf(File.separatorChar);
                    if (p != -1) {
                        String relDir = files[i].substring(0, p);
                        relDir = relDir.replace(File.separatorChar, '/');
                        if (this.createSubcollections && (prevDir == null || !relDir.equals(prevDir))) {
                            col = this.mkcol(root, baseURI, "/db" + path, relDir);
                            prevDir = relDir;
                        }
                    } else {
                        col = root;
                    }
                    if (mime == null) {
                        currentMime = MimeTable.getInstance().getContentTypeFor(file.getName());
                    }
                    if (currentMime == null) {
                        throw new BuildException("Cannot find mime-type for " + file.getName());
                    }
                    resourceType = currentMime.isXMLType() ? "XMLResource" : "BinaryResource";
                    this.log("Creating resource " + file.getName() + " in collection " + col.getName() + " of type " + resourceType + " with mime-type: " + currentMime.getName(), 4);
                    Resource res = col.createResource(file.getName(), resourceType);
                    res.setContent((Object)file);
                    ((EXistResource)res).setMimeType(currentMime.getName());
                    col.storeResource(res);
                }
            }
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception caught: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setSrcFile(File file) {
        this.srcFile = file;
    }

    public void setTargetFile(String name) {
        this.targetFile = name;
    }

    public FileSet createFileSet() {
        this.fileSet = new FileSet();
        return this.fileSet;
    }

    public void setCreatecollection(boolean create) {
        this.createCollection = create;
    }

    public void setCreatesubcollections(boolean create) {
        this.createSubcollections = create;
    }

    public void setType(String type) {
        this.type = type;
    }

    private final Collection mkcol(Collection root, String baseURI, String path, String relPath) throws XMLDBException {
        Collection current = root;
        StringTokenizer tok = new StringTokenizer(relPath, "/");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            path = path != null ? path + "/" + token : "/" + token;
            this.log("Get collection " + baseURI + path, 4);
            Collection c = DatabaseManager.getCollection((String)(baseURI + path), (String)this.user, (String)this.password);
            if (c == null) {
                this.log("Create collection management service for collection " + current.getName(), 4);
                CollectionManagementService mgtService = (CollectionManagementService)current.getService("CollectionManagementService", "1.0");
                this.log("Create child collection " + token, 4);
                current = mgtService.createCollection(token);
                this.log("Created collection " + current.getName() + '.', 4);
                continue;
            }
            current = c;
        }
        return current;
    }
}

