/*
 * Decompiled with CFR 0.152.
 */
package org.exist.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.exist.ant.AbstractXMLDBTask;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.source.URLSource;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XQueryService;
import org.xml.sax.ContentHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XMLDBXQueryTask
extends AbstractXMLDBTask {
    private String text = null;
    private String queryUri = null;
    private String query = null;
    private File queryFile = null;
    private File destDir = null;
    private String outputproperty;
    private List variables = new ArrayList();

    public void execute() throws BuildException {
        if (this.uri == null) {
            throw new BuildException("you have to specify an XMLDB collection URI");
        }
        if (this.text != null) {
            PropertyHelper helper = PropertyHelper.getPropertyHelper((Project)this.getProject());
            this.query = helper.replaceProperties(null, this.text, null);
        }
        if (this.queryFile == null && this.query == null && this.queryUri == null) {
            throw new BuildException("you have to specify a query either as attribute, text, URI or in a file");
        }
        this.registerDatabase();
        try {
            this.log("Get base collection: " + this.uri, 4);
            Collection base = DatabaseManager.getCollection((String)this.uri, (String)this.user, (String)this.password);
            if (base == null) {
                throw new BuildException("Collection " + this.uri + " could not be found.");
            }
            XQueryService service = (XQueryService)base.getService("XQueryService", "1.0");
            service.setProperty("indent", "yes");
            service.setProperty("encoding", "UTF-8");
            Iterator i = this.variables.iterator();
            while (i.hasNext()) {
                Variable var = (Variable)i.next();
                System.out.println("Name: " + var.name);
                System.out.println("Value: " + var.value);
                service.declareVariable(var.name, (Object)var.value);
            }
            ResourceSet results = null;
            URLSource source = null;
            if (this.queryUri != null) {
                this.log("XQuery url " + this.queryUri, 4);
                source = new URLSource(new URL(this.queryUri));
            } else if (this.queryFile != null) {
                this.log("XQuery file " + this.queryFile.getAbsolutePath(), 4);
                source = new FileSource(this.queryFile, "UTF-8", true);
            } else {
                this.log("XQuery string: " + this.query, 4);
                source = new StringSource(this.query);
            }
            results = service.execute((Source)source);
            this.log("Found " + results.getSize() + " results", 2);
            if (this.destDir != null && results != null) {
                this.log("write results to directory " + this.destDir.getAbsolutePath(), 2);
                ResourceIterator iter = results.getIterator();
                XMLResource res = null;
                this.log("Writing results to directory " + this.destDir.getAbsolutePath(), 4);
                while (iter.hasMoreResources()) {
                    res = (XMLResource)iter.nextResource();
                    this.log("Writing resource " + res.getId(), 4);
                    this.writeResource(res, this.destDir);
                }
            } else if (this.outputproperty != null) {
                ResourceIterator iter = results.getIterator();
                XMLResource res = null;
                String result = null;
                while (iter.hasMoreResources()) {
                    res = (XMLResource)iter.nextResource();
                    result = res.getContent().toString();
                }
                this.getProject().setNewProperty(this.outputproperty, result);
            }
        }
        catch (XMLDBException e) {
            throw new BuildException("XMLDB exception caught while executing query: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("XMLDB exception caught while writing destination file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void writeResource(XMLResource resource, File dest) throws IOException, XMLDBException {
        FileWriter writer;
        SAXSerializer serializer;
        Properties outputProperties;
        if (dest != null) {
            outputProperties = new Properties();
            outputProperties.setProperty("indent", "yes");
            serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject((Object)SAXSerializer.class);
            writer = null;
            if (dest.isDirectory()) {
                String fname;
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!(fname = resource.getId()).endsWith(".xml")) {
                    fname = fname + ".xml";
                }
                File file = new File(dest, fname);
                writer = new FileWriter(file);
            } else {
                writer = new FileWriter(dest);
            }
        } else {
            throw new BuildException("Destionation target does not exist.");
        }
        serializer.setOutput((Writer)writer, outputProperties);
        resource.getContentAsSAX((ContentHandler)serializer);
        ((Writer)writer).close();
        SerializerPool.getInstance().returnObject((Object)serializer);
    }

    public void addText(String text) {
        this.text = text;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setQueryFile(File queryFile) {
        this.queryFile = queryFile;
    }

    public void setQueryUri(String queryUri) {
        this.queryUri = queryUri;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    public void setOutputproperty(String outputproperty) {
        this.outputproperty = outputproperty;
    }

    public static class Variable {
        private String name = null;
        private String value = null;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

