/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cocoon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.servlet.multipart.Part;
import org.exist.cocoon.CocoonSessionWrapper;
import org.exist.http.servlets.RequestWrapper;
import org.exist.http.servlets.SessionWrapper;

public class CocoonRequestWrapper
implements RequestWrapper {
    private Request cocoonRequest;
    private HttpServletRequest servletRequest = null;

    public CocoonRequestWrapper(Request cocoonRequest) {
        this.cocoonRequest = cocoonRequest;
    }

    public CocoonRequestWrapper(Request cocoonRequest, HttpServletRequest servletRequest) {
        this.cocoonRequest = cocoonRequest;
        this.servletRequest = servletRequest;
    }

    public Object getAttribute(String name) {
        return this.cocoonRequest.getAttribute(name);
    }

    public Cookie[] getCookies() {
        return this.servletRequest.getCookies();
    }

    public InputStream getInputStream() throws IOException {
        if (this.servletRequest == null) {
            throw new IOException("Request input stream is only available within a servlet environment");
        }
        return this.servletRequest.getInputStream();
    }

    public Object get(String arg0) {
        return this.cocoonRequest.get(arg0);
    }

    public String getCharacterEncoding() {
        return this.cocoonRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.cocoonRequest.getContentLength();
    }

    public String getContentType() {
        return this.cocoonRequest.getContentType();
    }

    public String getContextPath() {
        return this.cocoonRequest.getContextPath();
    }

    public Map getCookieMap() {
        return this.cocoonRequest.getCookieMap();
    }

    public String getHeader(String arg0) {
        return this.cocoonRequest.getHeader(arg0);
    }

    public Enumeration getHeaderNames() {
        return this.cocoonRequest.getHeaderNames();
    }

    public Enumeration getHeaders(String arg0) {
        return this.cocoonRequest.getHeaders(arg0);
    }

    public String getMethod() {
        return this.cocoonRequest.getMethod();
    }

    public String getParameter(String arg0) {
        return this.cocoonRequest.getParameter(arg0);
    }

    public Enumeration getParameterNames() {
        return this.cocoonRequest.getParameterNames();
    }

    public String[] getParameterValues(String arg0) {
        return this.cocoonRequest.getParameterValues(arg0);
    }

    public String getPathInfo() {
        return this.cocoonRequest.getPathInfo();
    }

    public String getPathTranslated() {
        return this.cocoonRequest.getPathTranslated();
    }

    public String getProtocol() {
        return this.cocoonRequest.getProtocol();
    }

    public String getQueryString() {
        return this.cocoonRequest.getQueryString();
    }

    public String getRemoteAddr() {
        return this.cocoonRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.cocoonRequest.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.cocoonRequest.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.cocoonRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.cocoonRequest.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        if (this.servletRequest == null) {
            return null;
        }
        return this.servletRequest.getRequestURL();
    }

    public String getScheme() {
        return this.cocoonRequest.getScheme();
    }

    public String getServerName() {
        return this.cocoonRequest.getServerName();
    }

    public int getServerPort() {
        return this.cocoonRequest.getServerPort();
    }

    public String getServletPath() {
        return this.cocoonRequest.getServletPath();
    }

    public SessionWrapper getSession() {
        Session session = this.cocoonRequest.getSession();
        if (session == null) {
            return null;
        }
        return new CocoonSessionWrapper(session);
    }

    public SessionWrapper getSession(boolean arg0) {
        Session session = this.cocoonRequest.getSession(arg0);
        if (session == null) {
            return null;
        }
        return new CocoonSessionWrapper(session);
    }

    public String getSitemapURI() {
        return this.cocoonRequest.getSitemapURI();
    }

    public Principal getUserPrincipal() {
        return this.cocoonRequest.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.cocoonRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.cocoonRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.cocoonRequest.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.cocoonRequest.isSecure();
    }

    public boolean isUserInRole(String arg0) {
        return this.cocoonRequest.isUserInRole(arg0);
    }

    public void removeAttribute(String arg0) {
        this.cocoonRequest.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.cocoonRequest.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.cocoonRequest.setCharacterEncoding(arg0);
    }

    public File getFileUploadParam(String parameter) {
        Object param = this.cocoonRequest.get(parameter);
        if (param == null) {
            return null;
        }
        if (param instanceof Part) {
            Part part = (Part)param;
            try {
                File temp = File.createTempFile("existCRW", ".xml");
                temp.deleteOnExit();
                FileOutputStream os = new FileOutputStream(temp);
                InputStream is = part.getInputStream();
                byte[] data = new byte[1024];
                int read = 0;
                while ((read = is.read(data)) > -1) {
                    ((OutputStream)os).write(data, 0, read);
                }
                is.close();
                part.dispose();
                return temp;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getUploadedFileName(String parameter) {
        Object param = this.cocoonRequest.get(parameter);
        if (param == null) {
            return null;
        }
        if (param instanceof Part) {
            Part part = (Part)param;
            return new File(part.getUploadName()).getName();
        }
        return null;
    }
}

