/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cocoon;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.exist.xmldb.DatabaseInstanceManager;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class ShutdownAction
extends ServiceableAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap result = new HashMap();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (request == null) {
            this.getLogger().error("No request!");
            return null;
        }
        String user = request.getParameter("user");
        String passwd = request.getParameter("password");
        if (user == null) {
            this.getLogger().error("no user specified!");
            return null;
        }
        if (source == null) {
            this.getLogger().debug("No source specified! Using default.");
            source = "xmldb:exist:///db";
        }
        Collection collection = null;
        try {
            collection = DatabaseManager.getCollection((String)source, (String)user, (String)passwd);
        }
        catch (XMLDBException e) {
            this.getLogger().error("login denied: " + e.getMessage());
            return null;
        }
        try {
            DatabaseInstanceManager mgr = (DatabaseInstanceManager)collection.getService("DatabaseInstanceManager", "1.0");
            if (mgr == null) {
                this.getLogger().error("access to DatabaseInstanceManager failed");
                return null;
            }
            mgr.shutdown();
        }
        catch (XMLDBException e) {
            this.getLogger().warn("An error occurred: " + e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }
}

