/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cocoon;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.exist.storage.report.XMLStatistics;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StatusGenerator
extends AbstractGenerator {
    public static final String NAMESPACE = "http://exist.sourceforge.net/generators/status";
    public static final String PREFIX = "status";
    XMLStatistics stats;

    public StatusGenerator() {
        this.stats = new XMLStatistics(this.contentHandler);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.stats.setContentHandler(this.contentHandler);
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping(PREFIX, NAMESPACE);
        this.contentHandler.startElement(NAMESPACE, PREFIX, "status:status", new AttributesImpl());
        this.genVMStatus();
        this.stats.genInstanceStatus();
        this.contentHandler.endElement(NAMESPACE, PREFIX, "status:status");
        this.contentHandler.endPrefixMapping(PREFIX);
        this.contentHandler.endDocument();
    }

    private void genVMStatus() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.contentHandler.startElement(NAMESPACE, "system", "status:system", atts);
        this.contentHandler.startElement(NAMESPACE, "memory", "status:memory", atts);
        this.addValue("total", String.valueOf(Runtime.getRuntime().totalMemory()));
        this.addValue("free", String.valueOf(Runtime.getRuntime().freeMemory()));
        this.addValue("max", String.valueOf(Runtime.getRuntime().maxMemory()));
        this.contentHandler.endElement(NAMESPACE, "memory", "status:memory");
        this.contentHandler.startElement(NAMESPACE, "jvm", "status:jvm", atts);
        this.addValue("version", System.getProperty("java.version"));
        this.addValue("vendor", System.getProperty("java.vendor"));
        Locale locale = Locale.getDefault();
        this.addValue("locale", locale.toString());
        InputStreamReader is = new InputStreamReader(System.in);
        this.addValue("charset", is.getEncoding());
        this.contentHandler.endElement(NAMESPACE, "jvm", "status:jvm");
        this.contentHandler.startElement(NAMESPACE, "os", "status:os", atts);
        this.addValue("name", System.getProperty("os.name"));
        this.addValue("architecture", System.getProperty("os.arch"));
        this.addValue("version", System.getProperty("os.version"));
        this.contentHandler.endElement(NAMESPACE, "os", "status:os");
        this.contentHandler.endElement(NAMESPACE, "system", "status:system");
    }

    private void addValue(String elem, String value) throws SAXException {
        this.stats.addValue(elem, value);
    }
}

