/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cocoon;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBSessionLoginAction
extends ServiceableAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (request == null) {
            this.getLogger().error("XMLDBSessionLoginAction: no request object!");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String user = null;
        String passwd = null;
        Session session = request.getSession(false);
        if (session == null || !request.isRequestedSessionIdValid()) {
            session = request.getSession(true);
        }
        if (session.getAttribute("user") == null) {
            user = param.getParameter("user", null);
            passwd = param.getParameter("password", null);
            if (user == null) {
                user = request.getParameter("user");
                passwd = request.getParameter("password");
            }
            if (user == null) {
                this.getLogger().error("XMLDBSessionLoginAction: no parameters!");
                return null;
            }
            if (source == null) {
                this.getLogger().error("XMLDBSessionLoginAction: no source specified!");
                return null;
            }
            this.getLogger().info("trying to login user " + user);
            try {
                Collection collection = DatabaseManager.getCollection((String)source, (String)user, (String)passwd);
            }
            catch (XMLDBException e) {
                this.getLogger().error("login denied: " + e.getMessage());
                return null;
            }
            session.setAttribute("user", (Object)user);
            session.setAttribute("password", (Object)passwd);
        } else {
            user = this.getSessionAttribute(session, "user");
            passwd = this.getSessionAttribute(session, "password");
            if (user == null) {
                return null;
            }
        }
        map.put("user", user);
        map.put("password", passwd);
        return map;
    }

    private String getSessionAttribute(Session session, String attribute) {
        Object obj = session.getAttribute(attribute);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Sequence) {
            try {
                return ((Sequence)obj).getStringValue();
            }
            catch (XPathException e) {
                return null;
            }
        }
        return obj.toString();
    }
}

