/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cocoon;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.EXistResource;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XMLDBSource
extends AbstractLogEnabled
implements ModifiableTraversableSource,
XMLizable {
    public static final String URI = "http://apache.org/cocoon/xmldb/1.0";
    public static final String PREFIX = "db";
    protected static final String COLLECTIONS = "collections";
    protected static final String QCOLLECTIONS = "db:collections";
    protected static final String RESOURCE_COUNT_ATTR = "resources";
    protected static final String COLLECTION_COUNT_ATTR = "collections";
    protected static final String COLLECTION_BASE_ATTR = "base";
    protected static final String COLLECTION = "collection";
    protected static final String QCOLLECTION = "db:collection";
    protected static final String RESOURCE = "resource";
    protected static final String QRESOURCE = "db:resource";
    protected static final String NAME_ATTR = "name";
    protected static final String RESULTSET = "results";
    protected static final String QRESULTSET = "db:results";
    protected static final String QUERY_ATTR = "query";
    protected static final String RESULTS_COUNT_ATTR = "resources";
    protected static final String RESULT = "result";
    protected static final String QRESULT = "db:result";
    protected static final String RESULT_DOCID_ATTR = "docid";
    protected static final String RESULT_ID_ATTR = "id";
    protected static final String CDATA = "CDATA";
    public String encoding = "UTF-8";
    public String url;
    public String user;
    public String password;
    protected String query;
    protected String systemId;
    private final String colPath;
    private String resName;
    public org.xmldb.api.base.Collection collection;
    public Resource resource;
    private static final int ST_UNKNOWN = 0;
    private static final int ST_COLLECTION = 1;
    private static final int ST_RESOURCE = 2;
    private static final int ST_NO_PARENT = 3;
    private static final int ST_NO_RESOURCE = 4;
    private int status = 0;

    public XMLDBSource(Logger logger, String user, String password, String srcUrl) {
        this.enableLogging(logger);
        this.user = user;
        this.password = password;
        this.url = srcUrl;
        int sharp = this.url.indexOf(35);
        if (sharp != -1) {
            this.url = this.url.substring(0, sharp);
            this.query = this.url.substring(sharp + 1);
            if (this.query.length() == 0) {
                this.query = null;
            }
        }
        int at = this.url.indexOf(64);
        int root = this.url.indexOf("//");
        if (at > -1 && (sharp == -1 || at < sharp)) {
            String userinfo = this.url.substring(root + 2, at);
            this.url = this.url.substring(0, root + 2) + this.url.substring(at + 1);
            int column = userinfo.indexOf(":");
            if (column != -1) {
                this.user = userinfo.substring(0, column);
                this.password = userinfo.substring(column + 1);
            } else {
                this.user = userinfo;
            }
        }
        if (this.url.endsWith("/")) {
            this.url = this.url.substring(0, this.url.length() - 1);
        }
        int pos = this.url.lastIndexOf(47);
        this.colPath = this.url.substring(0, pos);
        this.resName = this.url.substring(pos + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() throws XMLDBException, SourceException {
        this.status = 0;
        try {
            this.collection = DatabaseManager.getCollection((String)this.url, (String)this.user, (String)this.password);
            if (this.collection != null) {
                this.status = 1;
                return;
            }
            this.collection = DatabaseManager.getCollection((String)this.colPath, (String)this.user, (String)this.password);
            if (this.collection == null) {
                this.status = 3;
            } else {
                this.resource = this.collection.getResource(this.resName);
                this.status = this.resource != null ? 2 : 4;
            }
        }
        finally {
            if (this.status == 0) {
                this.cleanup();
            }
        }
    }

    private void cleanup() {
        this.close(this.collection);
    }

    private org.xmldb.api.base.Collection createCollection(String path) throws XMLDBException, SourceException {
        int pos;
        org.xmldb.api.base.Collection coll = DatabaseManager.getCollection((String)path, (String)this.user, (String)this.password);
        if (coll != null) {
            return coll;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((pos = path.lastIndexOf(47)) == -1) {
            throw new SourceException("Invalid collection path " + path);
        }
        org.xmldb.api.base.Collection parentColl = this.createCollection(path.substring(0, pos));
        CollectionManagementService mgtService = (CollectionManagementService)parentColl.getService("CollectionManagementService", "1.0");
        coll = mgtService.createCollection(path.substring(pos + 1));
        return coll;
    }

    private void close(org.xmldb.api.base.Collection coll) {
        if (coll != null) {
            try {
                coll.close();
            }
            catch (XMLDBException xMLDBException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.xmldb.api.base.Collection getCollection() throws SourceException, XMLDBException {
        try {
            this.setup();
            org.xmldb.api.base.Collection collection = this.collection;
            return collection;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource() throws SourceException, XMLDBException {
        try {
            this.setup();
            Resource resource = this.resource;
            return resource;
        }
        finally {
            this.cleanup();
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        block8: {
            try {
                this.setup();
                if (this.status == 1) {
                    this.collectionToSAX(handler);
                    break block8;
                }
                if (this.status == 2) {
                    this.resourceToSAX(handler);
                    break block8;
                }
                throw new SourceNotFoundException(this.getURI());
            }
            catch (SAXException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SAXException("Error processing " + this.getURI(), e);
            }
            finally {
                this.cleanup();
            }
        }
    }

    private void resourceToSAX(ContentHandler handler) throws SAXException, XMLDBException, SourceException {
        if (!(this.resource instanceof XMLResource)) {
            throw new SAXException("Not an XML resource: " + this.getURI());
        }
        if (this.query != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Querying resource " + this.resName + " from collection " + this.url + "; query= " + this.query);
            }
            this.queryToSAX(handler, this.collection, this.resName);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Obtaining resource " + this.resName + " from collection " + this.colPath);
            }
            if (this.resource instanceof EXistResource) {
                ((EXistResource)this.resource).setLexicalHandler((LexicalHandler)((Object)handler));
            }
            ((XMLResource)this.resource).getContentAsSAX(handler);
        }
    }

    private void collectionToSAX(ContentHandler handler) throws SAXException, XMLDBException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.query != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Querying collection " + this.url + "; query= " + this.query);
            }
            this.queryToSAX(handler, this.collection, null);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Listing collection " + this.url);
            }
            String nresources = Integer.toString(this.collection.getResourceCount());
            attributes.addAttribute("", "resources", "resources", CDATA, nresources);
            String ncollections = Integer.toString(this.collection.getChildCollectionCount());
            attributes.addAttribute("", "collections", "collections", CDATA, ncollections);
            attributes.addAttribute("", COLLECTION_BASE_ATTR, COLLECTION_BASE_ATTR, CDATA, this.url);
            handler.startDocument();
            handler.startPrefixMapping(PREFIX, URI);
            handler.startElement(URI, "collections", QCOLLECTIONS, attributes);
            String[] collections = this.collection.listChildCollections();
            for (int i = 0; i < collections.length; ++i) {
                attributes.clear();
                attributes.addAttribute("", NAME_ATTR, NAME_ATTR, CDATA, collections[i]);
                handler.startElement(URI, COLLECTION, QCOLLECTION, attributes);
                handler.endElement(URI, COLLECTION, QCOLLECTION);
            }
            String[] resources = this.collection.listResources();
            for (int i = 0; i < resources.length; ++i) {
                attributes.clear();
                attributes.addAttribute("", NAME_ATTR, NAME_ATTR, CDATA, resources[i]);
                handler.startElement(URI, RESOURCE, QRESOURCE, attributes);
                handler.endElement(URI, RESOURCE, QRESOURCE);
            }
            handler.endElement(URI, "collections", QCOLLECTIONS);
            handler.endPrefixMapping(PREFIX);
            handler.endDocument();
        }
    }

    private void queryToSAX(ContentHandler handler, org.xmldb.api.base.Collection collection, String resource) throws SAXException, XMLDBException {
        AttributesImpl attributes = new AttributesImpl();
        XPathQueryService service = (XPathQueryService)collection.getService("XPathQueryService", "1.0");
        ResourceSet resultSet = resource == null ? service.query(this.query) : service.queryResource(resource, this.query);
        attributes.addAttribute("", QUERY_ATTR, QUERY_ATTR, CDATA, this.query);
        attributes.addAttribute("", "resources", "resources", CDATA, Long.toString(resultSet.getSize()));
        handler.startDocument();
        handler.startPrefixMapping(PREFIX, URI);
        handler.startElement(URI, RESULTSET, QRESULTSET, attributes);
        IncludeXMLConsumer includeHandler = new IncludeXMLConsumer(handler);
        ResourceIterator results = resultSet.getIterator();
        while (results.hasMoreResources()) {
            XMLResource result = (XMLResource)results.nextResource();
            String id = result.getId();
            String documentId = result.getDocumentId();
            attributes.clear();
            if (id != null) {
                attributes.addAttribute("", RESULT_ID_ATTR, RESULT_ID_ATTR, CDATA, id);
            }
            if (documentId != null) {
                attributes.addAttribute("", RESULT_DOCID_ATTR, RESULT_DOCID_ATTR, CDATA, documentId);
            }
            handler.startElement(URI, RESULT, QRESULT, attributes);
            try {
                result.getContentAsSAX((ContentHandler)includeHandler);
            }
            catch (XMLDBException xde) {
                Object content = result.getContent();
                if (content instanceof String) {
                    String text = (String)content;
                    handler.characters(text.toCharArray(), 0, text.length());
                }
                throw xde;
            }
            handler.endElement(URI, RESULT, QRESULT);
        }
        handler.endElement(URI, RESULTSET, QRESULTSET);
        handler.endPrefixMapping(PREFIX);
        handler.endDocument();
    }

    public String getURI() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength() {
        long result = -1L;
        try {
            this.setup();
            result = new Integer(((EXistResource)this.resource).getContentLength()).longValue();
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("getContentLength() for " + this.resName + " from collection " + this.url + " failed: " + e.getMessage());
            }
        }
        finally {
            this.cleanup();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        long result = 0L;
        try {
            this.setup();
            if (this.status == 1) {
                result = ((CollectionImpl)this.collection).getCreationTime().getTime();
            } else if (this.status == 2) {
                result = ((EXistResource)this.resource).getLastModificationTime().getTime();
            }
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("getLastModified() for " + this.resName + " from collection " + this.url + " failed: " + e.getMessage());
            }
        }
        finally {
            this.cleanup();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        try {
            this.setup();
            boolean bl = this.status == 1 || this.status == 2;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup();
        }
    }

    public String getMimeType() {
        return null;
    }

    public String getScheme() {
        return SourceUtil.getScheme((String)this.url);
    }

    public SourceValidity getValidity() {
        try {
            if (this.resource == null || this.collection == null) {
                this.setup();
            }
            if (this.resource != null && this.resource instanceof AbstractEXistResource) {
                return new TimeStampValidity(((AbstractEXistResource)this.resource).getLastModificationTime().getTime());
            }
        }
        catch (XMLDBException e) {
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        return null;
    }

    public void refresh() {
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.setup();
            if (this.resource instanceof BinaryResource) {
                Object obj = this.resource.getContent();
                if (obj == null) {
                    obj = new byte[0];
                }
                if (obj instanceof byte[]) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])obj);
                    return byteArrayInputStream;
                }
                throw new SourceException("Binary resource has returned a " + obj.getClass() + " for " + this.getURI());
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            TransformerHandler th = ((SAXTransformerFactory)tf).newTransformerHandler();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bOut);
            th.setResult(result);
            this.toSAX(th);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bOut.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new CascadingIOException("Exception during processing of " + this.getURI(), (Throwable)e);
        }
        finally {
            this.cleanup();
        }
    }

    public OutputStream getOutputStream() throws IOException, MalformedURLException {
        if (this.query != null) {
            throw new MalformedURLException("Cannot modify a resource that includes an XPATH expression");
        }
        return new XMLDBOutputStream(false);
    }

    public void setContentAsDOM(Node doc) throws IOException, MalformedURLException {
        try {
            if (this.query != null) {
                throw new MalformedURLException("Cannot modify a resource that includes an XPATH expression");
            }
            this.setup();
            if (this.status == 3) {
                this.collection = this.createCollection(this.colPath);
                this.status = 4;
            }
            this.resource = this.collection.createResource(this.resName, "XMLResource");
            ((XMLResource)this.resource).setContentAsDOM(doc);
            this.collection.storeResource(this.resource);
        }
        catch (XMLDBException e) {
            String message = "Failed to create resource " + this.resName + ": " + e.errorCode;
            e.printStackTrace(System.out);
            throw new SourceException(message, (Throwable)e);
        }
    }

    public Node getContentAsDOM() throws IOException, MalformedURLException {
        try {
            this.setup();
            if (!(this.resource instanceof XMLResource)) {
                throw new SourceException("Not an XML resource: " + this.getURI());
            }
            if (this.query != null) {
                throw new MalformedURLException("Not yet available for queries, only for single resource.");
            }
            String name = this.resName;
            this.resource = this.collection.createResource(name, "XMLResource");
            return ((XMLResource)this.resource).getContentAsDOM();
        }
        catch (XMLDBException e) {
            String message = "Failed to create resource " + this.resName + ": " + e.errorCode;
            throw new SourceException(message, (Throwable)e);
        }
    }

    public OutputStream getBinaryOutputStream() throws IOException, MalformedURLException {
        if (this.query != null) {
            throw new MalformedURLException("Cannot modify a resource that includes an XPATH expression");
        }
        return new XMLDBOutputStream(true);
    }

    public String createId() throws SourceException {
        try {
            this.setup();
            if (this.status != 1) {
                throw new SourceNotFoundException("Collection for createId not found: " + this.getURI());
            }
            String string = this.collection.createId();
            return string;
        }
        catch (XMLDBException xdbe) {
            throw new SourceException("Cannot get Id for " + this.getURI(), (Throwable)xdbe);
        }
        finally {
            this.cleanup();
        }
    }

    private void writeOutputStream(ByteArrayOutputStream baos, boolean binary) throws SourceException {
        try {
            Resource resource;
            this.setup();
            if (this.status == 3) {
                this.collection = this.createCollection(this.colPath);
                this.status = 4;
            }
            String name = this.status == 1 ? this.collection.createId() : this.resName;
            if (binary) {
                resource = this.collection.createResource(name, "BinaryResource");
                resource.setContent((Object)baos.toByteArray());
            } else {
                resource = this.collection.createResource(name, "XMLResource");
                resource.setContent((Object)new String(baos.toByteArray(), this.encoding));
            }
            this.collection.storeResource(resource);
            this.getLogger().debug("Written to resource " + this.resName);
        }
        catch (XMLDBException e) {
            String message = "Failed to create resource " + this.resName + ": " + e.errorCode;
            throw new SourceException(message, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            String message = "Encoding for the resource " + this.resName + this.encoding;
            throw new SourceException(message, (Throwable)e);
        }
        finally {
            this.cleanup();
        }
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void delete() throws SourceException {
        try {
            this.setup();
            if (this.status == 2) {
                this.collection.removeResource(this.resource);
            } else if (this.status == 1) {
                org.xmldb.api.base.Collection parent = this.collection.getParentCollection();
                CollectionManagementService service = (CollectionManagementService)parent.getService("CollectionManagementService", "1.0");
                service.removeCollection(this.collection.getName());
                this.close(parent);
            }
        }
        catch (SourceException se) {
            throw se;
        }
        catch (XMLDBException xdbe) {
            throw new SourceException("Could not delete " + this.getURI());
        }
        finally {
            this.cleanup();
        }
    }

    public boolean canCancel(OutputStream stream) {
        return stream instanceof XMLDBOutputStream && !((XMLDBOutputStream)stream).isClosed();
    }

    public void cancel(OutputStream stream) throws IOException {
        if (!this.canCancel(stream)) {
            throw new SourceException("Cannot cancel stream for " + this.getURI());
        }
        ((XMLDBOutputStream)stream).cancel();
    }

    public void makeCollection() throws SourceException {
        try {
            this.createCollection(this.url);
        }
        catch (SourceException e) {
            throw e;
        }
        catch (XMLDBException e) {
            throw new SourceException("Cannot make collection with " + this.getURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollection() {
        try {
            this.setup();
            boolean bl = this.status == 1;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup();
        }
    }

    public Collection getChildren() throws SourceException {
        try {
            int i;
            this.setup();
            if (this.status != 1) {
                throw new SourceException("Not a collection: " + this.getURI());
            }
            String[] childColl = this.collection.listChildCollections();
            String[] childRes = this.collection.listResources();
            ArrayList<XMLDBSource> children = new ArrayList<XMLDBSource>(childColl.length + childRes.length);
            for (i = 0; i < childColl.length; ++i) {
                children.add(new XMLDBSource(this.getLogger(), this.user, this.password, this.url + "/" + childColl[i]));
            }
            for (i = 0; i < childRes.length; ++i) {
                children.add(new XMLDBSource(this.getLogger(), this.user, this.password, this.url + "/" + childRes[i]));
            }
            ArrayList<XMLDBSource> arrayList = children;
            return arrayList;
        }
        catch (SourceException e) {
            throw e;
        }
        catch (XMLDBException e) {
            throw new SourceException("Cannot list children of " + this.getURI());
        }
        finally {
            this.cleanup();
        }
    }

    public Source getChild(String name) throws SourceException {
        return new XMLDBSource(this.getLogger(), this.user, this.password, this.url + "/" + name);
    }

    public String getName() {
        return this.resName;
    }

    public Source getParent() throws SourceException {
        return new XMLDBSource(this.getLogger(), this.user, this.password, this.colPath);
    }

    private class XMLDBOutputStream
    extends OutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private boolean isClosed = false;
        private boolean binary;

        public XMLDBOutputStream(boolean binary) {
            this.binary = binary;
        }

        public void write(int b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
        }

        public void close() throws IOException, SourceException {
            if (!this.isClosed) {
                XMLDBSource.this.writeOutputStream(this.baos, this.binary);
                this.baos.close();
                this.isClosed = true;
            }
        }

        public void flush() throws IOException {
        }

        public int size() {
            return this.baos.size();
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public void cancel() {
            this.isClosed = true;
        }
    }
}

