/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cocoon;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.helpers.SourceCredential;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.exist.cocoon.XMLDBSource;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public final class XMLDBSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Configurable,
ThreadSafe {
    protected HashMap credentialMap;
    protected HashMap baseMap;

    public void configure(Configuration conf) throws ConfigurationException {
        this.credentialMap = new HashMap();
        this.baseMap = new HashMap();
        Configuration[] drivers = conf.getChildren("driver");
        for (int i = 0; i < drivers.length; ++i) {
            String msg;
            String type = drivers[i].getAttribute("type");
            String driver = drivers[i].getAttribute("class");
            SourceCredential credential = new SourceCredential(null, null);
            credential.setPrincipal(drivers[i].getAttribute("user", null));
            credential.setPassword(drivers[i].getAttribute("password", null));
            this.credentialMap.put(type, credential);
            String base = drivers[i].getAttribute("collection", null);
            if (base != null && base.length() > 0) {
                if (base.charAt(base.length() - 1) != '/') {
                    base = base + '/';
                }
                this.baseMap.put(type, base);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Initializing XML:DB connection, using driver " + driver);
            }
            try {
                Database db = (Database)Class.forName(driver).newInstance();
                Configuration[] params = drivers[i].getChildren();
                for (int j = 0; j < params.length; ++j) {
                    db.setProperty(params[j].getName(), params[j].getValue());
                }
                DatabaseManager.registerDatabase((Database)db);
                continue;
            }
            catch (XMLDBException e) {
                msg = "Unable to connect to the XMLDB database '" + type + "'." + " Error " + e.errorCode + ": " + e.getMessage();
                this.getLogger().debug(msg, (Throwable)e);
                throw new ConfigurationException(msg, (Throwable)e);
            }
            catch (Exception e) {
                msg = "Unable to load XMLDB database driver '" + driver + "'." + " Make sure that the driver is available. Error: " + e.getMessage();
                this.getLogger().debug(msg, (Throwable)e);
                throw new ConfigurationException(msg, (Throwable)e);
            }
        }
    }

    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException {
        String path;
        int start = location.indexOf(58) + 1;
        int end = location.indexOf(58, start);
        if (start == 0 || end == -1) {
            throw new MalformedURLException("Mispelled XML:DB URL. The syntax is \"xmldb:databasetype://host/collection/resource\"");
        }
        String type = location.substring(start, end);
        SourceCredential credential = (SourceCredential)this.credentialMap.get(type);
        if (credential == null) {
            throw new MalformedURLException("xmldb type '" + type + "' is unknown for URL " + location);
        }
        String base = (String)this.baseMap.get(type);
        if (base != null && base.length() > 0 && !(path = location.substring(end + 1)).startsWith("//")) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            location = location.substring(0, end + 1) + base + path;
        }
        return new XMLDBSource(this.getLogger(), credential.getPrincipal(), credential.getPassword(), location);
    }

    public void release(Source source) {
    }
}

