/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cocoon;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.exist.xmldb.XPathQueryServiceImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;
import org.xmldb.api.modules.XUpdateQueryService;

public class XMLDBTransformer
extends AbstractSAXTransformer
implements Poolable {
    public String DEFAULT_DRIVER = "org.exist.xmldb.DatabaseImpl";
    public String DEFAULT_USER = "guest";
    public String DEFAULT_PASSWORD = "guest";
    public static final String NAMESPACE = "http://exist-db.org/transformer/1.0";
    public static final String COLLECTION_ELEMENT = "collection";
    public static final String FOR_EACH_ELEMENT = "for-each";
    public static final String CURRENT_NODE_ELEMENT = "current-node";
    public static final String SELECT_NODE = "select-node";
    public static final String RESULT_SET_ELEMENT = "result-set";
    public static final String XUPDATE_ELEMENT = "update";
    public static final String ERROR_ELEMENT = "error";
    public static final String ERRMSG_ELEMENT = "message";
    public static final String STACKTRACE_ELEMENT = "stacktrace";
    public static final String PREFIX = "xdb:";
    public static final String FATAL_ERROR = "fatal";
    public static final String WARNING = "warn";
    public static final String INFO = "info";
    public static final int IN_COLLECTION = 1;
    public static final int IN_QUERY = 2;
    private String driver = null;
    private String user = null;
    private String password = null;
    private String xpath = null;
    private Collection collection = null;
    private Stack commandStack = new Stack();
    private boolean isRecording = false;
    private int nesting = 0;
    private int mode = 0;
    private XMLResource currentResource = null;
    private HashMap namespaces = new HashMap(20);
    private String prefix = null;
    private StringWriter queryWriter;
    private TransformerHandler queryHandler;
    private SAXTransformerFactory tfactory = null;

    public void setup(SourceResolver resolver, Map map, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, map, src, parameters);
        this.driver = parameters.getParameter("driver", this.DEFAULT_DRIVER);
        this.user = parameters.getParameter("user", this.DEFAULT_USER);
        this.password = parameters.getParameter("password", this.DEFAULT_PASSWORD);
        if (this.request == null) {
            throw new ProcessingException("no request object found");
        }
        this.setupDatabase();
    }

    public void startElement(String uri, String localName, String qname, Attributes attribs) throws SAXException {
        if (this.queryHandler != null) {
            this.queryHandler.startElement(uri, localName, qname, attribs);
        } else if (this.isRecording) {
            if (NAMESPACE.equals(uri) && FOR_EACH_ELEMENT.equals(localName)) {
                ++this.nesting;
            }
            super.startElement(uri, localName, qname, attribs);
        } else if (NAMESPACE.equals(uri)) {
            if (COLLECTION_ELEMENT.equals(localName)) {
                this.prefix = qname.endsWith(localName) ? qname.substring(0, qname.length() - localName.length()) : PREFIX;
                this.startCollection(attribs);
            } else if (FOR_EACH_ELEMENT.equals(localName)) {
                this.startForEach(attribs);
            } else if (CURRENT_NODE_ELEMENT.equals(localName)) {
                this.startCurrent(attribs);
            } else if (SELECT_NODE.equals(localName)) {
                this.startSelectNode(attribs);
            } else if (XUPDATE_ELEMENT.equals(localName)) {
                this.startXUpdate(attribs);
            }
        } else if (this.currentResource != null) {
            try {
                AttributesImpl a = new AttributesImpl(attribs);
                a.addAttribute(NAMESPACE, "document-id", this.prefix + "document-id", "CDATA", this.currentResource.getDocumentId());
                a.addAttribute(NAMESPACE, COLLECTION_ELEMENT, this.prefix + COLLECTION_ELEMENT, "CDATA", this.currentResource.getParentCollection().getName());
                super.startElement(uri, localName, qname, (Attributes)a);
                this.currentResource = null;
            }
            catch (XMLDBException e) {}
        } else {
            super.startElement(uri, localName, qname, attribs);
        }
    }

    protected void startCollection(Attributes attribs) throws SAXException {
        String uri = attribs.getValue("uri");
        if (uri == null) {
            this.reportError(FATAL_ERROR, "element collection requires an uri-attribute");
            return;
        }
        String pUser = attribs.getValue("user");
        String pPassword = attribs.getValue("password");
        if (pUser == null) {
            pUser = this.user;
        }
        if (pPassword == null) {
            pPassword = this.password;
        }
        try {
            this.collection = DatabaseManager.getCollection((String)uri, (String)pUser, (String)pPassword);
            if (this.collection == null) {
                this.reportError(WARNING, "collection " + uri + " not found");
                return;
            }
        }
        catch (XMLDBException e) {
            this.reportError(WARNING, "failed to retrieve collection", (Exception)((Object)e));
        }
        this.mode = 1;
    }

    protected void startCurrent(Attributes attribs) throws SAXException {
        if (this.commandStack.isEmpty()) {
            return;
        }
        ForEach each = (ForEach)this.commandStack.peek();
        try {
            if (each.currentResource != null) {
                each.currentResource.getContentAsSAX((ContentHandler)((Object)this));
            }
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
    }

    protected SAXTransformerFactory getTransformerFactory() {
        if (this.tfactory == null) {
            this.tfactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        return this.tfactory;
    }

    protected void startXUpdate(Attributes attribs) throws SAXException {
        if (this.collection == null) {
            this.reportError(FATAL_ERROR, "no collection selected");
            return;
        }
        this.queryWriter = new StringWriter(256);
        try {
            this.queryHandler = this.getTransformerFactory().newTransformerHandler();
            this.queryHandler.setResult(new StreamResult(this.queryWriter));
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException("Failed to get transformer handler", e);
        }
        this.queryHandler.startDocument();
        Iterator i = this.namespaces.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.queryHandler.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected void endXUpdate() throws SAXException {
        try {
            XUpdateQueryService service = (XUpdateQueryService)this.collection.getService("XUpdateQueryService", "1.0");
            long l = service.update(this.queryWriter.toString());
        }
        catch (XMLDBException e) {
            this.reportError(FATAL_ERROR, "Unable to perform update: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void startSelectNode(Attributes attribs) throws SAXException {
        if (this.collection == null) {
            this.reportError(FATAL_ERROR, "no collection selected");
            return;
        }
        XMLResource resource = null;
        if (!this.commandStack.isEmpty()) {
            ForEach last = (ForEach)this.commandStack.peek();
            resource = last.currentResource;
        }
        this.xpath = attribs.getValue("query");
        if (this.xpath == null) {
            this.reportError(FATAL_ERROR, "attribute 'query' is missing");
            return;
        }
        String pHighlightElementMatches = attribs.getValue("match-tagging-elements");
        boolean highlightElementMatches = true;
        if (pHighlightElementMatches != null) {
            highlightElementMatches = pHighlightElementMatches.equals("true");
        }
        String pHighlightAttributeMatches = attribs.getValue("match-tagging-attributes");
        boolean highlightAttributeMatches = false;
        if (pHighlightAttributeMatches != null) {
            highlightAttributeMatches = pHighlightAttributeMatches.equals("true");
        }
        long start = System.currentTimeMillis();
        try {
            ResourceSet queryResult;
            XPathQueryServiceImpl service = (XPathQueryServiceImpl)this.collection.getService("XPathQueryService", "1.0");
            service.setProperty("sax-document-events", "false");
            String highlighting = "none";
            if (highlightElementMatches && highlightAttributeMatches) {
                highlighting = "both";
            } else if (highlightElementMatches) {
                highlighting = "elements";
            } else if (highlightAttributeMatches) {
                highlighting = "attributes";
            }
            service.setProperty("highlight-matches", highlighting);
            this.setQueryContext((XPathQueryService)service);
            ResourceSet resourceSet = queryResult = resource == null ? service.query(this.xpath) : service.query(resource, this.xpath);
            if (queryResult == null) {
                this.reportError(WARNING, "query returned null");
                return;
            }
            long len = queryResult.getSize();
            for (long i = 0L; i < len; ++i) {
                XMLResource res = (XMLResource)queryResult.getResource(i);
                res.getContentAsSAX((ContentHandler)((Object)this));
            }
        }
        catch (XMLDBException e) {
            this.reportError(WARNING, "error during query-execution", (Exception)((Object)e));
        }
    }

    protected void startForEach(Attributes attribs) throws SAXException {
        String pTo;
        boolean nested;
        if (this.collection == null) {
            this.reportError(FATAL_ERROR, "no collection selected");
            return;
        }
        ForEach each = new ForEach();
        XMLResource resource = null;
        boolean bl = nested = !this.commandStack.isEmpty();
        if (nested) {
            ForEach last = (ForEach)this.commandStack.peek();
            resource = last.currentResource;
        }
        this.commandStack.push(each);
        this.xpath = attribs.getValue("query");
        if (this.xpath == null) {
            this.reportError(FATAL_ERROR, "attribute 'query' is missing");
            return;
        }
        each.query = this.xpath;
        String sortExpr = attribs.getValue("sort-by");
        String pFrom = attribs.getValue("from");
        if (pFrom != null) {
            try {
                each.from = Integer.parseInt(pFrom);
            }
            catch (NumberFormatException e) {
                this.reportError(WARNING, "attribute 'from' requires numeric value");
            }
        }
        if ((pTo = attribs.getValue("to")) != null) {
            try {
                each.to = Integer.parseInt(pTo);
            }
            catch (NumberFormatException e) {
                this.reportError(WARNING, "attribute 'to' requires numeric value");
            }
        }
        String pHighlightElementMatches = attribs.getValue("match-tagging-elements");
        boolean highlightElementMatches = true;
        if (pHighlightElementMatches != null) {
            highlightElementMatches = pHighlightElementMatches.equals("true");
        }
        String pHighlightAttributeMatches = attribs.getValue("match-tagging-attributes");
        boolean highlightAttributeMatches = false;
        if (pHighlightAttributeMatches != null) {
            highlightAttributeMatches = pHighlightAttributeMatches.equals("true");
        }
        String pSession = attribs.getValue("use-session");
        boolean createSession = false;
        if (pSession != null) {
            createSession = pSession.equals("true");
        }
        Session session = null;
        if (createSession) {
            session = this.request.getSession(true);
        }
        long start = System.currentTimeMillis();
        try {
            ResourceSet queryResult = null;
            XPathQueryServiceImpl service = (XPathQueryServiceImpl)this.collection.getService("XPathQueryService", "1.0");
            service.setProperty("sax-document-events", "false");
            String highlighting = "none";
            if (highlightElementMatches && highlightAttributeMatches) {
                highlighting = "both";
            } else if (highlightElementMatches) {
                highlighting = "elements";
            } else if (highlightAttributeMatches) {
                highlighting = "attributes";
            }
            service.setProperty("highlight-matches", highlighting);
            this.setQueryContext((XPathQueryService)service);
            if (createSession && resource == null) {
                queryResult = (ResourceSet)session.getAttribute(this.xpath);
            }
            if (queryResult == null) {
                ResourceSet resourceSet = queryResult = resource == null ? service.query(this.xpath, sortExpr) : service.query(resource, this.xpath, sortExpr);
                if (createSession) {
                    session.setAttribute(this.xpath, (Object)queryResult);
                }
            }
            if (queryResult == null) {
                this.reportError(WARNING, "query returned null");
                return;
            }
            each.queryResult = queryResult;
            int size = (int)each.queryResult.getSize();
            if (each.from < 0) {
                each.from = 0;
            }
            if (each.to < 0 || each.to >= size) {
                each.to = size - 1;
            }
            if (!nested) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "count", "count", "CDATA", queryResult == null ? "0" : Long.toString(queryResult.getSize()));
                atts.addAttribute("", "xpath", "xpath", "CDATA", this.xpath);
                atts.addAttribute("", "query-time", "query-time", "CDATA", Long.toString(System.currentTimeMillis() - start));
                atts.addAttribute("", "from", "from", "CDATA", Integer.toString(each.from));
                atts.addAttribute("", "to", "to", "CDATA", Integer.toString(each.to));
                super.startElement(NAMESPACE, RESULT_SET_ELEMENT, this.prefix + RESULT_SET_ELEMENT, (Attributes)atts);
            }
        }
        catch (XMLDBException e) {
            this.reportError(FATAL_ERROR, e.getMessage(), (Exception)((Object)e));
            this.commandStack.pop();
            return;
        }
        ++this.nesting;
        this.isRecording = true;
        this.startRecording();
    }

    protected void setupDatabase() throws ProcessingException {
        try {
            Class<?> clazz = Class.forName(this.driver);
            Database database = (Database)clazz.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            throw new ProcessingException("failed to setup database", (Throwable)e);
        }
    }

    protected void reportError(String type, String message) throws SAXException {
        this.reportError(type, message, null);
    }

    protected void reportError(String type, String message, Exception cause) throws SAXException {
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "type", "type", "CDATA", type);
        super.startPrefixMapping(PREFIX, NAMESPACE);
        super.startElement(NAMESPACE, ERROR_ELEMENT, "xdb:error", (Attributes)attribs);
        super.startElement(NAMESPACE, ERRMSG_ELEMENT, "xdb:message", (Attributes)new AttributesImpl());
        super.characters(message.toCharArray(), 0, message.length());
        super.endElement(NAMESPACE, ERRMSG_ELEMENT, "xdb:message");
        if (cause != null) {
            PrintWriter writer = new PrintWriter(new StringWriter());
            cause.printStackTrace(writer);
            String trace = cause.toString();
            super.startElement(NAMESPACE, STACKTRACE_ELEMENT, "xdb:stacktrace", (Attributes)new AttributesImpl());
            super.characters(trace.toCharArray(), 0, trace.length());
            super.endElement(NAMESPACE, STACKTRACE_ELEMENT, "xdb:stacktrace");
        }
        super.endElement(NAMESPACE, ERROR_ELEMENT, "xdb:error");
        super.endPrefixMapping(PREFIX);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (!(this.queryHandler == null || NAMESPACE.equals(uri) && XUPDATE_ELEMENT.equals(loc))) {
            this.queryHandler.endElement(uri, loc, raw);
        } else if (NAMESPACE.equals(uri) && XUPDATE_ELEMENT.equals(loc)) {
            Iterator i = this.namespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.queryHandler.endPrefixMapping((String)entry.getKey());
            }
            this.endXUpdate();
            this.queryHandler = null;
        } else if (this.isRecording) {
            if (NAMESPACE.equals(uri) && FOR_EACH_ELEMENT.equals(loc) && --this.nesting == 0) {
                this.endForEach();
            } else {
                super.endElement(uri, loc, raw);
            }
        } else {
            if (NAMESPACE.equals(uri)) {
                if (COLLECTION_ELEMENT.equals(loc)) {
                    this.collection = null;
                    this.mode = 0;
                } else if (FOR_EACH_ELEMENT.equals(loc)) {
                    this.endForEach();
                }
                return;
            }
            super.endElement(uri, loc, raw);
        }
    }

    protected void endForEach() throws SAXException {
        this.isRecording = false;
        if (this.commandStack.isEmpty()) {
            return;
        }
        ForEach each = (ForEach)this.commandStack.peek();
        DocumentFragment fragment = this.endRecording();
        if (each.queryResult == null) {
            return;
        }
        DOMStreamer streamer = new DOMStreamer((XMLConsumer)this);
        each.current = each.from;
        while (each.current <= (long)each.to) {
            try {
                this.currentResource = each.currentResource = (XMLResource)each.queryResult.getResource(each.current);
                streamer.stream((Node)fragment);
            }
            catch (XMLDBException e) {
                this.reportError(WARNING, "error while retrieving resource " + each.current, (Exception)((Object)e));
            }
            ++each.current;
        }
        this.commandStack.pop();
        if (this.commandStack.isEmpty()) {
            super.endElement(NAMESPACE, RESULT_SET_ELEMENT, this.prefix + RESULT_SET_ELEMENT);
        }
    }

    public void recycle() {
        this.collection = null;
        this.mode = 0;
        this.xpath = null;
        this.commandStack.clear();
        this.nesting = 0;
    }

    public void characters(char[] p0, int p1, int p2) throws SAXException {
        if (this.queryHandler != null) {
            this.queryHandler.characters(p0, p1, p2);
        } else {
            super.characters(p0, p1, p2);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        Configuration child = configuration.getChild("user", false);
        if (child != null) {
            this.DEFAULT_USER = child.getValue();
        }
        if ((child = configuration.getChild("password", false)) != null) {
            this.DEFAULT_PASSWORD = child.getValue();
        }
        if ((child = configuration.getChild("driver", false)) != null) {
            this.DEFAULT_DRIVER = child.getValue();
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
        super.endPrefixMapping(prefix);
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        this.namespaces.put(prefix, namespaceURI);
        super.startPrefixMapping(prefix, namespaceURI);
    }

    private void setQueryContext(XPathQueryService service) {
        Iterator i = this.namespaces.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            try {
                service.setNamespace((String)entry.getKey(), (String)entry.getValue());
            }
            catch (XMLDBException e) {}
        }
    }

    protected class ForEach {
        ResourceSet queryResult = null;
        String query = null;
        int from = -1;
        int to = -1;
        XMLResource currentResource = null;
        long current = 0L;
    }
}

