/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cocoon;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;
import org.exist.cocoon.CocoonRequestWrapper;
import org.exist.cocoon.CocoonResponseWrapper;
import org.exist.cocoon.CocoonSessionWrapper;
import org.exist.http.Descriptor;
import org.exist.source.CocoonSource;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.XQueryService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XQueryGenerator
extends ServiceableGenerator
implements Configurable,
Parameterizable,
CacheableProcessingComponent {
    public static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    private Source inputSource = null;
    private Map objectModel = null;
    private boolean createSession;
    private boolean defaultCreateSession = false;
    private static final String CREATE_SESSION = "create-session";
    private boolean expandXIncludes;
    private boolean defaultExpandXIncludes = false;
    private static final String EXPAND_XINCLUDES = "expand-xincludes";
    private XmldbURI collectionURI;
    private XmldbURI defaultCollectionURI = XmldbURI.EMBEDDED_SERVER_URI.append(XmldbURI.ROOT_COLLECTION_URI);
    private static final String COLLECTION_URI = "collection";
    private long cacheValidity;
    private long defaultCacheValidity = -1L;
    private static final String CACHE_VALIDITY = "cache-validity";
    private String user;
    private String defaultUser = "guest";
    private static final String USER = "user";
    private String password;
    private String defaultPassword = "guest";
    private static final String PASSWORD = "password";
    private String authen;
    private String defaultAuthen = "session";
    private static final String AUTHEN = "authen";
    private Map optionalParameters;
    private Parameters componentParams;

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, source, parameters);
        this.optionalParameters = new TreeMap();
        String[] paramNames = this.componentParams.getNames();
        for (int i = 0; i < paramNames.length; ++i) {
            String param = paramNames[i];
            try {
                this.optionalParameters.put(param, this.componentParams.getParameter(param));
                continue;
            }
            catch (ParameterException e1) {
                // empty catch block
            }
        }
        this.objectModel = objectModel;
        this.inputSource = resolver.resolveURI(source);
        String paramCollectionURI = parameters.getParameter(COLLECTION_URI, null);
        if (paramCollectionURI != null) {
            try {
                this.collectionURI = XmldbURI.xmldbUriFor((String)paramCollectionURI);
            }
            catch (URISyntaxException e) {
                throw new ProcessingException("Invalid XmldbURI for parameter 'collection': " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.collectionURI = this.defaultCollectionURI;
        }
        this.authen = parameters.getParameter(AUTHEN, this.defaultAuthen);
        this.user = parameters.getParameter(USER, this.defaultUser);
        this.password = parameters.getParameter(PASSWORD, this.defaultPassword);
        this.createSession = parameters.getParameterAsBoolean(CREATE_SESSION, this.defaultCreateSession);
        this.expandXIncludes = parameters.getParameterAsBoolean(EXPAND_XINCLUDES, this.defaultExpandXIncludes);
        this.cacheValidity = parameters.getParameterAsLong(CACHE_VALIDITY, this.defaultCacheValidity);
        paramNames = parameters.getNames();
        for (int i = 0; i < paramNames.length; ++i) {
            String param = paramNames[i];
            if (param.equals(COLLECTION_URI) || param.equals(USER) || param.equals(PASSWORD) || param.equals(AUTHEN) || param.equals(CREATE_SESSION) || param.equals(EXPAND_XINCLUDES) || param.equals(CACHE_VALIDITY)) continue;
            this.optionalParameters.put(param, parameters.getParameter(param, ""));
        }
        Context context = ObjectModelHelper.getContext((Map)objectModel);
        String dbHome = context.getRealPath("WEB-INF");
        try {
            Class<?> driver = Class.forName(this.getDriverName());
            Database database = (Database)driver.newInstance();
            database.setProperty("create-database", "true");
            database.setProperty("configuration", dbHome + File.separatorChar + "conf.xml");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to initialize database driver: " + e.getMessage(), (Throwable)e);
        }
    }

    public void recycle() {
        if (this.resolver != null) {
            this.resolver.release(this.inputSource);
        }
        this.inputSource = null;
        super.recycle();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        int p;
        if (this.inputSource == null) {
            throw new ProcessingException("No input source");
        }
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        Context context = ObjectModelHelper.getContext((Map)this.objectModel);
        Session session = request.getSession(this.createSession);
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        StringBuffer moduleLoadPathBuffer = new StringBuffer(servletPath);
        if (pathInfo != null) {
            moduleLoadPathBuffer.append(pathInfo);
        }
        if ((p = moduleLoadPathBuffer.lastIndexOf("/")) != -1) {
            moduleLoadPathBuffer.delete(p, moduleLoadPathBuffer.length());
        }
        String moduleLoadPath = context.getRealPath(moduleLoadPathBuffer.toString());
        XmldbURI baseUri = this.collectionURI;
        if (pathInfo != null) {
            baseUri = baseUri.append(request.getPathInfo());
        }
        if (session != null && this.authen.equals("session") && request.isRequestedSessionIdValid()) {
            String actualUser = this.getSessionAttribute(session, USER);
            String actualPass = this.getSessionAttribute(session, PASSWORD);
            this.user = actualUser == null ? null : String.valueOf(actualUser);
            String string = this.password = actualPass == null ? null : String.valueOf(actualPass);
        }
        if (this.user == null) {
            this.user = this.defaultUser;
        }
        if (this.password == null) {
            this.password = this.defaultPassword;
        }
        try {
            Object includeContentHandler;
            Collection collection = DatabaseManager.getCollection((String)this.collectionURI.toString(), (String)this.user, (String)this.password);
            if (collection == null) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Collection " + this.collectionURI + " not found");
                }
                throw new ProcessingException("Collection " + this.collectionURI + " not found");
            }
            XQueryService service = (XQueryService)collection.getService("XQueryService", "1.0");
            service.setProperty("sax-document-events", "false");
            service.setProperty(EXPAND_XINCLUDES, this.expandXIncludes ? "yes" : "no");
            service.setProperty("base-uri", baseUri.toString());
            service.setModuleLoadPath(moduleLoadPath);
            if (!((CollectionImpl)collection).isRemoteCollection()) {
                HttpServletRequest httpRequest = (HttpServletRequest)this.objectModel.get("httprequest");
                service.declareVariable("request:request", (Object)new CocoonRequestWrapper(request, httpRequest));
                service.declareVariable("request:request", (Object)new CocoonRequestWrapper(request, httpRequest));
                service.declareVariable("response:response", (Object)new CocoonResponseWrapper(response));
                if (session != null) {
                    service.declareVariable("session:session", (Object)new CocoonSessionWrapper(session));
                }
                includeContentHandler = this.contentHandler;
            } else {
                includeContentHandler = new IncludeXMLConsumer(this.contentHandler);
            }
            this.declareParameters(service);
            XQueryGenerator.log(request, service, this);
            ResourceSet result = service.execute((org.exist.source.Source)new CocoonSource(this.inputSource, true));
            this.contentHandler.startDocument();
            for (long i = 0L; i < result.getSize(); ++i) {
                XMLResource resource = (XMLResource)result.getResource(i);
                resource.getContentAsSAX((ContentHandler)includeContentHandler);
            }
            this.contentHandler.endDocument();
        }
        catch (XMLDBException e) {
            throw new ProcessingException("XMLDBException occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    private void declareParameters(XQueryService service) throws XMLDBException {
        Iterator i = this.optionalParameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            service.declareVariable((String)entry.getKey(), entry.getValue());
        }
    }

    private String getSessionAttribute(Session session, String attribute) {
        Object obj = session.getAttribute(attribute);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Sequence) {
            try {
                return ((Sequence)obj).getStringValue();
            }
            catch (XPathException e) {
                return null;
            }
        }
        return obj.toString();
    }

    public void configure(Configuration config) throws ConfigurationException {
        String paramCollectionURI = config.getAttribute(COLLECTION_URI, null);
        if (paramCollectionURI != null) {
            try {
                this.defaultCollectionURI = XmldbURI.xmldbUriFor((String)paramCollectionURI);
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException("Invalid XmldbURI for config attribute 'collection': " + e.getMessage(), (Throwable)e);
            }
        }
        this.defaultCreateSession = config.getAttributeAsBoolean(CREATE_SESSION, this.defaultCreateSession);
        this.defaultExpandXIncludes = config.getAttributeAsBoolean(EXPAND_XINCLUDES, this.defaultExpandXIncludes);
        this.defaultPassword = config.getAttribute(PASSWORD, this.defaultPassword);
        this.defaultUser = config.getAttribute(USER, this.defaultUser);
        this.defaultCacheValidity = config.getAttributeAsLong(CACHE_VALIDITY, this.defaultCacheValidity);
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.componentParams = params;
    }

    public Serializable getKey() {
        StringBuffer key = new StringBuffer();
        key.append(this.optionalParameters.toString());
        key.append(this.inputSource.getURI());
        return key.toString();
    }

    public SourceValidity getValidity() {
        if (this.cacheValidity != -1L) {
            AggregatedValidity v = new AggregatedValidity();
            if (this.inputSource.getValidity() != null) {
                v.add(this.inputSource.getValidity());
            }
            v.add((SourceValidity)new ExpiresValidity(this.cacheValidity));
            return v;
        }
        return null;
    }

    HttpServletRequest getRequest() {
        return (HttpServletRequest)this.objectModel.get("httprequest");
    }

    private static void log(Request request, XQueryService service, XQueryGenerator generator) {
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor.allowRequestLogging()) {
            HttpServletRequest servletRequest = generator.getRequest();
            descriptor.doLogRequestInReplayLog(servletRequest);
        }
    }

    public String getDriverName() {
        return DRIVER;
    }
}

