/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.exist.http.servlets.Authenticator;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.util.Base64Decoder;

public class BasicAuthenticator
implements Authenticator {
    protected static final Logger LOG = Logger.getLogger((Class)BasicAuthenticator.class);
    private BrokerPool pool;

    public BasicAuthenticator(BrokerPool pool) {
        this.pool = pool;
    }

    public User authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String credentials = request.getHeader("Authorization");
        String username = null;
        String password = null;
        if (credentials != null) {
            Base64Decoder dec = new Base64Decoder();
            dec.translate((CharSequence)credentials.substring("Basic ".length()));
            byte[] c = dec.getByteArray();
            String s = new String(c);
            int p = s.indexOf(58);
            username = p < 0 ? s : s.substring(0, p);
            password = p < 0 ? null : s.substring(p + 1);
        }
        HttpSession session = request.getSession();
        User user = null;
        if (session != null && (user = (User)session.getAttribute("_eXist_xmldb_user")) != null && (username == null || user.getName().equals(username))) {
            return user;
        }
        if (user != null) {
            session.removeAttribute("_eXist_xmldb_user");
        }
        if (credentials == null) {
            this.sendChallenge(request, response);
            return null;
        }
        SecurityManager secman = this.pool.getSecurityManager();
        user = secman.getUser(username);
        if (user == null) {
            this.sendChallenge(request, response);
            return null;
        }
        if (!user.validate(password)) {
            this.sendChallenge(request, response);
            return null;
        }
        if (session != null) {
            session.setAttribute("_eXist_xmldb_user", (Object)user);
        }
        return user;
    }

    public void sendChallenge(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"exist\"");
        response.setStatus(401);
    }
}

