/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.http.BadRequestException;
import org.exist.http.Descriptor;
import org.exist.http.NotFoundException;
import org.exist.http.RESTServer;
import org.exist.http.SOAPServer;
import org.exist.http.servlets.Authenticator;
import org.exist.http.servlets.BasicAuthenticator;
import org.exist.http.servlets.HttpServletRequestWrapper;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.XmldbPrincipal;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.validation.XmlLibraryChecker;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class EXistServlet
extends HttpServlet {
    private String formEncoding = null;
    public static final String DEFAULT_ENCODING = "UTF-8";
    protected static final Logger LOG = Logger.getLogger((Class)EXistServlet.class);
    private BrokerPool pool = null;
    private String defaultUsername = "guest";
    private String defaultPassword = "guest";
    private RESTServer srvREST;
    private SOAPServer srvSOAP;
    private Authenticator authenticator;
    private User defaultUser;

    public void init(ServletConfig config) throws ServletException {
        String useDynamicContentType;
        String containerEncoding;
        super.init(config);
        try {
            if (BrokerPool.isConfigured()) {
                LOG.info((Object)"Database already started. Skipping configuration ...");
            } else {
                String confFile = config.getInitParameter("configuration");
                String dbHome = config.getInitParameter("basedir");
                String start = config.getInitParameter("start");
                if (confFile == null) {
                    confFile = "conf.xml";
                }
                dbHome = dbHome == null ? config.getServletContext().getRealPath(".") : config.getServletContext().getRealPath(dbHome);
                LOG.info((Object)("EXistServlet: exist.home=" + dbHome));
                File f = new File(dbHome + File.separator + confFile);
                LOG.info((Object)("reading configuration from " + f.getAbsolutePath()));
                if (!f.canRead()) {
                    throw new ServletException("configuration file " + confFile + " not found or not readable");
                }
                Configuration configuration = new Configuration(confFile, dbHome);
                if (start != null && start.equals("true")) {
                    this.startup(configuration);
                }
            }
            this.pool = BrokerPool.getInstance();
            String option = config.getInitParameter("use-default-user");
            boolean useDefaultUser = true;
            if (option != null) {
                useDefaultUser = option.trim().equals("true");
            }
            if (useDefaultUser) {
                option = config.getInitParameter("user");
                if (option != null) {
                    this.defaultUsername = option;
                }
                if ((option = config.getInitParameter("password")) != null) {
                    this.defaultPassword = option;
                }
                this.defaultUser = this.getDefaultUser();
                if (this.defaultUser != null) {
                    LOG.info((Object)("Using default user " + this.defaultUsername + " for all unauthorized requests."));
                } else {
                    LOG.error((Object)("Default user " + this.defaultUsername + " cannot be found.  A BASIC AUTH challenge will be the default."));
                }
            } else {
                LOG.info((Object)"No default user.  All requires must be authorized or will result in a BASIC AUTH challenge.");
                this.defaultUser = null;
            }
            this.authenticator = new BasicAuthenticator(this.pool);
        }
        catch (EXistException e) {
            throw new ServletException("No database instance available");
        }
        catch (DatabaseConfigurationException e) {
            throw new ServletException("Unable to configure database instance: " + e.getMessage(), (Throwable)e);
        }
        this.formEncoding = config.getInitParameter("form-encoding");
        if (this.formEncoding == null) {
            this.formEncoding = DEFAULT_ENCODING;
        }
        if ((containerEncoding = config.getInitParameter("container-encoding")) == null) {
            containerEncoding = DEFAULT_ENCODING;
        }
        if ((useDynamicContentType = config.getInitParameter("dynamic-content-type")) == null) {
            useDynamicContentType = "no";
        }
        this.srvREST = new RESTServer(this.pool, this.formEncoding, containerEncoding, useDynamicContentType.equalsIgnoreCase("yes") || useDynamicContentType.equalsIgnoreCase("true"));
        this.srvSOAP = new SOAPServer(this.formEncoding, containerEncoding);
        XmlLibraryChecker.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        User user;
        String path = this.adjustPath(request);
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor != null) {
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        DBBroker broker = null;
        File tempFile = null;
        try {
            XmldbURI dbpath = XmldbURI.create((String)path);
            broker = this.pool.get(user);
            Collection collection = broker.getCollection(dbpath);
            if (collection != null) {
                response.sendError(400, "A PUT request is not allowed against a plain collection path.");
                return;
            }
            ServletInputStream is = request.getInputStream();
            int len = request.getContentLength();
            tempFile = File.createTempFile("existSRV", ".tmp");
            FileOutputStream fos = new FileOutputStream(tempFile);
            BufferedOutputStream os = new BufferedOutputStream(fos);
            byte[] buffer = new byte[4096];
            int l = 0;
            if (len > 0) {
                int count;
                do {
                    if ((count = is.read(buffer)) <= 0) continue;
                    os.write(buffer, 0, count);
                } while ((l += count) < len);
            }
            os.close();
            this.srvREST.doPut(broker, tempFile, dbpath, request, response);
        }
        catch (BadRequestException e) {
            response.sendError(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            if (user.equals((Object)this.defaultUser)) {
                this.authenticator.sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (EXistException e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            if (broker != null) {
                this.pool.release(broker);
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private String adjustPath(HttpServletRequest request) {
        int p;
        String path = request.getPathInfo();
        if (path == null) {
            path = "";
        }
        if ((p = path.lastIndexOf(59)) != -1) {
            path = path.substring(0, p);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        User user;
        String path = this.adjustPath(request);
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor != null) {
            descriptor.doLogRequestInReplayLog(request);
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(user);
            if (path.indexOf(".xqws") > -1) {
                this.srvSOAP.doGet(broker, request, response, path);
            } else {
                this.srvREST.doGet(broker, request, response, path);
            }
        }
        catch (BadRequestException e) {
            response.sendError(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            if (user.equals((Object)this.defaultUser)) {
                this.authenticator.sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (NotFoundException e) {
            response.sendError(404, e.getMessage());
        }
        catch (EXistException e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        User user;
        String path = this.adjustPath(request);
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor != null) {
            descriptor.doLogRequestInReplayLog(request);
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(user);
            this.srvREST.doHead(broker, request, response, path);
        }
        catch (BadRequestException e) {
            response.sendError(400, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            if (user.equals((Object)this.defaultUser)) {
                this.authenticator.sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (NotFoundException e) {
            response.sendError(404, e.getMessage());
        }
        catch (EXistException e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        User user;
        String path = this.adjustPath(request);
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor != null) {
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(user);
            this.srvREST.doDelete(broker, XmldbURI.create((String)path), response);
        }
        catch (PermissionDeniedException e) {
            if (user.equals((Object)this.defaultUser)) {
                this.authenticator.sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (NotFoundException e) {
            response.sendError(404, e.getMessage());
        }
        catch (EXistException e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        User user;
        HttpServletRequest request = null;
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        request = descriptor != null ? (descriptor.allowRequestLogging() ? new HttpServletRequestWrapper(req, this.formEncoding) : req) : req;
        String path = request.getPathInfo();
        path = path == null ? "" : this.adjustPath(request);
        if (descriptor != null) {
            descriptor.doLogRequestInReplayLog(request);
            path = descriptor.mapPath(path);
        }
        if ((user = this.authenticate(request, response)) == null) {
            return;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(user);
            if (path.indexOf(".xqws") > -1) {
                this.srvSOAP.doPost(broker, request, response, path);
            } else {
                this.srvREST.doPost(broker, request, response, path);
            }
        }
        catch (PermissionDeniedException e) {
            if (user.equals((Object)this.defaultUser)) {
                this.authenticator.sendChallenge(request, response);
            } else {
                response.sendError(403, e.getMessage());
            }
        }
        catch (EXistException e) {
            response.sendError(500, e.getMessage());
        }
        catch (BadRequestException e) {
            response.sendError(400, e.getMessage());
        }
        catch (NotFoundException e) {
            response.sendError(404, e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void destroy() {
        super.destroy();
        BrokerPool.stopAll((boolean)false);
    }

    private User authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String auth;
        Principal principal = request.getUserPrincipal();
        if (principal instanceof XmldbPrincipal) {
            String username = ((XmldbPrincipal)principal).getName();
            String password = ((XmldbPrincipal)principal).getPassword();
            LOG.info((Object)("Validating Principle: " + principal.getName()));
            User user = this.pool.getSecurityManager().getUser(username);
            if (user != null) {
                if (password.equalsIgnoreCase(user.getPassword())) {
                    LOG.info((Object)("Valid User: " + user.getName()));
                    return user;
                }
                LOG.info((Object)("Password invalid for user: " + username));
                LOG.info((Object)("User not found: " + principal.getName()));
            }
        }
        if ((auth = request.getHeader("Authorization")) == null && this.defaultUser != null) {
            return this.defaultUser;
        }
        return this.authenticator.authenticate(request, response);
    }

    private User getDefaultUser() {
        if (this.defaultUsername != null) {
            User user = this.pool.getSecurityManager().getUser(this.defaultUsername);
            if (user != null && !user.validate(this.defaultPassword)) {
                return null;
            }
            return user;
        }
        return null;
    }

    private void startup(Configuration configuration) throws ServletException {
        if (configuration == null) {
            throw new ServletException("database has not been configured");
        }
        LOG.info((Object)"configuring eXist instance");
        try {
            if (!BrokerPool.isConfigured()) {
                BrokerPool.configure((int)1, (int)5, (Configuration)configuration);
            }
        }
        catch (EXistException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (DatabaseConfigurationException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        try {
            LOG.info((Object)"registering XMLDB driver");
            Class<?> clazz = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)clazz.newInstance();
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (ClassNotFoundException e) {
            LOG.info((Object)"ERROR", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.info((Object)"ERROR", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.info((Object)"ERROR", (Throwable)e);
        }
        catch (XMLDBException e) {
            LOG.info((Object)"ERROR", (Throwable)e);
        }
    }
}

