/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.DefaultFileItem;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;
import org.exist.http.servlets.HttpSessionWrapper;
import org.exist.http.servlets.RequestWrapper;
import org.exist.http.servlets.SessionWrapper;

public class HttpRequestWrapper
implements RequestWrapper {
    private HttpServletRequest servletRequest;
    private String formEncoding = null;
    private String containerEncoding = null;
    private Hashtable params = null;
    private String pathInfo = null;
    private String servletPath = null;
    private static Logger LOG = Logger.getLogger((String)HttpRequestWrapper.class.getName());

    public HttpRequestWrapper(HttpServletRequest servletRequest, String formEncoding, String containerEncoding) {
        this(servletRequest, formEncoding, containerEncoding, true);
    }

    public HttpRequestWrapper(HttpServletRequest servletRequest, String formEncoding, String containerEncoding, boolean parseMultipart) {
        this.servletRequest = servletRequest;
        this.formEncoding = formEncoding;
        this.containerEncoding = containerEncoding;
        this.pathInfo = servletRequest.getPathInfo();
        this.servletPath = servletRequest.getServletPath();
        if (parseMultipart && FileUpload.isMultipartContent((HttpServletRequest)servletRequest)) {
            this.parseMultipartContent();
        }
    }

    public Object getAttribute(String name) {
        return this.servletRequest.getAttribute(name);
    }

    public Cookie[] getCookies() {
        return this.servletRequest.getCookies();
    }

    private void parseMultipartContent() {
        DiskFileUpload upload = new DiskFileUpload();
        upload.setSizeThreshold(0);
        try {
            this.params = new Hashtable();
            List items = upload.parseRequest(this.servletRequest);
            Iterator i = items.iterator();
            while (i.hasNext()) {
                FileItem next = (FileItem)i.next();
                Object old = this.params.get(next.getFieldName());
                if (old != null) {
                    if (old instanceof List) {
                        ((List)old).add(next);
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(old);
                    list.add(next);
                    this.params.put(next.getFieldName(), list);
                    continue;
                }
                this.params.put(next.getFieldName(), next);
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
    }

    private FileItem getFileItem(Object obj) {
        if (obj instanceof List) {
            return (FileItem)((List)obj).get(0);
        }
        return (FileItem)obj;
    }

    private String decode(String value) {
        if (this.containerEncoding == null) {
            this.containerEncoding = "ISO-8859-1";
        }
        if (this.containerEncoding.equals(this.formEncoding)) {
            return value;
        }
        try {
            byte[] bytes = value.getBytes(this.containerEncoding);
            return new String(bytes, this.formEncoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            return value;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.servletRequest.getInputStream();
    }

    public String getCharacterEncoding() {
        return this.servletRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.servletRequest.getContentLength();
    }

    public String getContentType() {
        return this.servletRequest.getContentType();
    }

    public String getContextPath() {
        return this.servletRequest.getContextPath();
    }

    public String getHeader(String arg0) {
        return this.servletRequest.getHeader(arg0);
    }

    public Enumeration getHeaderNames() {
        return this.servletRequest.getHeaderNames();
    }

    public Enumeration getHeaders(String arg0) {
        return this.servletRequest.getHeaders(arg0);
    }

    public String getMethod() {
        return this.servletRequest.getMethod();
    }

    public String getParameter(String name) {
        if (this.params == null) {
            String value = this.servletRequest.getParameter(name);
            if (this.formEncoding == null || value == null) {
                return value;
            }
            return this.decode(value);
        }
        Object o = this.params.get(name);
        if (o == null) {
            return null;
        }
        FileItem item = o instanceof List ? (FileItem)((List)o).get(0) : (FileItem)o;
        if (this.formEncoding == null) {
            return item.getString();
        }
        try {
            return item.getString(this.formEncoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            return null;
        }
    }

    public File getFileUploadParam(String name) {
        if (this.params == null) {
            return null;
        }
        Object o = this.params.get(name);
        if (o == null) {
            return null;
        }
        FileItem item = this.getFileItem(o);
        if (item.isFormField()) {
            return null;
        }
        return ((DefaultFileItem)item).getStoreLocation();
    }

    public String getUploadedFileName(String name) {
        if (this.params == null) {
            return null;
        }
        Object o = this.params.get(name);
        if (o == null) {
            return null;
        }
        FileItem item = this.getFileItem(o);
        if (item.isFormField()) {
            return null;
        }
        String itemName = item.getName();
        if (itemName == null) {
            return null;
        }
        int lastFileSepPos = Math.max(itemName.lastIndexOf("/"), itemName.lastIndexOf("\\"));
        String documentName = itemName;
        if (lastFileSepPos != -1) {
            documentName = itemName.substring(lastFileSepPos + 1);
        }
        return documentName;
    }

    public Enumeration getParameterNames() {
        if (this.params == null) {
            return this.servletRequest.getParameterNames();
        }
        return this.params.keys();
    }

    public String[] getParameterValues(String key) {
        String[] values;
        if (this.params == null) {
            String[] values2 = this.servletRequest.getParameterValues(key);
            if (this.formEncoding == null || values2 == null) {
                return values2;
            }
            for (int i = 0; i < values2.length; ++i) {
                values2[i] = this.decode(values2[i]);
            }
            return values2;
        }
        Object obj = this.params.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            values = new String[list.size()];
            int j = 0;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                FileItem item = (FileItem)i.next();
                try {
                    values[j] = this.formEncoding == null ? item.getString() : item.getString(this.formEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn((Object)e);
                    e.printStackTrace();
                }
                ++j;
            }
        } else {
            FileItem item = (FileItem)obj;
            values = new String[1];
            try {
                values[0] = this.formEncoding == null ? item.getString() : item.getString(this.formEncoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)e);
                e.printStackTrace();
            }
        }
        return values;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.servletRequest.getPathTranslated();
    }

    public String getProtocol() {
        return this.servletRequest.getProtocol();
    }

    public String getQueryString() {
        return this.servletRequest.getQueryString();
    }

    public String getRemoteAddr() {
        return this.servletRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.servletRequest.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.servletRequest.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.servletRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.servletRequest.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.servletRequest.getRequestURL();
    }

    public String getScheme() {
        return this.servletRequest.getScheme();
    }

    public String getServerName() {
        return this.servletRequest.getServerName();
    }

    public int getServerPort() {
        return this.servletRequest.getServerPort();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public SessionWrapper getSession() {
        HttpSession session = this.servletRequest.getSession();
        if (session == null) {
            return null;
        }
        return new HttpSessionWrapper(session);
    }

    public SessionWrapper getSession(boolean arg0) {
        HttpSession session = this.servletRequest.getSession(arg0);
        if (session == null) {
            return null;
        }
        return new HttpSessionWrapper(session);
    }

    public Principal getUserPrincipal() {
        return this.servletRequest.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.servletRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.servletRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.servletRequest.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.servletRequest.isSecure();
    }

    public boolean isUserInRole(String arg0) {
        return this.servletRequest.isUserInRole(arg0);
    }

    public void removeAttribute(String arg0) {
        this.servletRequest.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.servletRequest.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.servletRequest.setCharacterEncoding(arg0);
    }

    public void setPathInfo(String arg0) {
        this.pathInfo = arg0;
    }

    public void setServletPath(String arg0) {
        this.servletPath = arg0;
    }
}

