/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.exist.http.servlets.ResponseWrapper;

public class HttpResponseWrapper
implements ResponseWrapper {
    private HttpServletResponse response;
    private Map dateHeaders = new HashMap();

    public HttpResponseWrapper(HttpServletResponse response) {
        this.response = response;
    }

    public void addCookie(String name, String value) {
        this.response.addCookie(new Cookie(name, value));
    }

    public void addCookie(String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        this.response.addCookie(cookie);
    }

    public void addDateHeader(String arg0, long arg1) {
        this.response.addDateHeader(arg0, arg1);
    }

    public void addHeader(String arg0, String arg1) {
        this.response.addHeader(arg0, arg1);
    }

    public void addIntHeader(String arg0, int arg1) {
        this.response.addIntHeader(arg0, arg1);
    }

    public boolean containsHeader(String arg0) {
        return this.response.containsHeader(arg0);
    }

    public String encodeURL(String arg0) {
        return this.response.encodeURL(arg0);
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void sendRedirect(String arg0) throws IOException {
        this.response.sendRedirect(arg0);
    }

    public void setDateHeader(String name, long arg1) {
        this.dateHeaders.put(name, new Long(arg1));
        this.response.setDateHeader(name, arg1);
    }

    public long getDateHeader(String name) {
        long ret = 0L;
        Long val = (Long)this.dateHeaders.get(name);
        if (val != null) {
            ret = val;
        }
        return ret;
    }

    public void setHeader(String arg0, String arg1) {
        this.response.setHeader(arg0, arg1);
    }

    public void setIntHeader(String arg0, int arg1) {
        this.response.setIntHeader(arg0, arg1);
    }

    public void setStatusCode(int arg0) {
        this.response.setStatus(arg0);
    }

    public void setLocale(Locale arg0) {
        this.response.setLocale(arg0);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }
}

