/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exist.util.MimeType;

public class HttpServletRequestWrapper
implements HttpServletRequest {
    private HttpServletRequest request = null;
    private String formEncoding = null;
    private LinkedHashMap params = null;
    private String contentBodyAsString;
    byte[] contentBody;

    public HttpServletRequestWrapper(HttpServletRequest request, String formEncoding) throws UnsupportedEncodingException {
        this.request = request;
        this.formEncoding = formEncoding;
        this.params = new LinkedHashMap();
        this.initialiseWrapper();
    }

    private void initialiseWrapper() throws UnsupportedEncodingException {
        if (this.request.getCharacterEncoding() == null) {
            this.request.setCharacterEncoding(this.formEncoding);
        } else {
            this.formEncoding = this.getCharacterEncoding();
        }
        this.parseURLParameters(this.request.getQueryString());
        if (this.request.getMethod().toUpperCase().equals("POST") && this.request.getContentLength() > 0) {
            String contentType = this.request.getContentType().toLowerCase();
            if (contentType.equals("application/x-www-form-urlencoded") && this.request.getHeader("ContentType") == null) {
                this.parseContentBodyParameters();
            } else if (contentType.equals(MimeType.XML_TYPE.getName())) {
                this.contentBodyAsString = this.getContentBody();
            }
        }
    }

    private void parseURLParameters(String querystring) {
        if (querystring != null) {
            this.parseParameters(querystring, 1);
        }
    }

    private void parseContentBodyParameters() {
        String content = this.getContentBody();
        this.parseParameters(content, 2);
    }

    private String getContentBody() {
        this.contentBody = new byte[this.request.getContentLength()];
        String result = "";
        try {
            String encoding = this.request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            ServletInputStream is = this.request.getInputStream();
            int bytes = 0;
            int offset = 0;
            int max = 4096;
            while ((bytes = is.read(this.contentBody, offset, max)) != -1) {
                offset += bytes;
            }
            result = new String(this.contentBody, encoding);
        }
        catch (IOException ioe) {
            System.err.println("Error Reading the Content Body into the buffer: " + ioe);
            ioe.printStackTrace();
        }
        return result;
    }

    private void parseParameters(String parameters, int type) {
        String[] nameValuePairs = parameters.split("&");
        for (int k = 0; k < nameValuePairs.length; ++k) {
            Vector vecValues;
            String[] thePair = nameValuePairs[k].split("=");
            try {
                thePair[0] = URLDecoder.decode(thePair[0], this.formEncoding);
                if (thePair.length == 2) {
                    thePair[1] = URLDecoder.decode(thePair[1], this.formEncoding);
                }
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
            if (this.params.containsKey(thePair[0])) {
                vecValues = (Vector)this.params.get(thePair[0]);
                vecValues.add(new RequestParamater(thePair.length == 2 ? thePair[1] : new String(), type));
                this.params.put(thePair[0], vecValues);
                continue;
            }
            vecValues = new Vector();
            vecValues.add(new RequestParamater(thePair.length == 2 ? thePair[1] : new String(), type));
            this.params.put(thePair[0], vecValues);
        }
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathInfo();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String name) {
        return this.request.isUserInRole(name);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromUrl();
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.contentBodyRecorded()) {
            return new CachingServletInputStream();
        }
        return this.request.getInputStream();
    }

    public InputStream getContentBodyInputStream() throws IOException {
        return new ByteArrayInputStream(this.contentBody);
    }

    public String getParameter(String name) {
        if (this.params.containsKey(name)) {
            Vector vecParameterValues = (Vector)this.params.get(name);
            return ((RequestParamater)vecParameterValues.get(0)).getValue();
        }
        return null;
    }

    public Enumeration getParameterNames() {
        Object[] keySet = this.params.keySet().toArray();
        String[] strKeySet = new String[keySet.length];
        System.arraycopy(keySet, 0, strKeySet, 0, keySet.length);
        return new StringEnumeration(strKeySet);
    }

    public String[] getParameterValues(String name) {
        if (this.params.containsKey(name)) {
            Vector vecParameterValues = (Vector)this.params.get(name);
            String[] values = new String[vecParameterValues.size()];
            for (int i = 0; i < vecParameterValues.size(); ++i) {
                values[i] = ((RequestParamater)vecParameterValues.get(i)).getValue();
            }
            return values;
        }
        return null;
    }

    public Map getParameterMap() {
        LinkedHashMap mapParameters = new LinkedHashMap();
        Set setParams = this.params.entrySet();
        Iterator itParams = setParams.iterator();
        while (itParams.hasNext()) {
            Map.Entry me = itParams.next();
            Vector vecParamValues = (Vector)me.getValue();
            String[] values = new String[vecParamValues.size()];
            int i = 0;
            Iterator itParamValues = vecParamValues.iterator();
            while (itParamValues.hasNext()) {
                values[i] = ((RequestParamater)itParamValues.next()).getValue();
                ++i;
            }
            mapParameters.put(me.getKey(), values);
        }
        return mapParameters;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.contentBodyRecorded()) {
            return new BufferedReader(new InputStreamReader(this.getContentBodyInputStream(), this.request.getCharacterEncoding()));
        }
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String name) {
        return this.request.getRequestDispatcher(name);
    }

    public String getRealPath(String path) {
        return this.request.getRealPath(path);
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public String toString() {
        if (this.request.getMethod().toUpperCase().equals("POST") && this.request.getContentLength() > 0 && !this.request.getContentType().toUpperCase().startsWith("MULTIPART/") && !this.contentBodyRecorded()) {
            StringBuffer buf = new StringBuffer(this.request.toString());
            Set setParams = this.params.entrySet();
            Iterator itParams = setParams.iterator();
            while (itParams.hasNext()) {
                Map.Entry me = itParams.next();
                Vector vecParamValues = (Vector)me.getValue();
                Iterator itParamValues = vecParamValues.iterator();
                while (itParamValues.hasNext()) {
                    RequestParamater p = (RequestParamater)itParamValues.next();
                    if (p.type != 2) continue;
                    if (buf.charAt(buf.length() - 1) != '\n') {
                        buf.append("&");
                    }
                    buf.append((String)me.getKey());
                    buf.append("=");
                    buf.append(p.getValue());
                }
            }
            buf.append(System.getProperty("line.separator") + System.getProperty("line.separator"));
            return buf.toString();
        }
        if (this.contentBodyRecorded()) {
            StringBuffer buf = new StringBuffer(this.request.toString());
            buf.append(this.contentBodyAsString);
            buf.append(System.getProperty("line.separator") + System.getProperty("line.separator"));
            return buf.toString();
        }
        return this.request.toString();
    }

    private boolean contentBodyRecorded() {
        return this.contentBody != null && this.contentBody.length > 0;
    }

    private class CachingServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream istream;

        public CachingServletInputStream() {
            this.istream = HttpServletRequestWrapper.this.contentBody == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(HttpServletRequestWrapper.this.contentBody);
        }

        public int read() throws IOException {
            return this.istream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.istream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.istream.read(b, off, len);
        }

        public int available() throws IOException {
            return this.istream.available();
        }
    }

    private class RequestParamater {
        public static final int PARAM_TYPE_URL = 1;
        public static final int PARAM_TYPE_CONTENT = 2;
        private String value = null;
        private int type = 0;

        RequestParamater(String value, int type) {
            this.value = value;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }
    }

    private class StringEnumeration
    implements Enumeration {
        private String[] strings = null;
        int aryPos = -1;

        StringEnumeration(String[] strings) {
            if (strings != null && strings.length > 0) {
                this.strings = new String[strings.length];
                System.arraycopy(strings, 0, this.strings, 0, strings.length);
                this.aryPos = 0;
            }
        }

        public boolean hasMoreElements() {
            return this.aryPos != -1 && this.aryPos < this.strings.length;
        }

        public Object nextElement() {
            if (this.aryPos != -1) {
                if (this.aryPos < this.strings.length) {
                    String s = this.strings[this.aryPos];
                    ++this.aryPos;
                    return s;
                }
                throw new NoSuchElementException("No more String's in the Enumeration, End Reached");
            }
            throw new NoSuchElementException("Enumeration is empty");
        }
    }
}

