/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.http.webdav.WebDAV;

public class WebDAVServlet
extends HttpServlet {
    private WebDAV webdav;
    protected String databaseid = "exist";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String id = config.getInitParameter("database-id");
        if (id != null && !"".equals(id)) {
            this.databaseid = id;
        }
        int authMethod = 1;
        String param = config.getInitParameter("authentication");
        if (param != null && "basic".equalsIgnoreCase(param)) {
            authMethod = 0;
        }
        this.webdav = new WebDAV(authMethod, this.databaseid);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.webdav.process(request, response);
    }

    private void dumpHeaders(HttpServletRequest request) {
        System.out.println("-------------------------------------------------------");
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            System.out.println(header + " = " + request.getHeader(header));
        }
    }
}

