/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.servlets;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.exist.http.Descriptor;
import org.exist.http.servlets.HttpRequestWrapper;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.http.servlets.HttpServletRequestWrapper;
import org.exist.http.servlets.HttpSessionWrapper;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.XQueryService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.HTTPUtils;
import org.exist.xquery.value.Sequence;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class XQueryServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((Class)XQueryServlet.class);
    public static final String DEFAULT_USER = "guest";
    public static final String DEFAULT_PASS = "guest";
    public static final XmldbURI DEFAULT_URI = XmldbURI.EMBEDDED_SERVER_URI.append(XmldbURI.ROOT_COLLECTION_URI);
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    private String user = null;
    private String password = null;
    private XmldbURI collectionURI = null;
    private String containerEncoding = null;
    private String formEncoding = null;
    private String encoding = null;
    private String contentType = null;

    public void init(ServletConfig config) throws ServletException {
        String confCollectionURI;
        super.init(config);
        this.user = config.getInitParameter("user");
        if (this.user == null) {
            this.user = "guest";
        }
        this.password = config.getInitParameter("password");
        if (this.password == null) {
            this.password = "guest";
        }
        if ((confCollectionURI = config.getInitParameter("uri")) == null) {
            this.collectionURI = DEFAULT_URI;
        } else {
            try {
                this.collectionURI = XmldbURI.xmldbUriFor((String)confCollectionURI);
            }
            catch (URISyntaxException e) {
                throw new ServletException("Invalid XmldbURI for parameter 'uri': " + e.getMessage(), (Throwable)e);
            }
        }
        this.formEncoding = config.getInitParameter("form-encoding");
        if (this.formEncoding == null) {
            this.formEncoding = DEFAULT_ENCODING;
        }
        LOG.info((Object)("form-encoding = " + this.formEncoding));
        this.containerEncoding = config.getInitParameter("container-encoding");
        if (this.containerEncoding == null) {
            this.containerEncoding = DEFAULT_ENCODING;
        }
        LOG.info((Object)("container-encoding = " + this.containerEncoding));
        this.encoding = config.getInitParameter("encoding");
        if (this.encoding == null) {
            this.encoding = DEFAULT_ENCODING;
        }
        LOG.info((Object)("encoding = " + this.encoding));
        this.contentType = config.getInitParameter("content-type");
        if (this.contentType == null) {
            this.contentType = DEFAULT_CONTENT_TYPE;
        }
        try {
            Class<?> driver = Class.forName(DRIVER);
            Database database = (Database)driver.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            String errorMessage = "Failed to initialize database driver";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new ServletException(errorMessage + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest request = null;
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        request = descriptor != null ? (descriptor.allowRequestLogging() ? new HttpServletRequestWrapper(req, this.formEncoding) : req) : req;
        this.process(request, response);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest request = null;
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        request = descriptor != null ? (descriptor.allowRequestLogging() ? new HttpServletRequestWrapper(req, this.formEncoding) : req) : req;
        this.process(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestPath;
        int p;
        Descriptor descriptor;
        String path = request.getPathTranslated();
        if (path == null) {
            path = request.getRequestURI().substring(request.getContextPath().length());
            int p2 = path.lastIndexOf(59);
            if (p2 != -1) {
                path = path.substring(0, p2);
            }
            path = this.getServletContext().getRealPath(path);
        }
        if ((descriptor = Descriptor.getDescriptorSingleton()) != null) {
            descriptor.doLogRequestInReplayLog(request);
            path = descriptor.mapPath(path);
        }
        if (request.getCharacterEncoding() == null) {
            try {
                request.setCharacterEncoding(this.formEncoding);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        ServletOutputStream sout = response.getOutputStream();
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)sout, this.formEncoding));
        response.setContentType(this.contentType + "; charset=" + this.formEncoding);
        response.addHeader("pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        File f = new File(path);
        if (!f.canRead()) {
            response.setStatus(404);
            this.sendError(output, "Cannot read source file", path);
            return;
        }
        if (request.getMethod().toUpperCase().equals("GET")) {
            boolean source = false;
            String option = request.getParameter("_source");
            if (option != null) {
                source = option.equals("yes");
            }
            if (source && descriptor != null) {
                if (descriptor.allowSourceXQuery(path)) {
                    response.setContentType("text/plain;charset=" + this.formEncoding);
                    FileSource fs = new FileSource(f, this.encoding, true);
                    output.write(fs.getContent());
                    output.flush();
                    return;
                }
                response.sendError(403, "Permission to view XQuery source for: " + path + " denied. Must be explicitly defined in descriptor.xml");
                return;
            }
        }
        String contentType = this.contentType;
        try {
            contentType = this.getServletContext().getMimeType(path);
            if (contentType == null) {
                contentType = this.contentType;
            }
        }
        catch (Throwable e) {
            contentType = this.contentType;
        }
        finally {
            if (contentType.startsWith("text/") || contentType.endsWith("+xml")) {
                contentType = contentType + ";charset=" + this.formEncoding;
            }
            response.setContentType(contentType);
        }
        if ((p = (requestPath = request.getRequestURI()).lastIndexOf("/")) != -1) {
            requestPath = requestPath.substring(0, p);
        }
        String moduleLoadPath = this.getServletContext().getRealPath(requestPath.substring(request.getContextPath().length()));
        String actualUser = null;
        String actualPassword = null;
        HttpSession session = request.getSession();
        if (session != null && request.isRequestedSessionIdValid()) {
            actualUser = this.getSessionAttribute(session, "user");
            actualPassword = this.getSessionAttribute(session, "password");
        }
        if (actualUser == null) {
            actualUser = this.user;
        }
        if (actualPassword == null) {
            actualPassword = this.password;
        }
        try {
            Collection collection = DatabaseManager.getCollection((String)this.collectionURI.toString(), (String)actualUser, (String)actualPassword);
            XQueryService service = (XQueryService)collection.getService("XQueryService", "1.0");
            service.setProperty("base-uri", this.collectionURI.toString());
            service.setModuleLoadPath(moduleLoadPath);
            if (!((CollectionImpl)collection).isRemoteCollection()) {
                service.declareVariable("request:request", (Object)new HttpRequestWrapper(request, this.formEncoding, this.containerEncoding));
                service.declareVariable("response:response", (Object)new HttpResponseWrapper(response));
                service.declareVariable("session:session", (Object)new HttpSessionWrapper(session));
            }
            FileSource source = new FileSource(f, this.encoding, true);
            ResourceSet result = service.execute((Source)source);
            String mediaType = service.getProperty("media-type");
            if (mediaType != null && !response.isCommitted()) {
                response.setContentType(mediaType + "; charset=" + this.formEncoding);
            }
            ResourceIterator i = result.getIterator();
            while (i.hasMoreResources()) {
                Resource res = i.nextResource();
                output.println(res.getContent().toString());
            }
        }
        catch (XMLDBException e) {
            LOG.debug((Object)e);
            response.setStatus(400);
            this.sendError(output, e.getMessage(), e);
        }
        output.flush();
    }

    private String getSessionAttribute(HttpSession session, String attribute) {
        Object obj = session.getAttribute(attribute);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Sequence) {
            try {
                return ((Sequence)obj).getStringValue();
            }
            catch (XPathException e) {
                return null;
            }
        }
        return obj.toString();
    }

    private void sendError(PrintWriter out, String message, XMLDBException e) {
        out.print("<html><head>");
        out.print("<title>XQueryServlet Error</title>");
        out.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"error.css\"></link></head>");
        out.print("<body><div id=\"container\"><h1>Error found</h1>");
        Throwable t = e.getCause();
        if (t instanceof XPathException) {
            XPathException xe = (XPathException)t;
            out.println(xe.getMessageAsHTML());
        } else {
            out.print("<h2>Message:");
            out.print(message);
            out.print("</h2>");
        }
        if (t != null) {
            out.print(HTTPUtils.printStackTraceHTML((Throwable)t));
        }
        out.print("</div></body></html>");
    }

    private void sendError(PrintWriter out, String message, String description) {
        out.print("<html><head>");
        out.print("<title>XQueryServlet Error</title>");
        out.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"error.css\"></link></head>");
        out.println("<body><h1>Error found</h1>");
        out.print("<div class='message'><b>Message: </b>");
        out.print(message);
        out.print("</div><div class='description'>");
        out.print(description);
        out.print("</div></body></html>");
        out.flush();
    }
}

