/*
 * Decompiled with CFR 0.152.
 */
package org.exist.soap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.soap.Admin;
import org.exist.soap.CollectionDesc;
import org.exist.soap.DocumentDesc;
import org.exist.soap.DocumentDescs;
import org.exist.soap.DocumentType;
import org.exist.soap.EntityPermissions;
import org.exist.soap.EntityPermissionsList;
import org.exist.soap.IndexedElement;
import org.exist.soap.IndexedElements;
import org.exist.soap.Permissions;
import org.exist.soap.Session;
import org.exist.soap.SessionManager;
import org.exist.soap.Strings;
import org.exist.soap.UserDesc;
import org.exist.soap.UserDescs;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeType;
import org.exist.util.Occurrences;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AdminSoapBindingImpl
implements Admin {
    private static Logger LOG = Logger.getLogger((String)Admin.class.getName());
    private BrokerPool pool;

    public AdminSoapBindingImpl() {
        try {
            this.pool = BrokerPool.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to initialize broker pool");
        }
    }

    public String connect(String userId, String password) throws RemoteException {
        User u = this.pool.getSecurityManager().getUser(userId);
        if (u == null) {
            throw new RemoteException("user " + userId + " does not exist");
        }
        if (!u.validate(password)) {
            throw new RemoteException("the supplied password is invalid");
        }
        LOG.debug((Object)("user " + userId + " connected"));
        return SessionManager.getInstance().createSession(u);
    }

    public void disconnect(String sessionId) throws RemoteException {
        SessionManager manager = SessionManager.getInstance();
        Session session = manager.getSession(sessionId);
        if (session != null) {
            LOG.debug((Object)("disconnecting session " + sessionId));
            manager.disconnect(sessionId);
        }
    }

    public boolean createCollection(String sessionId, String path) throws RemoteException {
        try {
            return this.createCollection(sessionId, XmldbURI.xmldbUriFor((String)path));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public boolean createCollection(String sessionId, XmldbURI path) throws RemoteException {
        Session session = this.getSession(sessionId);
        DBBroker broker = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.pool.get(session.getUser());
            LOG.debug((Object)("creating collection " + path));
            Collection coll = broker.getOrCreateCollection(txn, path);
            if (coll == null) {
                LOG.debug((Object)"failed to create collection");
                boolean bl = false;
                return bl;
            }
            broker.saveCollection(txn, coll);
            transact.commit(txn);
            broker.flush();
            broker.sync(0);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            transact.abort(txn);
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    public boolean removeCollection(String sessionId, String path) throws RemoteException {
        try {
            return this.removeCollection(sessionId, XmldbURI.xmldbUriFor((String)path));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public boolean removeCollection(String sessionId, XmldbURI path) throws RemoteException {
        Session session = this.getSession(sessionId);
        DBBroker broker = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.pool.get(session.getUser());
            Collection collection = broker.getCollection(path);
            if (collection == null) {
                transact.abort(txn);
                boolean bl = false;
                return bl;
            }
            boolean removed = broker.removeCollection(txn, collection);
            transact.commit(txn);
            boolean bl = removed;
            return bl;
        }
        catch (Exception e) {
            transact.abort(txn);
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public boolean removeDocument(String sessionId, String path) throws RemoteException {
        try {
            return this.removeDocument(sessionId, XmldbURI.xmldbUriFor((String)path));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid document URI", e);
        }
    }

    public boolean removeDocument(String sessionId, XmldbURI path) throws RemoteException {
        Session session = this.getSession(sessionId);
        DBBroker broker = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.pool.get(session.getUser());
            XmldbURI collectionUri = path.removeLastSegment();
            XmldbURI docUri = path.lastSegment();
            if (collectionUri == null || docUri == null) {
                transact.abort(txn);
                throw new EXistException("Illegal document path");
            }
            Collection collection = broker.getCollection(collectionUri);
            if (collection == null) {
                transact.abort(txn);
                throw new EXistException("Collection " + collectionUri + " not found");
            }
            DocumentImpl doc = collection.getDocument(broker, docUri);
            if (doc == null) {
                throw new EXistException("Document " + docUri + " not found");
            }
            if (doc.getResourceType() == 1) {
                collection.removeBinaryResource(txn, broker, doc);
            } else {
                collection.removeXMLResource(txn, broker, docUri);
            }
            transact.commit(txn);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            transact.abort(txn);
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void store(String sessionId, byte[] data, String encoding, String path, boolean replace) throws RemoteException {
        try {
            this.store(sessionId, data, encoding, XmldbURI.xmldbUriFor((String)path), replace);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid document URI", e);
        }
    }

    public void store(String sessionId, byte[] data, String encoding, XmldbURI path, boolean replace) throws RemoteException {
        Session session = this.getSession(sessionId);
        DBBroker broker = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            DocumentImpl old;
            broker = this.pool.get(session.getUser());
            XmldbURI collectionUri = path.removeLastSegment();
            XmldbURI docUri = path.lastSegment();
            if (collectionUri == null || docUri == null) {
                transact.abort(txn);
                throw new EXistException("Illegal document path");
            }
            Collection collection = broker.getCollection(collectionUri);
            if (collection == null) {
                transact.abort(txn);
                throw new EXistException("Collection " + collectionUri + " not found");
            }
            if (!replace && (old = collection.getDocument(broker, docUri)) != null) {
                transact.abort(txn);
                throw new RemoteException("Document exists and overwrite is not allowed");
            }
            long startTime = System.currentTimeMillis();
            IndexInfo info = collection.validateXMLResource(txn, broker, docUri, new InputSource(new ByteArrayInputStream(data)));
            info.getDocument().getMetadata().setMimeType(MimeType.XML_TYPE.getName());
            collection.store(txn, broker, info, new InputSource(new ByteArrayInputStream(data)), false);
            transact.commit(txn);
            LOG.debug((Object)("parsing " + path + " took " + (System.currentTimeMillis() - startTime) + "ms."));
        }
        catch (Exception e) {
            transact.abort(txn);
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    private Session getSession(String id) throws RemoteException {
        Session session = SessionManager.getInstance().getSession(id);
        if (session == null) {
            throw new RemoteException("Session is invalid or timed out");
        }
        return session;
    }

    public int xupdate(String sessionId, String collectionName, String xupdate) throws RemoteException {
        try {
            return this.xupdate(sessionId, XmldbURI.xmldbUriFor((String)collectionName), xupdate);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public int xupdate(String sessionId, XmldbURI collectionName, String xupdate) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.pool.get(session.getUser());
            Collection collection = broker.getCollection(collectionName);
            if (collection == null) {
                transact.abort(transaction);
                throw new RemoteException("collection " + collectionName + " not found");
            }
            DocumentSet docs = collection.allDocs(broker, new DocumentSet(), true, true);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs, AccessContext.SOAP);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process(transaction);
                broker.flush();
            }
            transact.commit(transaction);
            int n = (int)mods;
            return n;
        }
        catch (ParserConfigurationException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (SAXException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (XPathException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public int xupdateResource(String sessionId, String documentName, String xupdate) throws RemoteException {
        try {
            return this.xupdateResource(sessionId, XmldbURI.xmldbUriFor((String)documentName), xupdate);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid document URI", e);
        }
    }

    public int xupdateResource(String sessionId, XmldbURI documentName, String xupdate) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.pool.get(session.getUser());
            DocumentImpl doc = (DocumentImpl)broker.getXMLResource(documentName);
            if (doc == null) {
                transact.abort(transaction);
                throw new RemoteException("document " + documentName + " not found");
            }
            if (!doc.getPermissions().validate(broker.getUser(), 4)) {
                transact.abort(transaction);
                throw new RemoteException("Not allowed to read resource");
            }
            DocumentSet docs = new DocumentSet();
            docs.add(doc);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs, AccessContext.SOAP);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process(transaction);
                broker.flush();
            }
            transact.commit(transaction);
            int n = (int)mods;
            return n;
        }
        catch (ParserConfigurationException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (SAXException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (XPathException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void storeBinary(String sessionId, byte[] data, String path, String mimeType, boolean replace) throws RemoteException {
        try {
            this.storeBinary(sessionId, data, XmldbURI.xmldbUriFor((String)path), mimeType, replace);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid document URI", e);
        }
    }

    public void storeBinary(String sessionId, byte[] data, XmldbURI path, String mimeType, boolean replace) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        Collection collection = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            DocumentImpl old;
            broker = this.pool.get(session.getUser());
            XmldbURI collectionUri = path.removeLastSegment();
            XmldbURI docUri = path.lastSegment();
            if (collectionUri == null || docUri == null) {
                transact.abort(txn);
                throw new EXistException("Illegal document path");
            }
            collection = broker.openCollection(collectionUri, 1);
            if (collection == null) {
                throw new EXistException("Collection " + collectionUri + " not found");
            }
            if (!replace && (old = collection.getDocument(broker, docUri)) != null) {
                throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
            }
            LOG.debug((Object)("Storing binary resource to collection " + collection.getURI()));
            collection.addBinaryResource(txn, broker, docUri, data, mimeType);
            transact.commit(txn);
        }
        catch (Exception e) {
            transact.abort(txn);
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            if (collection != null) {
                collection.release(1);
            }
            this.pool.release(broker);
        }
    }

    public byte[] getBinaryResource(String sessionId, String path) throws RemoteException {
        try {
            return this.getBinaryResource(sessionId, XmldbURI.xmldbUriFor((String)path));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid document URI", e);
        }
    }

    public byte[] getBinaryResource(String sessionId, XmldbURI name) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        DocumentImpl doc = null;
        try {
            broker = this.pool.get(session.getUser());
            doc = broker.getXMLResource(name, 0);
            if (doc == null) {
                throw new EXistException("Resource " + name + " not found");
            }
            if (doc.getResourceType() != 1) {
                throw new EXistException("Document " + name + " is not a binary resource");
            }
            if (!doc.getPermissions().validate(session.getUser(), 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            byte[] byArray = broker.getBinaryResource((BinaryDocument)doc);
            return byArray;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.pool.release(broker);
        }
    }

    public CollectionDesc getCollectionDesc(String sessionId, String path) throws RemoteException {
        try {
            return this.getCollectionDesc(sessionId, XmldbURI.xmldbUriFor((String)path));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public CollectionDesc getCollectionDesc(String sessionId, XmldbURI collectionName) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        Collection collection = null;
        try {
            broker = this.pool.get(session.getUser());
            if (collectionName == null) {
                collectionName = XmldbURI.ROOT_COLLECTION_URI;
            }
            if ((collection = broker.openCollection(collectionName, 0)) == null) {
                throw new EXistException("collection " + collectionName + " not found!");
            }
            CollectionDesc desc = new CollectionDesc();
            Vector<DocumentDesc> docs = new Vector<DocumentDesc>();
            Vector<String> collections = new Vector<String>();
            if (collection.getPermissions().validate(session.getUser(), 4)) {
                Iterator i = collection.iterator(broker);
                while (i.hasNext()) {
                    DocumentImpl doc = (DocumentImpl)i.next();
                    Permission perms = doc.getPermissions();
                    DocumentDesc dd = new DocumentDesc();
                    dd.setName(doc.getFileURI().toString());
                    dd.setOwner(perms.getOwner());
                    dd.setGroup(perms.getOwnerGroup());
                    dd.setPermissions(perms.getPermissions());
                    dd.setType(doc.getResourceType() == 1 ? DocumentType.BinaryResource : DocumentType.XMLResource);
                    docs.addElement(dd);
                }
                i = collection.collectionIterator();
                while (i.hasNext()) {
                    collections.addElement(((XmldbURI)i.next()).toString());
                }
            }
            Permission perms = collection.getPermissions();
            desc.setCollections(new Strings(collections.toArray(new String[collections.size()])));
            desc.setDocuments(new DocumentDescs(docs.toArray(new DocumentDesc[docs.size()])));
            desc.setName(collection.getURI().toString());
            desc.setCreated(collection.getCreationTime());
            desc.setOwner(perms.getOwner());
            desc.setGroup(perms.getOwnerGroup());
            desc.setPermissions(perms.getPermissions());
            CollectionDesc collectionDesc = desc;
            return collectionDesc;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.pool.release(broker);
        }
    }

    public void setPermissions(String sessionId, String resource, String owner, String ownerGroup, int permissions) throws RemoteException {
        try {
            this.setPermissions(sessionId, XmldbURI.xmldbUriFor((String)resource), owner, ownerGroup, permissions);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public void setPermissions(String sessionId, XmldbURI resource, String owner, String ownerGroup, int permissions) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        Collection collection = null;
        DocumentImpl doc = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.pool.get(session.getUser());
            SecurityManager manager = this.pool.getSecurityManager();
            collection = broker.openCollection(resource, 1);
            if (collection == null) {
                doc = broker.getXMLResource(resource, 1);
                if (doc == null) {
                    throw new RemoteException("document or collection " + resource + " not found");
                }
                LOG.debug((Object)("changing permissions on document " + resource));
                Permission perm = doc.getPermissions();
                if (perm.getOwner().equals(session.getUser().getName()) || manager.hasAdminPrivileges(session.getUser())) {
                    if (owner != null) {
                        perm.setOwner(owner);
                        perm.setGroup(ownerGroup);
                    }
                    perm.setPermissions(permissions);
                    broker.storeXMLResource(transaction, doc);
                    transact.commit(transaction);
                    broker.flush();
                    return;
                }
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            LOG.debug((Object)("changing permissions on collection " + resource));
            Permission perm = collection.getPermissions();
            if (perm.getOwner().equals(session.getUser().getName()) || manager.hasAdminPrivileges(session.getUser())) {
                perm.setPermissions(permissions);
                if (owner != null) {
                    perm.setOwner(owner);
                    perm.setGroup(ownerGroup);
                }
                transaction.registerLock(collection.getLock(), 1);
                broker.saveCollection(transaction, collection);
                transact.commit(transaction);
                broker.flush();
                return;
            }
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            catch (IOException e) {
                transact.abort(transaction);
                throw new RemoteException(e.getMessage());
            }
            catch (PermissionDeniedException e) {
                transact.abort(transaction);
                throw new RemoteException(e.getMessage());
            }
            catch (TransactionException e) {
                throw new RemoteException(e.getMessage());
            }
            catch (EXistException e) {
                throw new RemoteException(e.getMessage());
            }
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.pool.release(broker);
        }
    }

    private void moveOrCopyResource(String sessionId, String docPath, String destinationPath, String newName, boolean move) throws RemoteException {
        try {
            this.moveOrCopyResource(sessionId, XmldbURI.xmldbUriFor((String)docPath), XmldbURI.xmldbUriFor((String)destinationPath), XmldbURI.xmldbUriFor((String)newName), move);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void moveOrCopyResource(String sessionId, XmldbURI docPath, XmldbURI destinationPath, XmldbURI newName, boolean move) throws RemoteException {
        DocumentImpl doc;
        Collection collection;
        DBBroker broker;
        block19: {
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            broker = null;
            Session session = this.getSession(sessionId);
            collection = null;
            Collection destination = null;
            doc = null;
            try {
                broker = this.pool.get(session.getUser());
                XmldbURI collectionUri = docPath.removeLastSegment();
                XmldbURI docUri = docPath.lastSegment();
                if (collectionUri == null || docUri == null) {
                    transact.abort(transaction);
                    throw new EXistException("Illegal document path");
                }
                collection = broker.openCollection(collectionUri, move ? 1 : 0);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new RemoteException("Collection " + collectionUri + " not found");
                }
                doc = collection.getDocumentWithLock(broker, docUri, 1);
                if (doc == null) {
                    transact.abort(transaction);
                    throw new RemoteException("Document " + docUri + " not found");
                }
                destination = broker.openCollection(destinationPath, 1);
                if (destination == null) {
                    transact.abort(transaction);
                    throw new RemoteException("Destination collection " + destinationPath + " not found");
                }
                if (move) {
                    broker.moveXMLResource(transaction, doc, destination, newName);
                } else {
                    broker.copyXMLResource(transaction, doc, destination, newName);
                }
                transact.commit(transaction);
                if (destination == null) break block19;
            }
            catch (LockException e) {
                try {
                    transact.abort(transaction);
                    throw new RemoteException("Could not acquire lock on document " + docPath);
                    catch (PermissionDeniedException e2) {
                        transact.abort(transaction);
                        throw new RemoteException("Could not move/copy document " + docPath);
                    }
                    catch (IOException e3) {
                        transact.abort(transaction);
                        throw new RemoteException(e3.getMessage());
                    }
                    catch (TransactionException e4) {
                        throw new RemoteException("Error commiting transaction " + e4.getMessage());
                    }
                    catch (EXistException e5) {
                        throw new RemoteException(e5.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (destination != null) {
                        destination.release(1);
                    }
                    if (doc != null) {
                        doc.getUpdateLock().release(1);
                    }
                    if (collection != null) {
                        collection.release(move ? 1 : 0);
                    }
                    this.pool.release(broker);
                    throw throwable;
                }
            }
            destination.release(1);
        }
        if (doc != null) {
            doc.getUpdateLock().release(1);
        }
        if (collection != null) {
            collection.release(move ? 1 : 0);
        }
        this.pool.release(broker);
    }

    private boolean moveOrCopyCollection(String sessionId, String collectionPath, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException, RemoteException {
        try {
            return this.moveOrCopyCollection(sessionId, XmldbURI.xmldbUriFor((String)collectionPath), XmldbURI.xmldbUriFor((String)destinationPath), XmldbURI.xmldbUriFor((String)newName), move);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean moveOrCopyCollection(String sessionId, XmldbURI collectionPath, XmldbURI destinationPath, XmldbURI newName, boolean move) throws EXistException, PermissionDeniedException, RemoteException {
        boolean bl;
        Collection destination;
        DBBroker broker;
        block12: {
            int n;
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            broker = null;
            Session session = this.getSession(sessionId);
            Collection collection = null;
            destination = null;
            try {
                User user = session.getUser();
                broker = this.pool.get(user);
                collection = broker.openCollection(collectionPath, move ? 1 : 0);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new EXistException("Collection " + collectionPath + " not found");
                }
                destination = broker.openCollection(destinationPath, 1);
                if (destination == null) {
                    transact.abort(transaction);
                    throw new EXistException("Destination collection " + destinationPath + " not found");
                }
                if (move) {
                    broker.moveCollection(transaction, collection, destination, newName);
                } else {
                    broker.copyCollection(transaction, collection, destination, newName);
                }
                transact.commit(transaction);
                bl = true;
                if (collection == null) break block12;
                n = move ? 1 : 0;
            }
            catch (IOException e) {
                try {
                    transact.abort(transaction);
                    throw new RemoteException(e.getMessage());
                    catch (LockException e2) {
                        transact.abort(transaction);
                        throw new PermissionDeniedException(e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (collection != null) {
                        collection.release(move ? 1 : 0);
                    }
                    if (destination != null) {
                        destination.release(1);
                    }
                    this.pool.release(broker);
                    throw throwable;
                }
            }
            collection.release(n);
        }
        if (destination != null) {
            destination.release(1);
        }
        this.pool.release(broker);
        return bl;
    }

    public void copyResource(String sessionId, String docPath, String destinationPath, String newName) throws RemoteException {
        this.moveOrCopyResource(sessionId, docPath, destinationPath, newName, false);
    }

    public void copyCollection(String sessionId, String collectionPath, String destinationPath, String newName) throws RemoteException {
        try {
            this.moveOrCopyCollection(sessionId, collectionPath, destinationPath, newName, false);
        }
        catch (RemoteException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (EXistException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (PermissionDeniedException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void setUser(String sessionId, String name, String password, Strings groups, String home) throws RemoteException {
        User u;
        if (password.length() == 0) {
            password = null;
        }
        Session session = this.getSession(sessionId);
        User user = session.getUser();
        SecurityManager manager = this.pool.getSecurityManager();
        if (name.equals("guest") && !manager.hasAdminPrivileges(user)) {
            throw new RemoteException("guest user cannot be modified");
        }
        if (!manager.hasUser(name)) {
            if (!manager.hasAdminPrivileges(user)) {
                throw new RemoteException("not allowed to create user");
            }
            u = new User(name);
            u.setPasswordDigest(password);
        } else {
            u = manager.getUser(name);
            if (!u.getName().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                throw new RemoteException("you are not allowed to change this user");
            }
            u.setPasswordDigest(password);
        }
        for (int i = 0; i < groups.getElements().length; ++i) {
            if (u.hasGroup(groups.getElements()[i])) continue;
            if (!manager.hasAdminPrivileges(user)) {
                throw new RemoteException("User is not allowed to add groups");
            }
            u.addGroup(groups.getElements()[i]);
        }
        if (home != null) {
            try {
                u.setHome(XmldbURI.xmldbUriFor((String)home));
            }
            catch (URISyntaxException e) {
                throw new RemoteException("Invalid collection URI", e);
            }
        }
        manager.setUser(u);
    }

    public UserDesc getUser(String sessionId, String user) throws RemoteException {
        User u = this.pool.getSecurityManager().getUser(user);
        if (u == null) {
            throw new RemoteException("user " + user + " does not exist");
        }
        UserDesc desc = new UserDesc();
        desc.setName(u.getName());
        desc.setGroups(new Strings(u.getGroups()));
        if (u.getHome() != null) {
            desc.setHome(u.getHome().toString());
        }
        return desc;
    }

    public void removeUser(String sessionId, String name) throws RemoteException {
        User user = this.getSession(sessionId).getUser();
        SecurityManager manager = this.pool.getSecurityManager();
        if (!manager.hasAdminPrivileges(user)) {
            throw new RemoteException("you are not allowed to remove users");
        }
        try {
            manager.deleteUser(name);
        }
        catch (PermissionDeniedException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public UserDescs getUsers(String sessionId) throws RemoteException {
        User[] users = this.pool.getSecurityManager().getUsers();
        UserDesc[] r = new UserDesc[users.length];
        for (int i = 0; i < users.length; ++i) {
            r[i] = new UserDesc();
            r[i].setName(users[i].getName());
            r[i].setGroups(new Strings(users[i].getGroups()));
            if (users[i].getHome() == null) continue;
            r[i].setHome(users[i].getHome().toString());
        }
        return new UserDescs(r);
    }

    public Strings getGroups(String sessionId) throws RemoteException {
        String[] groups = this.pool.getSecurityManager().getGroups();
        Vector<String> v = new Vector<String>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            v.addElement(groups[i]);
        }
        return new Strings(v.toArray(new String[v.size()]));
    }

    public void moveCollection(String sessionId, String collectionPath, String destinationPath, String newName) throws RemoteException {
        try {
            this.moveOrCopyCollection(sessionId, collectionPath, destinationPath, newName, true);
        }
        catch (RemoteException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (EXistException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (PermissionDeniedException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void moveResource(String sessionId, String docPath, String destinationPath, String newName) throws RemoteException {
        this.moveOrCopyResource(sessionId, docPath, destinationPath, newName, true);
    }

    public void lockResource(String sessionId, String path, String userName) throws RemoteException {
        try {
            this.lockResource(sessionId, XmldbURI.xmldbUriFor((String)path), userName);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public void lockResource(String sessionId, XmldbURI path, String userName) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        User user = session.getUser();
        DocumentImpl doc = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.pool.get(user);
            doc = broker.getXMLResource(path, 1);
            if (doc == null) {
                throw new EXistException("Resource " + path + " not found");
            }
            if (!doc.getPermissions().validate(user, 1)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + path);
            }
            SecurityManager manager = this.pool.getSecurityManager();
            if (!userName.equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("User " + user.getName() + " is not allowed " + "to lock the resource for user " + userName);
            }
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals((Object)user) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            User lo = manager.getUser(userName);
            doc.setUserLock(lo);
            broker.storeXMLResource(transaction, doc);
            transact.commit(transaction);
            return;
        }
        catch (Exception e) {
            transact.abort(transaction);
            throw new RemoteException(e.getMessage());
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.pool.release(broker);
        }
    }

    public void unlockResource(String sessionId, String path) throws RemoteException {
        try {
            this.unlockResource(sessionId, XmldbURI.xmldbUriFor((String)path));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public void unlockResource(String sessionId, XmldbURI path) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        User user = session.getUser();
        DocumentImpl doc = null;
        try {
            broker = this.pool.get(user);
            doc = broker.getXMLResource(path, 1);
            if (doc == null) {
                throw new EXistException("Resource " + path + " not found");
            }
            if (!doc.getPermissions().validate(user, 1)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + path);
            }
            SecurityManager manager = this.pool.getSecurityManager();
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals((Object)user) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            doc.setUserLock(null);
            broker.storeXMLResource(transaction, doc);
            transact.commit(transaction);
            return;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.pool.release(broker);
        }
    }

    public String hasUserLock(String sessionId, String path) throws RemoteException {
        try {
            return this.hasUserLock(sessionId, XmldbURI.xmldbUriFor((String)path));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public String hasUserLock(String sessionId, XmldbURI path) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        User user = session.getUser();
        DocumentImpl doc = null;
        try {
            broker = this.pool.get(user);
            doc = broker.getXMLResource(path, 0);
            if (doc == null) {
                throw new EXistException("Resource " + path + " not found");
            }
            if (!doc.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            if (doc == null) {
                throw new EXistException("Resource " + path + " not found");
            }
            User u = doc.getUserLock();
            String string = u == null ? "" : u.getName();
            return string;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.pool.release(broker);
        }
    }

    public Permissions getPermissions(String sessionId, String resource) throws RemoteException {
        try {
            return this.getPermissions(sessionId, XmldbURI.xmldbUriFor((String)resource));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permissions getPermissions(String sessionId, XmldbURI resource) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        User user = session.getUser();
        try {
            Permissions permissions;
            block16: {
                broker = this.pool.get(user);
                Collection collection = null;
                try {
                    collection = broker.openCollection(resource, 0);
                    Permission perm = null;
                    if (collection == null) {
                        DocumentImpl doc = null;
                        try {
                            doc = broker.getXMLResource(resource, 0);
                            if (doc == null) {
                                throw new EXistException("document or collection " + resource + " not found");
                            }
                            perm = doc.getPermissions();
                        }
                        finally {
                            if (doc != null) {
                                doc.getUpdateLock().release(0);
                            }
                        }
                    } else {
                        perm = collection.getPermissions();
                    }
                    Permissions p = new Permissions();
                    p.setOwner(perm.getOwner());
                    p.setGroup(perm.getOwnerGroup());
                    p.setPermissions(perm.getPermissions());
                    permissions = p;
                    if (collection == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (collection != null) {
                            collection.release(0);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new RemoteException(ex.getMessage());
                    }
                }
                collection.release(0);
            }
            return permissions;
        }
        finally {
            this.pool.release(broker);
        }
    }

    public EntityPermissionsList listCollectionPermissions(String sessionId, String name) throws RemoteException {
        try {
            return this.listCollectionPermissions(sessionId, XmldbURI.xmldbUriFor((String)name));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public EntityPermissionsList listCollectionPermissions(String sessionId, XmldbURI name) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        User user = session.getUser();
        Collection collection = null;
        try {
            broker = this.pool.get(user);
            collection = broker.openCollection(name, 0);
            if (collection == null) {
                throw new EXistException("Collection " + name + " not found");
            }
            if (!collection.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("not allowed to read collection " + name);
            }
            EntityPermissions[] result = new EntityPermissions[collection.getChildCollectionCount()];
            int cnt = 0;
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                XmldbURI child = (XmldbURI)i.next();
                XmldbURI path = name.append(child);
                Collection childColl = broker.getCollection(path);
                Permission perm = childColl.getPermissions();
                result[cnt] = new EntityPermissions();
                result[cnt].setName(child.toString());
                result[cnt].setOwner(perm.getOwner());
                result[cnt].setGroup(perm.getOwnerGroup());
                result[cnt].setPermissions(perm.getPermissions());
                ++cnt;
            }
            EntityPermissionsList entityPermissionsList = new EntityPermissionsList(result);
            return entityPermissionsList;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.pool.release(broker);
        }
    }

    public EntityPermissionsList listDocumentPermissions(String sessionId, String name) throws RemoteException {
        try {
            return this.listDocumentPermissions(sessionId, XmldbURI.xmldbUriFor((String)name));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public EntityPermissionsList listDocumentPermissions(String sessionId, XmldbURI name) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        User user = session.getUser();
        Collection collection = null;
        try {
            broker = this.pool.get(user);
            collection = broker.openCollection(name, 0);
            if (collection == null) {
                throw new EXistException("Collection " + name + " not found");
            }
            if (!collection.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("not allowed to read collection " + name);
            }
            EntityPermissions[] result = new EntityPermissions[collection.getDocumentCount()];
            int cnt = 0;
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                Permission perm = doc.getPermissions();
                result[cnt] = new EntityPermissions();
                result[cnt].setName(doc.getFileURI().toString());
                result[cnt].setOwner(perm.getOwner());
                result[cnt].setGroup(perm.getOwnerGroup());
                result[cnt].setPermissions(perm.getPermissions());
                ++cnt;
            }
            EntityPermissionsList entityPermissionsList = new EntityPermissionsList(result);
            return entityPermissionsList;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.pool.release(broker);
        }
    }

    public IndexedElements getIndexedElements(String sessionId, String collectionName, boolean inclusive) throws RemoteException {
        try {
            return this.getIndexedElements(sessionId, XmldbURI.xmldbUriFor((String)collectionName), inclusive);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public IndexedElements getIndexedElements(String sessionId, XmldbURI collectionName, boolean inclusive) throws RemoteException {
        DBBroker broker = null;
        Session session = this.getSession(sessionId);
        User user = session.getUser();
        Collection collection = null;
        try {
            broker = this.pool.get(user);
            collection = broker.openCollection(collectionName, 0);
            if (collection == null) {
                throw new EXistException("collection " + collectionName + " not found");
            }
            Occurrences[] occurrences = broker.getElementIndex().scanIndexedElements(collection, inclusive);
            IndexedElement[] result = new IndexedElement[occurrences.length];
            for (int i = 0; i < occurrences.length; ++i) {
                QName qname = (QName)occurrences[i].getTerm();
                result[i] = new IndexedElement(qname.getLocalName(), qname.getNamespaceURI(), qname.getPrefix() == null ? "" : qname.getPrefix(), occurrences[i].getOccurrences());
            }
            IndexedElements indexedElements = new IndexedElements(result);
            return indexedElements;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.pool.release(broker);
        }
    }
}

