/*
 * Decompiled with CFR 0.152.
 */
package org.exist.soap;

import antlr.collections.AST;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.soap.Base64BinaryArray;
import org.exist.soap.Collection;
import org.exist.soap.Query;
import org.exist.soap.QueryResponse;
import org.exist.soap.QueryResponseCollection;
import org.exist.soap.QueryResponseCollections;
import org.exist.soap.QueryResponseDocument;
import org.exist.soap.QueryResponseDocuments;
import org.exist.soap.Session;
import org.exist.soap.SessionManager;
import org.exist.soap.StringArray;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.Configuration;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class QuerySoapBindingImpl
implements Query {
    private static Logger LOG = Logger.getLogger((String)"QueryService");
    private BrokerPool pool;

    public QuerySoapBindingImpl() {
        try {
            if (!BrokerPool.isConfigured()) {
                this.configure();
            }
            this.pool = BrokerPool.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to initialize broker pool");
        }
    }

    private QueryResponseCollection[] collectQueryInfo(TreeMap collections) {
        QueryResponseCollection[] c = new QueryResponseCollection[collections.size()];
        int k = 0;
        Iterator i = collections.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            c[k] = new QueryResponseCollection();
            c[k].setCollectionName(((XmldbURI)entry.getKey()).toString());
            TreeMap documents = (TreeMap)entry.getValue();
            QueryResponseDocument[] docs = new QueryResponseDocument[documents.size()];
            c[k].setDocuments(new QueryResponseDocuments(docs));
            int l = 0;
            Iterator j = documents.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry docEntry = j.next();
                QueryResponseDocument doc = new QueryResponseDocument();
                XmldbURI docId = (XmldbURI)docEntry.getKey();
                docId = docId.lastSegment();
                doc.setDocumentName(docId.toString());
                doc.setHitCount((Integer)docEntry.getValue());
                docs[l] = doc;
                ++l;
            }
            ++k;
        }
        return c;
    }

    private void configure() throws Exception {
        Configuration config = new Configuration();
        BrokerPool.configure((int)1, (int)5, (Configuration)config);
    }

    private Session getSession(String id) throws RemoteException {
        Session session = SessionManager.getInstance().getSession(id);
        if (session == null) {
            throw new RemoteException("Session is invalid or timed out");
        }
        return session;
    }

    public String connect(String userId, String password) throws RemoteException {
        User u = this.pool.getSecurityManager().getUser(userId);
        if (u == null) {
            throw new RemoteException("user " + userId + " does not exist");
        }
        if (!u.validate(password)) {
            throw new RemoteException("the supplied password is invalid");
        }
        LOG.debug((Object)("user " + userId + " connected"));
        return SessionManager.getInstance().createSession(u);
    }

    public void disconnect(String sessionId) throws RemoteException {
        SessionManager manager = SessionManager.getInstance();
        Session session = manager.getSession(sessionId);
        if (session != null) {
            LOG.debug((Object)("disconnecting session " + sessionId));
            manager.disconnect(sessionId);
        }
    }

    public byte[] getResourceData(String sessionId, String path, boolean indent, boolean xinclude, boolean processXSLPI) throws RemoteException {
        Properties outputProperties = new Properties();
        outputProperties.setProperty("indent", indent ? "yes" : "no");
        outputProperties.setProperty("expand-xincludes", xinclude ? "yes" : "no");
        outputProperties.setProperty("process-xsl-pi", processXSLPI ? "yes" : "no");
        String xml = this.getResource(sessionId, path, outputProperties);
        try {
            return xml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            return xml.getBytes();
        }
    }

    public String getResource(String sessionId, String name, boolean indent, boolean xinclude) throws RemoteException {
        Properties outputProperties = new Properties();
        outputProperties.setProperty("indent", indent ? "yes" : "no");
        outputProperties.setProperty("expand-xincludes", xinclude ? "yes" : "no");
        return this.getResource(sessionId, name, outputProperties);
    }

    protected String getResource(String sessionId, String name, Properties outputProperties) throws RemoteException {
        try {
            return this.getResource(sessionId, XmldbURI.xmldbUriFor((String)name), outputProperties);
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    protected String getResource(String sessionId, XmldbURI name, Properties outputProperties) throws RemoteException {
        Session session = this.getSession(sessionId);
        DBBroker broker = null;
        try {
            broker = this.pool.get(session.getUser());
            DocumentImpl document = (DocumentImpl)broker.getXMLResource(name);
            if (document == null) {
                throw new RemoteException("resource " + name + " not found");
            }
            if (!document.getPermissions().validate(broker.getUser(), 4)) {
                throw new PermissionDeniedException("Not allowed to read resource");
            }
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(outputProperties);
            String string = serializer.serialize(document);
            return string;
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
            throw new RemoteException(saxe.getMessage());
        }
        catch (EXistException e) {
            throw new RemoteException(e.getMessage());
        }
        catch (PermissionDeniedException e) {
            throw new RemoteException(e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    public Collection listCollection(String sessionId, String path) throws RemoteException {
        try {
            return this.listCollection(sessionId, XmldbURI.xmldbUriFor((String)path));
        }
        catch (URISyntaxException e) {
            throw new RemoteException("Invalid collection URI", e);
        }
    }

    public Collection listCollection(String sessionId, XmldbURI path) throws RemoteException {
        Session session = this.getSession(sessionId);
        DBBroker broker = null;
        try {
            org.exist.collections.Collection collection;
            broker = this.pool.get(session.getUser());
            if (path == null) {
                path = XmldbURI.ROOT_COLLECTION_URI;
            }
            if ((collection = broker.getCollection(path)) == null) {
                throw new RemoteException("collection " + path + " not found");
            }
            if (!collection.getPermissions().validate(session.getUser(), 4)) {
                throw new RemoteException("permission denied");
            }
            Collection c = new Collection();
            String[] childCollections = new String[collection.getChildCollectionCount()];
            int j = 0;
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                childCollections[j] = ((XmldbURI)i.next()).toString();
                ++j;
            }
            String[] resources = new String[collection.getDocumentCount()];
            j = 0;
            Iterator i2 = collection.iterator(broker);
            while (i2.hasNext()) {
                XmldbURI resource = ((DocumentImpl)i2.next()).getFileURI();
                resources[j] = resource.lastSegment().toString();
                ++j;
            }
            c.setResources(new StringArray(resources));
            c.setCollections(new StringArray(childCollections));
            Collection collection2 = c;
            return collection2;
        }
        catch (EXistException e) {
            throw new RemoteException(e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    public QueryResponse xquery(String sessionId, byte[] xquery) throws RemoteException {
        String query;
        try {
            query = new String(xquery, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            query = new String(xquery);
        }
        return this.query(sessionId, query);
    }

    public QueryResponse query(String sessionId, String xpath) throws RemoteException {
        Session session = this.getSession(sessionId);
        QueryResponse resp = new QueryResponse();
        resp.setHits(0);
        DBBroker broker = null;
        try {
            LOG.debug((Object)("query: " + xpath));
            broker = this.pool.get(session.getUser());
            XQueryContext context = new XQueryContext(broker, AccessContext.SOAP);
            XQueryLexer lexer = new XQueryLexer(context, (Reader)new StringReader(xpath));
            XQueryParser parser = new XQueryParser(lexer);
            XQueryTreeParser treeParser = new XQueryTreeParser(context);
            parser.xpath();
            if (parser.foundErrors()) {
                LOG.debug((Object)parser.getErrorMessage());
                throw new RemoteException(parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            PathExpr expr = new PathExpr(context);
            treeParser.xpath(ast, expr);
            if (treeParser.foundErrors()) {
                LOG.debug((Object)treeParser.getErrorMessage());
                throw new EXistException(treeParser.getErrorMessage());
            }
            LOG.info((Object)("query: " + ExpressionDumper.dump((Expression)expr)));
            long start = System.currentTimeMillis();
            expr.analyze(new AnalyzeContextInfo());
            Sequence seq = expr.eval(null, null);
            QueryResponseCollection[] collections = null;
            if (!seq.isEmpty() && Type.subTypeOf((int)seq.getItemType(), (int)-1)) {
                collections = this.collectQueryInfo(this.scanResults(seq));
            }
            session.addQueryResult(seq);
            resp.setCollections(new QueryResponseCollections(collections));
            resp.setHits(seq.getItemCount());
            resp.setQueryTime(System.currentTimeMillis() - start);
            expr.reset();
            context.reset();
        }
        catch (Exception e) {
            try {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException("query execution failed: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.pool.release(broker);
                throw throwable;
            }
        }
        this.pool.release(broker);
        return resp;
    }

    public Base64BinaryArray retrieveData(String sessionId, int start, int howmany, boolean indent, boolean xinclude, String highlight) throws RemoteException {
        String[] results = this.retrieve(sessionId, start, howmany, indent, xinclude, highlight);
        byte[][] data = new byte[results.length][];
        for (int i = 0; i < results.length; ++i) {
            try {
                data[i] = results[i].getBytes("UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return new Base64BinaryArray(data);
    }

    public String[] retrieve(String sessionId, int start, int howmany, boolean indent, boolean xinclude, String highlight) throws RemoteException {
        Session session = this.getSession(sessionId);
        DBBroker broker = null;
        try {
            broker = this.pool.get(session.getUser());
            Session.QueryResult queryResult = session.getQueryResult();
            if (queryResult == null) {
                throw new RemoteException("result set unknown or timed out");
            }
            Sequence seq = queryResult.result;
            if (start < 1 || start > seq.getItemCount()) {
                throw new RuntimeException("index " + start + " out of bounds (" + seq.getItemCount() + ")");
            }
            if (start + howmany > seq.getItemCount() || howmany == 0) {
                howmany = seq.getItemCount() - start + 1;
            }
            String[] xml = new String[howmany];
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperty("indent", (Object)(indent ? "yes" : "no"));
            serializer.setProperty("expand-xincludes", (Object)(xinclude ? "yes" : "no"));
            serializer.setProperty("highlight-matches", (Object)highlight);
            int j = 0;
            int i = --start;
            while (i < start + howmany) {
                Item item = seq.itemAt(i);
                if (item != null) {
                    if (item.getType() == 1) {
                        NodeValue node = (NodeValue)item;
                        xml[j] = serializer.serialize(node);
                    } else {
                        xml[j] = item.getStringValue();
                    }
                }
                ++i;
                ++j;
            }
            String[] stringArray = xml;
            return stringArray;
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            e.printStackTrace();
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public String[] retrieveByDocument(String sessionId, int start, int howmany, String path, boolean indent, boolean xinclude, String highlight) throws RemoteException {
        Session session = this.getSession(sessionId);
        DBBroker broker = null;
        try {
            broker = this.pool.get(session.getUser());
            Sequence qr = session.getQueryResult().result;
            if (qr == null) {
                throw new RemoteException("result set unknown or timed out");
            }
            String[] xml = null;
            if (Type.subTypeOf((int)qr.getItemType(), (int)-1)) {
                ExtArrayNodeSet hitsByDoc = new ExtArrayNodeSet();
                SequenceIterator i = qr.iterate();
                while (i.hasNext()) {
                    NodeProxy p = (NodeProxy)i.nextItem();
                    String ppath = p.getDocument().getCollection().getURI().toString() + '/' + p.getDocument().getFileURI();
                    if (!ppath.equals(path)) continue;
                    hitsByDoc.add(p);
                }
                if (--start < 0 || start > hitsByDoc.getLength()) {
                    throw new RemoteException("index " + start + "out of bounds (" + hitsByDoc.getLength() + ")");
                }
                if (start + howmany >= hitsByDoc.getLength()) {
                    howmany = hitsByDoc.getLength() - start;
                }
                Serializer serializer = broker.getSerializer();
                serializer.reset();
                serializer.setProperty("indent", (Object)(indent ? "yes" : "no"));
                serializer.setProperty("expand-xincludes", (Object)(xinclude ? "yes" : "no"));
                serializer.setProperty("highlight-matches", (Object)highlight);
                xml = new String[howmany];
                int j = 0;
                for (int i2 = start; i2 < start + howmany; ++i2) {
                    NodeProxy proxy = hitsByDoc.get(i2);
                    if (proxy == null) {
                        throw new RuntimeException("not found: " + start);
                    }
                    xml[j] = serializer.serialize(proxy);
                    ++j;
                }
            } else {
                throw new RemoteException("result set is not a node list");
            }
            String[] stringArray = xml;
            return stringArray;
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            e.printStackTrace();
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    private TreeMap scanResults(Sequence results) throws RemoteException {
        TreeMap collections = new TreeMap();
        try {
            SequenceIterator i = results.iterate();
            while (i.hasNext()) {
                Integer hits;
                NodeValue node;
                Item item = i.nextItem();
                if (!Type.subTypeOf((int)item.getType(), (int)-1) || (node = (NodeValue)item).getImplementationType() != 1) continue;
                NodeProxy p = (NodeProxy)node;
                TreeMap<XmldbURI, Integer> documents = (TreeMap<XmldbURI, Integer>)collections.get(p.getDocument().getCollection().getURI());
                if (documents == null) {
                    documents = new TreeMap<XmldbURI, Integer>();
                    collections.put(p.getDocument().getCollection().getURI(), documents);
                }
                if ((hits = (Integer)documents.get(p.getDocument().getFileURI())) == null) {
                    documents.put(p.getDocument().getFileURI(), new Integer(1));
                    continue;
                }
                documents.put(p.getDocument().getFileURI(), new Integer(hits + 1));
            }
        }
        catch (XPathException e) {
            throw new RemoteException(e.getMessage());
        }
        return collections;
    }
}

