/*
 * Decompiled with CFR 0.152.
 */
package org.exist.soap;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.exist.security.User;
import org.exist.soap.Session;

public class SessionManager {
    private static long TIMEOUT = 3600000L;
    private static SessionManager instance = null;
    Map sessions = new TreeMap();

    public static final SessionManager getInstance() {
        if (instance == null) {
            instance = new SessionManager();
        }
        return instance;
    }

    public static long getTimeout() {
        return TIMEOUT;
    }

    public static void setTimeout(long timeout) {
        TIMEOUT = timeout;
    }

    public synchronized String createSession(User user) {
        Session session = new Session(user);
        String id = String.valueOf(session.hashCode());
        this.sessions.put(id, session);
        return id;
    }

    public synchronized Session getSession(String id) {
        if (id == null) {
            return null;
        }
        Session session = (Session)this.sessions.get(id);
        if (session != null) {
            session.updateLastAccessTime();
        }
        return session;
    }

    public synchronized void disconnect(String id) {
        this.sessions.remove(id);
    }

    private void checkResultSets() {
        Iterator i = this.sessions.values().iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            if (System.currentTimeMillis() - session.getLastAccessTime() <= TIMEOUT) continue;
            i.remove();
        }
    }
}

