/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class GetContextPath
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-context-path", "http://exist-db.org/xquery/request", "request"), "Returns the context path of the current request, i.e. the portion of the request URI that indicates the context of the request.", null, new SequenceType(22, 2)), new FunctionSignature(new QName("get-servlet-path", "http://exist-db.org/xquery/request", "request"), "Returns the servlet path of the current request, i.e. the portion of the request URI that points to the servlet which is handling the request.\nFor example an xquery GET or POST to /some/path/myfile.xq/extra/path will return /some/path/myfile.xq when myfile.xq is executed.", null, new SequenceType(22, 2))};

    public GetContextPath(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException(this.getASTNode(), "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            if (this.isCalledAs("get-context-path")) {
                return new StringValue(((RequestWrapper)value.getObject()).getContextPath());
            }
            return new StringValue(((RequestWrapper)value.getObject()).getServletPath());
        }
        throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
    }
}

