/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import javax.servlet.http.Cookie;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class GetCookieNames
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-cookie-names", "http://exist-db.org/xquery/request", "request"), "Returns the names of all Cookie's in the request", FunctionSignature.NO_ARGS, new SequenceType(22, 7));

    public GetCookieNames(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null || var.getValue().getItemType() != 100) {
            return Sequence.EMPTY_SEQUENCE;
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            Cookie[] cookies = ((RequestWrapper)value.getObject()).getCookies();
            if (cookies != null && cookies.length != 0) {
                ValueSequence names = new ValueSequence();
                for (int c = 0; c < cookies.length; ++c) {
                    names.add((Item)new StringValue(cookies[c].getName()));
                }
                return names;
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
    }
}

