/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import javax.servlet.http.Cookie;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class GetCookieValue
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-cookie-value", "http://exist-db.org/xquery/request", "request"), "Returns the value of the Cookie named in $a.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 3));

    public GetCookieValue(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null || var.getValue().getItemType() != 100) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String cookieName = args[0].getStringValue();
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            Cookie[] cookies = ((RequestWrapper)value.getObject()).getCookies();
            if (cookies != null) {
                for (int c = 0; c < cookies.length; ++c) {
                    if (!cookies[c].getName().equals(cookieName)) continue;
                    return new StringValue(cookies[c].getValue());
                }
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
    }
}

