/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GetData
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-data", "http://exist-db.org/xquery/request", "request"), "Returns the content of a POST request.If its a binary document xs:base64Binary is returned or if its an XML document a node() is returned. All other data is returned as an xs:string representaion. Returns an empty sequence if there is no data.", null, new SequenceType(11, 3));
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("get-request-data", "http://exist-db.org/xquery/request", "request"), "Returns the content of a POST request. If its a binary document xs:base64Binary is returned or if its an XML document a node() is returned. All other data is returned as an xs:string representaion. Returns an empty sequence if there is no data.", null, new SequenceType(11, 3), "Renamed to get-data.");

    public GetData(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException(this.getASTNode(), "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            RequestWrapper request = (RequestWrapper)value.getObject();
            if (request.getContentLength() == -1) {
                return Sequence.EMPTY_SEQUENCE;
            }
            byte[] bufRequestData = null;
            try {
                InputStream is = request.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(request.getContentLength());
                byte[] buf = new byte[256];
                int l = 0;
                while ((l = is.read(buf)) > -1) {
                    bos.write(buf, 0, l);
                }
                bufRequestData = bos.toByteArray();
            }
            catch (IOException ioe) {
                throw new XPathException(this.getASTNode(), "An IO exception ocurred: " + ioe.getMessage(), (Throwable)ioe);
            }
            if (bufRequestData != null) {
                String contentType = request.getContentType();
                if (contentType != null) {
                    MimeType mimeType;
                    if (contentType.indexOf(";") > -1) {
                        contentType = contentType.substring(0, contentType.indexOf(";"));
                    }
                    if ((mimeType = MimeTable.getInstance().getContentType(contentType)) != null && !mimeType.isXMLType()) {
                        return new Base64Binary(bufRequestData);
                    }
                }
                this.context.pushDocumentContext();
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    InputSource src = new InputSource(new ByteArrayInputStream(bufRequestData));
                    SAXParser parser = factory.newSAXParser();
                    XMLReader reader = parser.getXMLReader();
                    MemTreeBuilder builder = this.context.getDocumentBuilder();
                    DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
                    reader.setContentHandler((ContentHandler)receiver);
                    reader.parse(src);
                    Document doc = receiver.getDocument();
                    NodeValue nodeValue = (NodeValue)doc.getDocumentElement();
                    return nodeValue;
                }
                catch (ParserConfigurationException e) {
                }
                catch (SAXException e) {
                }
                catch (IOException e) {
                }
                finally {
                    this.context.popDocumentContext();
                }
                String encoding = request.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                try {
                    String s = new String(bufRequestData, encoding);
                    return new StringValue(s);
                }
                catch (IOException e) {
                    throw new XPathException(this.getASTNode(), "An IO exception ocurred: " + e.getMessage(), (Throwable)e);
                }
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
    }
}

