/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetParameter
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-parameter", "http://exist-db.org/xquery/request", "request"), "Returns the HTTP request parameter identified by $a. If the parameter could not be found, the default value specified in $b is returned instead. Note: this function will not try to expand predefined entities like &amp; or &lt;, so a &amp; passed through a parameter will indeed be treated as an &amp; character.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(11, 7)}, new SequenceType(22, 7)), new FunctionSignature(new QName("get-parameter", "http://exist-db.org/xquery/request", "request"), "Returns the HTTP request parameter identified by $a. If the parameter could not be found, the default value specified in $b is returned instead. Note: this function will not try to expand predefined entities like &amp; or &lt;, so a &amp; passed through a parameter will indeed be treated as an &amp; character. If the  $c (failonerror) value is set to false, then the function will not fail if there is no request in scope.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(11, 7), new SequenceType(23, 7)}, new SequenceType(22, 7))};
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("request-parameter", "http://exist-db.org/xquery/request", "request"), "Returns the HTTP request parameter identified by $a. If the parameter could not be found, the default value specified in $b is returned instead. Note: this function will not try to expand predefined entities like &amp; or &lt;, so a &amp; passed through a parameter will indeed be treated as an &amp; character.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(11, 7)}, new SequenceType(22, 7), "Renamed to request:get-parameter.");

    public GetParameter(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Variable var;
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        boolean failOnError = true;
        if (this.getSignature().getArgumentCount() == 3) {
            failOnError = args[2].effectiveBooleanValue();
        }
        if ((var = myModule.resolveVariable(RequestModule.REQUEST_VAR)) == null || var.getValue() == null || var.getValue().getItemType() != 100) {
            if (failOnError) {
                throw new XPathException(this.getASTNode(), "Variable $request is not bound to an Java object.");
            }
            return args[1];
        }
        String param = args[0].getStringValue();
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            String[] values = ((RequestWrapper)value.getObject()).getParameterValues(param);
            if (values == null || values.length == 0) {
                return args[1];
            }
            if (values.length == 1) {
                return XPathUtil.javaObjectToXPath((Object)values[0], null, (boolean)false);
            }
            return XPathUtil.javaObjectToXPath((Object)values, null, (boolean)false);
        }
        if (failOnError) {
            throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
        }
        return args[1];
    }
}

