/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class GetQueryString
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-query-string", "http://exist-db.org/xquery/request", "request"), "Returns the full query string passed to the servlet (without the initial question mark).", null, new SequenceType(22, 3));

    public GetQueryString(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null || var.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            String queryString = ((RequestWrapper)value.getObject()).getQueryString();
            if (queryString != null) {
                return new StringValue(queryString);
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
    }
}

