/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetRequestAttribute
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-attribute", "http://exist-db.org/xquery/request", "request"), "Returns the string value of the request attribute specified in the argument or the empty sequence if no such attribute exists. The attribute value should be a string.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(11, 7));

    public GetRequestAttribute(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String name = args[0].getStringValue();
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException(this.getASTNode(), "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $request is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            Object attrib = ((RequestWrapper)value.getObject()).getAttribute(name);
            return attrib == null ? Sequence.EMPTY_SEQUENCE : XPathUtil.javaObjectToXPath((Object)attrib, (XQueryContext)this.context);
        }
        throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
    }
}

