/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.request;

import java.io.File;
import org.exist.dom.QName;
import org.exist.http.servlets.RequestWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetUploadedFile
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-uploaded-file", "http://exist-db.org/xquery/request", "request"), "Retrieve the Java file object where the file part of a multi-part request has been stored. Returns the empty sequence if the request is not a multi-part request or the parameter name does not point to a file part.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(11, 3));

    public GetUploadedFile(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RequestModule myModule = (RequestModule)this.context.getModule("http://exist-db.org/xquery/request");
        Variable var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException(this.getASTNode(), "No request object found in the current XQuery context.");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException(this.getASTNode(), "Variable $request is not bound to an Java object.");
        }
        String uploadParamName = args[0].getStringValue();
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof RequestWrapper) {
            RequestWrapper request = (RequestWrapper)value.getObject();
            File file = request.getFileUploadParam(uploadParamName);
            if (file == null) {
                LOG.debug((Object)("File param not found: " + uploadParamName));
                return Sequence.EMPTY_SEQUENCE;
            }
            LOG.debug((Object)("Uploaded file: " + file.getAbsolutePath()));
            return new JavaObjectValue((Object)file);
        }
        throw new XPathException(this.getASTNode(), "Variable $request is not bound to a Request object.");
    }
}

