/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OSXAdapter
implements InvocationHandler {
    protected Object targetObject;
    protected Method targetMethod;
    protected String proxySignature;
    static Object macOSXApplication;

    public static void setQuitHandler(Object target, Method quitHandler) {
        OSXAdapter.setHandler(new OSXAdapter("handleQuit", target, quitHandler));
    }

    public static void setAboutHandler(Object target, Method aboutHandler) {
        boolean enableAboutMenu;
        boolean bl = enableAboutMenu = target != null && aboutHandler != null;
        if (enableAboutMenu) {
            OSXAdapter.setHandler(new OSXAdapter("handleAbout", target, aboutHandler));
        }
        try {
            Method enableAboutMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
            enableAboutMethod.invoke(macOSXApplication, enableAboutMenu);
        }
        catch (Exception ex) {
            System.err.println("OSXAdapter could not access the About Menu");
            ex.printStackTrace();
        }
    }

    public static void setPreferencesHandler(Object target, Method prefsHandler) {
        boolean enablePrefsMenu;
        boolean bl = enablePrefsMenu = target != null && prefsHandler != null;
        if (enablePrefsMenu) {
            OSXAdapter.setHandler(new OSXAdapter("handlePreferences", target, prefsHandler));
        }
        try {
            Method enablePrefsMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            enablePrefsMethod.invoke(macOSXApplication, enablePrefsMenu);
        }
        catch (Exception ex) {
            System.err.println("OSXAdapter could not access the About Menu");
            ex.printStackTrace();
        }
    }

    public static void setFileHandler(Object target, Method fileHandler) {
        OSXAdapter.setHandler(new OSXAdapter("handleOpenFile", target, fileHandler){

            @Override
            public boolean callTarget(Object appleEvent) {
                if (appleEvent != null) {
                    try {
                        Method getFilenameMethod = appleEvent.getClass().getDeclaredMethod("getFilename", null);
                        String filename = (String)getFilenameMethod.invoke(appleEvent, (Object[])null);
                        this.targetMethod.invoke(this.targetObject, filename);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
        });
    }

    public static void setHandler(OSXAdapter adapter) {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            if (macOSXApplication == null) {
                macOSXApplication = applicationClass.getConstructor(null).newInstance(null);
            }
            Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            Method addListenerMethod = applicationClass.getDeclaredMethod("addApplicationListener", applicationListenerClass);
            Object osxAdapterProxy = Proxy.newProxyInstance(OSXAdapter.class.getClassLoader(), new Class[]{applicationListenerClass}, (InvocationHandler)adapter);
            addListenerMethod.invoke(macOSXApplication, osxAdapterProxy);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("This version of Mac OS X does not support the Apple EAWT.  ApplicationEvent handling has been disabled (" + cnfe + ")");
        }
        catch (Exception ex) {
            System.err.println("Mac OS X Adapter could not talk to EAWT:");
            ex.printStackTrace();
        }
    }

    protected OSXAdapter(String proxySignature, Object target, Method handler) {
        this.proxySignature = proxySignature;
        this.targetObject = target;
        this.targetMethod = handler;
    }

    public boolean callTarget(Object appleEvent) throws InvocationTargetException, IllegalAccessException {
        Object result = this.targetMethod.invoke(this.targetObject, (Object[])null);
        if (result == null) {
            return true;
        }
        return Boolean.valueOf(result.toString());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isCorrectMethod(method, args)) {
            boolean handled = this.callTarget(args[0]);
            this.setApplicationEventHandled(args[0], handled);
        }
        return null;
    }

    protected boolean isCorrectMethod(Method method, Object[] args) {
        return this.targetMethod != null && this.proxySignature.equals(method.getName()) && args.length == 1;
    }

    protected void setApplicationEventHandled(Object event, boolean handled) {
        if (event != null) {
            try {
                Method setHandledMethod = event.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                setHandledMethod.invoke(event, handled);
            }
            catch (Exception ex) {
                System.err.println("OSXAdapter was unable to handle an ApplicationEvent: " + event);
                ex.printStackTrace();
            }
        }
    }
}

