/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.ngram;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import junit.framework.TestCase;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.IndexInfo;
import org.exist.dom.DocumentSet;
import org.exist.indexing.ngram.NGramIndex;
import org.exist.indexing.ngram.NGramIndexWorker;
import org.exist.security.SecurityManager;
import org.exist.security.xacml.AccessContext;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.test.TestConstants;
import org.exist.util.Configuration;
import org.exist.util.ConfigurationHelper;
import org.exist.util.Occurrences;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class CustomIndexTest
extends TestCase {
    private static String XML = "<test>   <item id='1' attr='attribute'><description>Chair</description></item>   <item id='2'><description>Table</description><price>892.25</price></item>   <item id='3'><description>Cabinet</description><price>1525.00</price></item></test>";
    private static String XML2 = "<section>   <para>01234</para>   <para>56789</para></section>";
    private static String COLLECTION_CONFIG = "<collection xmlns=\"http://exist-db.org/collection-config/1.0\">\t<index>\t\t<fulltext default=\"all\">\t\t</fulltext>\t\t<ngram qname=\"item\"/>\t\t<ngram qname=\"@attr\"/>        <ngram qname=\"para\"/>\t</index></collection>";
    private static String XUPDATE_START = "<xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\">";
    private static String XUPDATE_END = "</xu:modifications>";
    private BrokerPool pool;
    private DocumentSet docs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXUpdateRemove() {
        DBBroker broker = null;
        TransactionManager transact = null;
        Txn transaction = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            transact = this.pool.getTransactionManager();
            transaction = transact.beginTransaction();
            this.checkIndex(broker, this.docs, "cha", 1);
            this.checkIndex(broker, this.docs, "le8", 1);
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            XUpdateProcessor proc = new XUpdateProcessor(broker, this.docs, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)proc);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            String xupdate = XUPDATE_START + "   <xu:remove select=\"//item[@id='2']/price\"/>" + XUPDATE_END;
            Modification[] modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "892", 0);
            this.checkIndex(broker, this.docs, "tab", 1);
            this.checkIndex(broker, this.docs, "le8", 0);
            this.checkIndex(broker, this.docs, "cab", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "   <xu:remove select=\"//item[@id='3']/description/text()\"/>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "cab", 0);
            this.checkIndex(broker, this.docs, "att", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "   <xu:remove select=\"//item[@id='1']/@attr\"/>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "att", 0);
            this.checkIndex(broker, this.docs, "cha", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "   <xu:remove select=\"//item[@id='1']\"/>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "cha", 0);
            transact.commit(transaction);
        }
        catch (Exception e) {
            transact.abort(transaction);
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXUpdateInsert() {
        DBBroker broker = null;
        TransactionManager transact = null;
        Txn transaction = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            transact = this.pool.getTransactionManager();
            transaction = transact.beginTransaction();
            this.checkIndex(broker, this.docs, "cha", 1);
            this.checkIndex(broker, this.docs, "le8", 1);
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            XUpdateProcessor proc = new XUpdateProcessor(broker, this.docs, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)proc);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            String xupdate = XUPDATE_START + "   <xu:append select=\"/test\">" + "       <item id='4'><description>Armchair</description><price>340</price></item>" + "   </xu:append>" + XUPDATE_END;
            Modification[] modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "arm", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "       <xu:insert-before select=\"//item[@id = '1']\">" + "           <item id='0'><description>Wheelchair</description><price>1230</price></item>" + "       </xu:insert-before>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "hee", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "       <xu:insert-after select=\"//item[@id = '1']\">" + "           <item id='1.1'><description>refrigerator</description><price>777</price></item>" + "       </xu:insert-after>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "ref", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "       <xu:insert-after select=\"//item[@id = '1']/description\">" + "           <price>999</price>" + "       </xu:insert-after>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "999", 1);
            this.checkIndex(broker, this.docs, "cha", 1);
            this.checkIndex(broker, this.docs, "ir9", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "       <xu:insert-before select=\"//item[@id = '1']/description\">" + "           <price>888</price>" + "       </xu:insert-before>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "999", 1);
            this.checkIndex(broker, this.docs, "888", 1);
            this.checkIndex(broker, this.docs, "88c", 1);
            this.checkIndex(broker, this.docs, "att", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "       <xu:append select=\"//item[@id = '1']\">" + "           <xu:attribute name=\"attr\">abc</xu:attribute>" + "       </xu:append>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "att", 0);
            this.checkIndex(broker, this.docs, "abc", 1);
            transact.commit(transaction);
        }
        catch (Exception e) {
            transact.abort(transaction);
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXUpdateUpdate() {
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            this.checkIndex(broker, this.docs, "cha", 1);
            this.checkIndex(broker, this.docs, "le8", 1);
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            XUpdateProcessor proc = new XUpdateProcessor(broker, this.docs, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)proc);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            String xupdate = XUPDATE_START + "   <xu:update select=\"//item[@id = '1']/description\">wardrobe</xu:update>" + XUPDATE_END;
            Modification[] modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "war", 1);
            this.checkIndex(broker, this.docs, "cha", 0);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "   <xu:update select=\"//item[@id = '1']/description/text()\">Wheelchair</xu:update>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "whe", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "   <xu:update select=\"//item[@id = '1']/@attr\">abc</xu:update>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "abc", 1);
            transact.commit(transaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXUpdateReplace() {
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            this.checkIndex(broker, this.docs, "cha", 1);
            this.checkIndex(broker, this.docs, "le8", 1);
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            XUpdateProcessor proc = new XUpdateProcessor(broker, this.docs, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)proc);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            String xupdate = XUPDATE_START + "   <xu:replace select=\"//item[@id = '1']\">" + "       <item id='4'><description>Wheelchair</description><price>809.50</price></item>" + "   </xu:replace>" + XUPDATE_END;
            Modification[] modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "whe", 1);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            xupdate = XUPDATE_START + "   <xu:replace select=\"//item[@id = '4']/description\">" + "       <description>Armchair</description>" + "   </xu:replace>" + XUPDATE_END;
            modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "whe", 0);
            this.checkIndex(broker, this.docs, "arm", 1);
            transact.commit(transaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXUpdateRename() {
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            this.checkIndex(broker, this.docs, "cha", 1);
            this.checkIndex(broker, this.docs, "le8", 1);
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            XUpdateProcessor proc = new XUpdateProcessor(broker, this.docs, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)proc);
            proc.setBroker(broker);
            proc.setDocumentSet(this.docs);
            String xupdate = XUPDATE_START + "   <xu:rename select=\"//item[@id='2']\">renamed</xu:rename>" + XUPDATE_END;
            Modification[] modifications = proc.parse(new InputSource(new StringReader(xupdate)));
            CustomIndexTest.assertNotNull((Object)modifications);
            modifications[0].process(transaction);
            proc.reset();
            this.checkIndex(broker, this.docs, "tab", 0);
            transact.commit(transaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReindex() {
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            broker.reindexCollection(XmldbURI.xmldbUriFor((String)"/db"));
            this.checkIndex(broker, this.docs, "cha", 1);
            this.checkIndex(broker, this.docs, "le8", 1);
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            seq = xquery.execute("//section[ngram:contains(para, '123')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            seq = xquery.execute("//section[ngram:contains(para, '123')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            transact.commit(transaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDropIndex() {
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            this.checkIndex(broker, this.docs, "cha", 1);
            this.checkIndex(broker, this.docs, "le8", 1);
            Collection root = broker.openCollection(TestConstants.TEST_COLLECTION_URI, 1);
            CustomIndexTest.assertNotNull((Object)root);
            root.removeXMLResource(transaction, broker, XmldbURI.create((String)"test_string.xml"));
            this.checkIndex(broker, this.docs, "cha", 0);
            seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)0, (int)seq.getItemCount());
            transact.commit(transaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuery() {
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//item[ngram:contains(., 'cha')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            seq = xquery.execute("//section[ngram:contains(*, '123')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            seq = xquery.execute("//section[ngram:contains(para, '123')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            seq = xquery.execute("//*[ngram:contains(., '567')]", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexKeys() {
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            CustomIndexTest.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("util:index-key-occurrences(/test/item, 'cha', 'ngram-index')", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            seq = xquery.execute("util:index-key-occurrences(/test/item, 'le8', 'ngram-index')", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            seq = xquery.execute("util:index-key-documents(/test/item, 'le8', 'ngram-index')", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            seq = xquery.execute("util:index-key-documents(/test/item, 'le8', 'ngram-index')", null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            CustomIndexTest.assertEquals((int)1, (int)seq.getItemCount());
            String queryBody = "declare function local:callback($key as item(), $data as xs:int+)\nas element()+ {\n    <item>\n        <key>{$key}</key>\n        <frequency>{$data[1]}</frequency>\n    </item>\n};\n\n";
            String query = queryBody + "util:index-keys(/test/item, '', util:function('local:callback', 2), 1000, 'ngram-index')";
            seq = xquery.execute(query, null, AccessContext.TEST);
            CustomIndexTest.assertNotNull((Object)seq);
            StringWriter out = new StringWriter();
            Properties props = new Properties();
            props.setProperty("indent", "yes");
            SAXSerializer serializer = new SAXSerializer((Writer)out, props);
            serializer.startDocument();
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                next.toSAX(broker, (ContentHandler)serializer, props);
            }
            serializer.endDocument();
            System.out.println(out.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomIndexTest.fail((String)e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }

    private void checkIndex(DBBroker broker, DocumentSet docs, String term, int count) {
        NGramIndexWorker index = (NGramIndexWorker)broker.getIndexController().getWorkerByIndexId(NGramIndex.ID);
        XQueryContext context = new XQueryContext(broker, AccessContext.TEST);
        Occurrences[] occurrences = index.scanIndex(context, docs, null, null);
        int found = 0;
        for (int i = 0; i < occurrences.length; ++i) {
            Occurrences occurrence = occurrences[i];
            if (occurrence.getTerm().compareTo(term) != 0) continue;
            ++found;
        }
        CustomIndexTest.assertEquals((int)count, (int)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setUp() {
        DBBroker broker = null;
        TransactionManager transact = null;
        Txn transaction = null;
        try {
            File confFile = ConfigurationHelper.lookup((String)"conf.xml");
            System.out.printf("conf: " + confFile.getAbsolutePath(), new Object[0]);
            Configuration config = new Configuration(confFile.getAbsolutePath());
            BrokerPool.configure((int)1, (int)5, (Configuration)config);
            this.pool = BrokerPool.getInstance();
            CustomIndexTest.assertNotNull((Object)this.pool);
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            CustomIndexTest.assertNotNull((Object)broker);
            transact = this.pool.getTransactionManager();
            CustomIndexTest.assertNotNull((Object)transact);
            transaction = transact.beginTransaction();
            CustomIndexTest.assertNotNull((Object)transaction);
            System.out.println("Transaction started ...");
            Collection root = broker.getOrCreateCollection(transaction, TestConstants.TEST_COLLECTION_URI);
            CustomIndexTest.assertNotNull((Object)root);
            broker.saveCollection(transaction, root);
            CollectionConfigurationManager mgr = this.pool.getConfigurationManager();
            mgr.addConfiguration(transaction, broker, root, COLLECTION_CONFIG);
            this.docs = new DocumentSet();
            IndexInfo info = root.validateXMLResource(transaction, broker, XmldbURI.create((String)"test_string.xml"), XML);
            CustomIndexTest.assertNotNull((Object)info);
            root.store(transaction, broker, info, XML, false);
            this.docs.add(info.getDocument());
            info = root.validateXMLResource(transaction, broker, XmldbURI.create((String)"test_string2.xml"), XML2);
            CustomIndexTest.assertNotNull((Object)info);
            root.store(transaction, broker, info, XML2, false);
            this.docs.add(info.getDocument());
            transact.commit(transaction);
            if (this.pool == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
            transact.abort(transaction);
            CustomIndexTest.fail((String)e.getMessage());
            return;
        }
        finally {
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
        this.pool.release(broker);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void tearDown() {
        pool = null;
        broker = null;
        transact = null;
        transaction = null;
        try {
            pool = BrokerPool.getInstance();
            CustomIndexTest.assertNotNull((Object)pool);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            CustomIndexTest.assertNotNull((Object)broker);
            transact = pool.getTransactionManager();
            CustomIndexTest.assertNotNull((Object)transact);
            transaction = transact.beginTransaction();
            CustomIndexTest.assertNotNull((Object)transaction);
            System.out.println("Transaction started ...");
            root = broker.getOrCreateCollection(transaction, TestConstants.TEST_COLLECTION_URI);
            CustomIndexTest.assertNotNull((Object)root);
            broker.removeCollection(transaction, root);
            config = broker.getOrCreateCollection(transaction, XmldbURI.create((String)"/db/system/config/db"));
            CustomIndexTest.assertNotNull((Object)config);
            broker.removeCollection(transaction, config);
            transact.commit(transaction);
            ** if (pool == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                transact.abort(transaction);
                e.printStackTrace();
                CustomIndexTest.fail((String)e.getMessage());
                ** if (pool == null) goto lbl-1000
            }
            catch (Throwable var7_8) {
                if (pool != null) {
                    pool.release(broker);
                }
                throw var7_8;
            }
lbl-1000:
            // 1 sources

            {
                pool.release(broker);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            pool.release(broker);
        }
lbl-1000:
        // 2 sources

        {
        }
        BrokerPool.stopAll((boolean)false);
    }
}

