/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.ngram;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.IndexInfo;
import org.exist.security.SecurityManager;
import org.exist.security.xacml.AccessContext;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.test.TestConstants;
import org.exist.util.Configuration;
import org.exist.util.ConfigurationHelper;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.SAXException;

public class MatchListenerTest {
    private static String XML = "<root>   <para>some paragraph with <hi>mixed</hi> content.</para>   <para>another paragraph with <note><hi>nested</hi> inner</note> elements.</para>   <para>a third paragraph with <term>term</term>.</para>   <para>double match double match</para></root>";
    private static String XML2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<p xmlns=\"http://www.tei-c.org/ns/1.0\" xml:id=\"pT01p0257c1501\">\u723e\u6642\u6703\u4e2d\u3002\u6709\u4e00\u5c0a\u8005\u3002\u540d\u66f0\u9f8d\u8b77\u3002\u624b\u57f7\u5bf6\u62c2\u3002 \n    <lb n=\"0257c16\" ed=\"T\"/>\u4f8d\u7acb\u4f5b\u5074\u3002\u6642\u5c0a\u8005\u9f8d\u8b77\u767d\u4f5b\u8a00\u3002\u4e16\u5c0a\u3002\u6211\u898b \n    <lb n=\"0257c17\" ed=\"T\"/>\u8af8\u90aa\u5916\u9053\u5c3c\u4e7e\u5b50\u7b49\u3002\u65bc\u4f5b\u4e16\u5c0a\u3002\u5148\u4e0d\u8d77\u4fe1\u3002 \n    <lb n=\"0257c18\" ed=\"T\"/>\u552f\u65bc\u90aa\u9053\u3002\u7af6\u8aaa\u52dd\u80fd\u3002\u662f\u6545\u6211\u4eca\u5efa\u7acb\u8868\u524e \n    <lb n=\"0257c19\" ed=\"T\"/>\u5ba3\u793a\u65bc\u4e16\u3002\u54b8\u4f7f\u805e\u77e5\u4f5b\u52dd\u529f\u5fb7\u3002\u65bc\u4f5b\u4e16\u5c0a\u3002\u662f \n    <lb n=\"0257c20\" ed=\"T\"/>\u5927\u4e08\u592b\u3002\u6700\u5c0a\u6700\u4e0a\u3002\u7121\u6709\u7b49\u8005\u3002\n</p>";
    private static String CONF1 = "<collection xmlns=\"http://exist-db.org/collection-config/1.0\">\t<index>\t\t<fulltext default=\"none\">\t\t</fulltext>\t\t<ngram qname=\"para\"/>\t\t<ngram qname=\"term\"/>\t</index></collection>";
    private static String CONF2 = "<collection xmlns=\"http://exist-db.org/collection-config/1.0\">\t<index>\t\t<fulltext default=\"none\">\t\t</fulltext>\t\t<ngram qname=\"note\"/>\t</index></collection>";
    private static String CONF3 = "<collection xmlns=\"http://exist-db.org/collection-config/1.0\">\t<index xmlns:tei=\"http://www.tei-c.org/ns/1.0\">\t\t<fulltext default=\"none\">\t\t</fulltext>\t\t<ngram qname=\"tei:p\"/>\t</index></collection>";
    private static String MATCH_START = "<exist:match xmlns:exist=\"http://exist.sourceforge.net/NS/exist\">";
    private static String MATCH_END = "</exist:match>";
    private static BrokerPool pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nestedContent() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF1, XML);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//para[ngram:contains(., 'mixed')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            String result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>some paragraph with <hi>" + MATCH_START + "mixed" + MATCH_END + "</hi> content.</para>"), (String)result);
            seq = xquery.execute("//para[ngram:contains(., 'content')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>some paragraph with <hi>mixed</hi> " + MATCH_START + "content" + MATCH_END + ".</para>"), (String)result);
            seq = xquery.execute("//para[ngram:contains(., 'nested')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>another paragraph with <note><hi>" + MATCH_START + "nested" + MATCH_END + "</hi> inner</note> elements.</para>"), (String)result);
            seq = xquery.execute("//para[ngram:contains(., 'content') and ngram:contains(., 'mixed')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>some paragraph with <hi>" + MATCH_START + "mixed" + MATCH_END + "</hi> " + MATCH_START + "content" + MATCH_END + ".</para>"), (String)result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void matchInParent() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF1, XML);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//para[ngram:contains(., 'mixed')]/hi", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            String result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<hi>" + MATCH_START + "mixed" + MATCH_END + "</hi>"), (String)result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void matchInAncestor() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF1, XML);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//para[ngram:contains(., 'nested')]/note", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            String result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<note><hi>" + MATCH_START + "nested" + MATCH_END + "</hi> inner</note>"), (String)result);
            seq = xquery.execute("//para[ngram:contains(., 'nested')]//hi", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<hi>" + MATCH_START + "nested" + MATCH_END + "</hi>"), (String)result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nestedIndex() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF1, XML);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//para[ngram:contains(term, 'term')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            String result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>a third paragraph with <term>" + MATCH_START + "term" + MATCH_END + "</term>.</para>"), (String)result);
            seq = xquery.execute("//term[ngram:contains(., 'term')]/..", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>a third paragraph with <term>" + MATCH_START + "term" + MATCH_END + "</term>.</para>"), (String)result);
            seq = xquery.execute("//term[ngram:contains(., 'term')]/ancestor::para", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>a third paragraph with <term>" + MATCH_START + "term" + MATCH_END + "</term>.</para>"), (String)result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mixedContentQueries() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF1, XML);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//para[ngram:contains(., 'mixed content')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            String result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>some paragraph with <hi>" + MATCH_START + "mixed" + MATCH_END + "</hi>" + MATCH_START + " content" + MATCH_END + ".</para>"), (String)result);
            seq = xquery.execute("//para[ngram:contains(., 'with mixed content')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>some paragraph " + MATCH_START + "with " + MATCH_END + "<hi>" + MATCH_START + "mixed" + MATCH_END + "</hi>" + MATCH_START + " content" + MATCH_END + ".</para>"), (String)result);
            seq = xquery.execute("//para[ngram:contains(., 'with nested')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>another paragraph " + MATCH_START + "with " + MATCH_END + "<note><hi>" + MATCH_START + "nested" + MATCH_END + "</hi> inner</note> elements.</para>"), (String)result);
            seq = xquery.execute("//para[ngram:contains(., 'with nested inner elements')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>another paragraph " + MATCH_START + "with " + MATCH_END + "<note><hi>" + MATCH_START + "nested" + MATCH_END + "</hi>" + MATCH_START + " inner" + MATCH_END + "</note>" + MATCH_START + " elements" + MATCH_END + ".</para>"), (String)result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void indexOnInnerElement() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF2, XML);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//para[ngram:contains(note, 'nested inner')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            String result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>another paragraph with <note><hi>" + MATCH_START + "nested" + MATCH_END + "</hi>" + MATCH_START + " inner" + MATCH_END + "</note> elements.</para>"), (String)result);
            seq = xquery.execute("//note[ngram:contains(., 'nested inner')]/parent::para", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>another paragraph with <note><hi>" + MATCH_START + "nested" + MATCH_END + "</hi>" + MATCH_START + " inner" + MATCH_END + "</note> elements.</para>"), (String)result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doubleMatch() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF1, XML);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            Sequence seq = xquery.execute("//para[ngram:contains(., 'double match')]", null, AccessContext.TEST);
            Assert.assertNotNull((Object)seq);
            Assert.assertEquals((long)1L, (long)seq.getItemCount());
            String result = this.queryResult2String(broker, seq);
            System.out.println("RESULT: " + result);
            XMLAssert.assertEquals((String)("<para>" + MATCH_START + "double match" + MATCH_END + " " + MATCH_START + "double match" + MATCH_END + "</para>"), (String)result);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void smallStrings() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF3, XML2);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            String[] strings = new String[]{"\u9f8d", "\u9f8d\u8b77", "\u66f0\u9f8d\u8b77", "\u540d\u66f0\u9f8d\u8b77"};
            for (int i = 0; i < strings.length; ++i) {
                Sequence seq = xquery.execute("declare namespace tei=\"http://www.tei-c.org/ns/1.0\";\n//tei:p[ngram:contains(., '" + strings[i] + "')]", null, AccessContext.TEST);
                Assert.assertNotNull((Object)seq);
                Assert.assertEquals((long)1L, (long)seq.getItemCount());
                String result = this.queryResult2String(broker, seq);
                System.out.println("RESULT: " + result);
                XMLAssert.assertXpathEvaluatesTo((String)(i < 2 ? "2" : "1"), (String)"count(//exist:match)", (String)result);
                XMLAssert.assertXpathExists((String)("//exist:match[text() = '" + strings[i] + "']"), (String)result);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void constructedNodes() {
        DBBroker broker = null;
        try {
            this.configureAndStore(CONF3, XML2);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            XQuery xquery = broker.getXQueryService();
            Assert.assertNotNull((Object)xquery);
            String[] strings = new String[]{"\u9f8d", "\u9f8d\u8b77", "\u66f0\u9f8d\u8b77", "\u540d\u66f0\u9f8d\u8b77"};
            for (int i = 0; i < strings.length; ++i) {
                Sequence seq = xquery.execute("declare namespace tei=\"http://www.tei-c.org/ns/1.0\";\nfor $para in //tei:p[ngram:contains(., '" + strings[i] + "')]\n" + "return\n" + "   <match>{$para}</match>", null, AccessContext.TEST);
                Assert.assertNotNull((Object)seq);
                Assert.assertEquals((long)1L, (long)seq.getItemCount());
                String result = this.queryResult2String(broker, seq);
                System.out.println("RESULT: " + result);
                XMLAssert.assertXpathEvaluatesTo((String)(i < 2 ? "2" : "1"), (String)"count(//exist:match)", (String)result);
                XMLAssert.assertXpathExists((String)("//exist:match[text() = '" + strings[i] + "']"), (String)result);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                pool.release(broker);
                throw throwable;
            }
            pool.release(broker);
        }
        pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @BeforeClass
    public static void startDB() {
        block6: {
            DBBroker broker = null;
            TransactionManager transact = null;
            Txn transaction = null;
            try {
                File confFile = ConfigurationHelper.lookup((String)"conf.xml");
                Configuration config = new Configuration(confFile.getAbsolutePath());
                BrokerPool.configure((int)1, (int)5, (Configuration)config);
                pool = BrokerPool.getInstance();
                Assert.assertNotNull((Object)pool);
                broker = pool.get(SecurityManager.SYSTEM_USER);
                Assert.assertNotNull((Object)broker);
                transact = pool.getTransactionManager();
                Assert.assertNotNull((Object)transact);
                transaction = transact.beginTransaction();
                Assert.assertNotNull((Object)transaction);
                System.out.println("Transaction started ...");
                Collection root = broker.getOrCreateCollection(transaction, TestConstants.TEST_COLLECTION_URI);
                Assert.assertNotNull((Object)root);
                broker.saveCollection(transaction, root);
                transact.commit(transaction);
                if (pool == null) break block6;
            }
            catch (Exception e) {
                transact.abort(transaction);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                break block6;
            }
            pool.release(broker);
            break block6;
            finally {
                if (pool != null) {
                    pool.release(broker);
                }
            }
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("tei", "http://www.tei-c.org/ns/1.0");
        m.put("exist", "http://exist.sourceforge.net/NS/exist");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(m);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @AfterClass
    public static void closeDB() {
        pool = null;
        broker = null;
        transact = null;
        transaction = null;
        try {
            pool = BrokerPool.getInstance();
            Assert.assertNotNull((Object)pool);
            broker = pool.get(SecurityManager.SYSTEM_USER);
            Assert.assertNotNull((Object)broker);
            transact = pool.getTransactionManager();
            Assert.assertNotNull((Object)transact);
            transaction = transact.beginTransaction();
            Assert.assertNotNull((Object)transaction);
            System.out.println("Transaction started ...");
            root = broker.getOrCreateCollection(transaction, TestConstants.TEST_COLLECTION_URI);
            Assert.assertNotNull((Object)root);
            broker.removeCollection(transaction, root);
            config = broker.getOrCreateCollection(transaction, XmldbURI.create((String)"/db/system/config/db"));
            Assert.assertNotNull((Object)config);
            broker.removeCollection(transaction, config);
            transact.commit(transaction);
            ** if (pool == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                transact.abort(transaction);
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                ** if (pool == null) goto lbl-1000
            }
            catch (Throwable var6_7) {
                if (pool != null) {
                    pool.release(broker);
                }
                throw var6_7;
            }
lbl-1000:
            // 1 sources

            {
                pool.release(broker);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            pool.release(broker);
        }
lbl-1000:
        // 2 sources

        {
        }
        BrokerPool.stopAll((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureAndStore(String config, String xml) {
        DBBroker broker = null;
        TransactionManager transact = null;
        Txn transaction = null;
        try {
            broker = pool.get(SecurityManager.SYSTEM_USER);
            Assert.assertNotNull((Object)broker);
            transact = pool.getTransactionManager();
            Assert.assertNotNull((Object)transact);
            transaction = transact.beginTransaction();
            Assert.assertNotNull((Object)transaction);
            Collection root = broker.getOrCreateCollection(transaction, TestConstants.TEST_COLLECTION_URI);
            Assert.assertNotNull((Object)root);
            CollectionConfigurationManager mgr = pool.getConfigurationManager();
            mgr.addConfiguration(transaction, broker, root, config);
            IndexInfo info = root.validateXMLResource(transaction, broker, XmldbURI.create((String)"test_matches.xml"), xml);
            Assert.assertNotNull((Object)info);
            root.store(transaction, broker, info, xml, false);
            transact.commit(transaction);
        }
        catch (Exception e) {
            transact.abort(transaction);
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            pool.release(broker);
        }
    }

    private String queryResult2String(DBBroker broker, Sequence seq) throws SAXException, XPathException {
        Properties props = new Properties();
        props.setProperty("indent", "no");
        props.setProperty("highlight-matches", "elements");
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperties(props);
        return serializer.serialize((NodeValue)seq.itemAt(0));
    }
}

