/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.ngram;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.exist.backup.RawDataBackup;
import org.exist.indexing.AbstractIndex;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.RawBackupSupport;
import org.exist.indexing.ngram.NGramIndexWorker;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.DBException;
import org.exist.storage.index.BFile;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;

public class NGramIndex
extends AbstractIndex
implements RawBackupSupport {
    public static final String ID = NGramIndex.class.getName();
    private static final Logger LOG = Logger.getLogger((Class)NGramIndex.class);
    protected BFile db;
    private int gramSize = 3;
    private File dataFile = null;

    public void configure(BrokerPool pool, String dataDir, Element config) throws DatabaseConfigurationException {
        super.configure(pool, dataDir, config);
        String fileName = "ngram.dbx";
        if (config.hasAttribute("file")) {
            fileName = config.getAttribute("file");
        }
        if (config.hasAttribute("n")) {
            try {
                this.gramSize = Integer.parseInt(config.getAttribute("n"));
            }
            catch (NumberFormatException e) {
                throw new DatabaseConfigurationException("Configuration parameter 'n' should be an integer.");
            }
        }
        this.dataFile = new File(dataDir, fileName);
    }

    public void open() throws DatabaseConfigurationException {
        try {
            this.db = new BFile(this.pool, 0, false, this.dataFile, this.pool.getCacheManager(), 1.4, 0.01, 0.07);
        }
        catch (DBException e) {
            throw new DatabaseConfigurationException("Failed to create index file: " + this.dataFile.getAbsolutePath() + ": " + e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created NGram index: " + this.dataFile.getAbsolutePath()));
        }
    }

    public void close() throws DBException {
        LOG.debug((Object)"SYNC NGRAM");
        this.db.close();
    }

    public void sync() throws DBException {
        LOG.debug((Object)"SYNC NGRAM");
        this.db.flush();
    }

    public void remove() throws DBException {
        this.db.closeAndRemove();
    }

    public boolean checkIndex(DBBroker broker) {
        return true;
    }

    public IndexWorker getWorker(DBBroker broker) {
        return new NGramIndexWorker(broker, this);
    }

    public int getN() {
        return this.gramSize;
    }

    public void backupToArchive(RawDataBackup backup) throws IOException {
        OutputStream os = backup.newEntry(this.db.getFile().getName());
        this.db.backupToStream(os);
        backup.closeEntry();
    }
}

