/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.ngram;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.SymbolTable;
import org.exist.dom.TextImpl;
import org.exist.indexing.AbstractMatchListener;
import org.exist.indexing.AbstractStreamListener;
import org.exist.indexing.Index;
import org.exist.indexing.IndexController;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.OrderedValuesIndex;
import org.exist.indexing.QNamedKeysIndex;
import org.exist.indexing.StreamListener;
import org.exist.indexing.ngram.NGramIndex;
import org.exist.indexing.ngram.NGramIndexConfig;
import org.exist.indexing.ngram.NGramMatchCallback;
import org.exist.numbering.NodeId;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.ElementValue;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.OccurrenceList;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Value;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteArray;
import org.exist.util.ByteConversion;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FastQSort;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.util.ReadOnlyException;
import org.exist.util.UTF8;
import org.exist.util.XMLString;
import org.exist.util.serializer.AttrList;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NGramIndexWorker
implements OrderedValuesIndex,
QNamedKeysIndex {
    private static final Logger LOG = Logger.getLogger((Class)NGramIndexWorker.class);
    private static final String INDEX_ELEMENT = "ngram";
    private static final String QNAME_ATTR = "qname";
    private static final byte IDX_QNAME = 0;
    private static final byte IDX_GENERIC = 1;
    private int mode = 0;
    private NGramIndex index;
    private char[] buf = new char[1024];
    private int currentChar = 0;
    private DocumentImpl currentDoc = null;
    private DBBroker broker;
    private IndexController controller;
    private Map ngrams = new TreeMap();
    private VariableByteOutputStream os = new VariableByteOutputStream(7);
    private NGramMatchListener matchListener = null;
    private StreamListener listener = new NGramStreamListener();
    private Map config;
    private Stack contentStack = null;

    public NGramIndexWorker(DBBroker broker, NGramIndex index) {
        this.broker = broker;
        this.index = index;
        Arrays.fill(this.buf, ' ');
    }

    public String getIndexId() {
        return NGramIndex.ID;
    }

    public String getIndexName() {
        return this.index.getIndexName();
    }

    public Index getIndex() {
        return this.index;
    }

    public int getN() {
        return this.index.getN();
    }

    public Object configure(IndexController controller, NodeList configNodes, Map namespaces) throws DatabaseConfigurationException {
        this.controller = controller;
        TreeMap<QName, NGramIndexConfig> map = new TreeMap<QName, NGramIndexConfig>();
        for (int i = 0; i < configNodes.getLength(); ++i) {
            Node node = configNodes.item(i);
            if (node.getNodeType() != 1 || !INDEX_ELEMENT.equals(node.getLocalName())) continue;
            String qname = ((Element)node).getAttribute(QNAME_ATTR);
            if (qname == null || qname.length() == 0) {
                throw new DatabaseConfigurationException("Configuration error: element " + node.getNodeName() + " must have an attribute " + QNAME_ATTR);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("NGram index defined on " + qname));
            }
            NGramIndexConfig config = new NGramIndexConfig(namespaces, qname);
            map.put(config.getQName(), config);
        }
        return map;
    }

    public void flush() {
        switch (this.mode) {
            case 0: {
                this.saveIndex();
                break;
            }
            case 1: 
            case 2: {
                this.dropIndex(this.mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIndex() {
        if (this.ngrams.size() == 0) {
            return;
        }
        Iterator iterator = this.ngrams.entrySet().iterator();
        while (iterator.hasNext()) {
            int freq;
            Map.Entry entry = iterator.next();
            QNameTerm key = (QNameTerm)entry.getKey();
            OccurrenceList occurences = (OccurrenceList)entry.getValue();
            occurences.sort();
            this.os.clear();
            this.os.writeInt(this.currentDoc.getDocId());
            this.os.writeByte(key.qname.getNameType());
            this.os.writeInt(occurences.getTermCount());
            int lenOffset = this.os.position();
            this.os.writeFixedInt(0);
            NodeId previous = null;
            for (int m = 0; m < occurences.getSize(); m += freq) {
                try {
                    previous = occurences.getNode(m).write(previous, this.os);
                }
                catch (IOException e) {
                    LOG.error((Object)("IOException while writing fulltext index: " + e.getMessage()), (Throwable)e);
                }
                freq = occurences.getOccurrences(m);
                this.os.writeInt(freq);
                for (int n = 0; n < freq; ++n) {
                    this.os.writeInt(occurences.getOffset(m + n));
                }
            }
            this.os.writeFixedInt(lenOffset, this.os.position() - lenOffset - 4);
            ByteArray data = this.os.data();
            if (data.size() == 0) continue;
            Lock lock = this.index.db.getLock();
            try {
                lock.acquire(1);
                NGramQNameKey value = new NGramQNameKey(this.currentDoc.getCollection().getId(), key.qname, this.broker.getBrokerPool().getSymbols(), key.term);
                this.index.db.append((Value)value, data);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for file " + this.index.db.getFile().getName()), (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)("IO error for file " + this.index.db.getFile().getName()), (Throwable)e);
            }
            catch (ReadOnlyException e) {
                LOG.warn((Object)("Read-only error for file " + this.index.db.getFile().getName()), (Throwable)e);
            }
            finally {
                lock.release(1);
                this.os.clear();
            }
        }
        this.ngrams.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndex(int mode) {
        if (this.ngrams.size() == 0) {
            return;
        }
        Iterator iterator = this.ngrams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            QNameTerm key = (QNameTerm)entry.getKey();
            OccurrenceList occurencesList = (OccurrenceList)entry.getValue();
            occurencesList.sort();
            this.os.clear();
            Lock lock = this.index.db.getLock();
            try {
                lock.acquire(1);
                NGramQNameKey value = new NGramQNameKey(this.currentDoc.getCollection().getId(), key.qname, this.broker.getBrokerPool().getSymbols(), key.term);
                boolean changed = false;
                this.os.clear();
                VariableByteInput is = this.index.db.getAsStream((Value)value);
                if (is == null) continue;
                while (is.available() > 0) {
                    int storedDocId = is.readInt();
                    byte nameType = is.readByte();
                    int occurrences = is.readInt();
                    int length = is.readFixedInt();
                    if (storedDocId != this.currentDoc.getDocId()) {
                        this.os.writeInt(storedDocId);
                        this.os.writeByte(nameType);
                        this.os.writeInt(occurrences);
                        this.os.writeFixedInt(length);
                        is.copyRaw(this.os, length);
                        continue;
                    }
                    if (mode == 1) {
                        is.skipBytes((long)length);
                    } else {
                        int n;
                        int freq;
                        NodeId previous = null;
                        OccurrenceList newOccurrences = new OccurrenceList();
                        for (int m = 0; m < occurrences; ++m) {
                            NodeId nodeId;
                            previous = nodeId = this.index.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                            freq = is.readInt();
                            if (!occurencesList.contains(nodeId)) {
                                for (n = 0; n < freq; ++n) {
                                    newOccurrences.add(nodeId, is.readInt());
                                }
                                continue;
                            }
                            is.skip(freq);
                        }
                        if (newOccurrences.getSize() > 0) {
                            newOccurrences.sort();
                            this.os.writeInt(this.currentDoc.getDocId());
                            this.os.writeByte(nameType);
                            this.os.writeInt(newOccurrences.getTermCount());
                            int lenOffset = this.os.position();
                            this.os.writeFixedInt(0);
                            previous = null;
                            for (int m = 0; m < newOccurrences.getSize(); m += freq) {
                                previous = newOccurrences.getNode(m).write(previous, this.os);
                                freq = newOccurrences.getOccurrences(m);
                                this.os.writeInt(freq);
                                for (n = 0; n < freq; ++n) {
                                    this.os.writeInt(newOccurrences.getOffset(m + n));
                                }
                            }
                            this.os.writeFixedInt(lenOffset, this.os.position() - lenOffset - 4);
                        }
                    }
                    changed = true;
                }
                if (!changed) continue;
                if (this.os.data().size() == 0) {
                    this.index.db.remove((Value)value);
                    continue;
                }
                if (this.index.db.put((Value)value, this.os.data()) != -1L) continue;
                LOG.error((Object)("Could not put index data for token '" + key.term + "' in '" + this.index.db.getFile().getName() + "'"));
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock for file " + this.index.db.getFile().getName()), (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)("IO error for file " + this.index.db.getFile().getName()), (Throwable)e);
            }
            catch (ReadOnlyException e) {
                LOG.warn((Object)("Read-only error for file " + this.index.db.getFile().getName()), (Throwable)e);
            }
            finally {
                lock.release(1);
                this.os.clear();
            }
        }
        this.ngrams.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollection(Collection collection, DBBroker broker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Dropping NGram index for collection " + collection.getURI()));
        }
        Lock lock = this.index.db.getLock();
        try {
            lock.acquire(1);
            NGramQNameKey value = new NGramQNameKey(collection.getId());
            this.index.db.removeAll(null, new IndexQuery(7, (Value)value));
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock for '" + this.index.db.getFile().getName() + "'"), (Throwable)e);
        }
        catch (BTreeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet search(int contextId, DocumentSet docs, List qnames, String query, String ngram, XQueryContext context, NodeSet contextSet, int axis) throws TerminatedException {
        if (qnames == null || qnames.isEmpty()) {
            qnames = this.getDefinedIndexes(context.getBroker(), docs);
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet(docs.getLength(), 250);
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            int collectionId = ((Collection)iter.next()).getId();
            for (int i = 0; i < qnames.size(); ++i) {
                QName qname = (QName)qnames.get(i);
                NGramQNameKey key = new NGramQNameKey(collectionId, qname, context.getBroker().getBrokerPool().getSymbols(), query);
                Lock lock = this.index.db.getLock();
                try {
                    lock.acquire(0);
                    SearchCallback cb = new SearchCallback(contextId, query, ngram, docs, contextSet, context, (NodeSet)result, axis == 0);
                    int op = query.length() < this.getN() ? 7 : 1;
                    this.index.db.query(new IndexQuery(op, (Value)key), (BTreeCallback)cb);
                    continue;
                }
                catch (LockException e) {
                    LOG.warn((Object)("Failed to acquire lock for '" + this.index.db.getFile().getName() + "'"), (Throwable)e);
                    continue;
                }
                catch (IOException e) {
                    LOG.error((Object)(e.getMessage() + " in '" + this.index.db.getFile().getName() + "'"), (Throwable)e);
                    continue;
                }
                catch (BTreeException e) {
                    LOG.error((Object)(e.getMessage() + " in '" + this.index.db.getFile().getName() + "'"), (Throwable)e);
                    continue;
                }
                finally {
                    lock.release(0);
                }
            }
        }
        return result;
    }

    private List getDefinedIndexes(DBBroker broker, DocumentSet docs) {
        ArrayList<QName> indexes = new ArrayList<QName>(20);
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Map config;
            Collection collection = (Collection)i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(broker);
            if (idxConf == null || (config = (Map)idxConf.getCustomIndexSpec(NGramIndex.ID)) == null) continue;
            Iterator ci = config.keySet().iterator();
            while (ci.hasNext()) {
                QName qn = (QName)ci.next();
                indexes.add(qn);
            }
        }
        return indexes;
    }

    public boolean checkIndex(DBBroker broker) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Occurrences[] scanIndex(XQueryContext context, DocumentSet docs, NodeSet contextSet, Map hints) {
        Object end;
        List qnames = hints == null ? null : (List)hints.get("qnames_key");
        Object start = hints == null ? null : hints.get("start_value");
        Object v0 = end = hints == null ? null : hints.get("end_value");
        if (qnames == null || qnames.isEmpty()) {
            qnames = this.getDefinedIndexes(context.getBroker(), docs);
        }
        Lock lock = this.index.db.getLock();
        IndexScanCallback cb = new IndexScanCallback(docs, contextSet);
        for (int q = 0; q < qnames.size(); ++q) {
            Iterator i = docs.getCollectionIterator();
            while (i.hasNext()) {
                IndexQuery query;
                NGramQNameKey startRef;
                int collectionId = ((Collection)i.next()).getId();
                if (start == null) {
                    startRef = new NGramQNameKey(collectionId);
                    query = new IndexQuery(7, (Value)startRef);
                } else if (end == null) {
                    startRef = new NGramQNameKey(collectionId, (QName)qnames.get(q), context.getBroker().getBrokerPool().getSymbols(), ((StringValue)start).getStringValue().toLowerCase());
                    query = new IndexQuery(7, (Value)startRef);
                } else {
                    startRef = new NGramQNameKey(collectionId, (QName)qnames.get(q), context.getBroker().getBrokerPool().getSymbols(), ((StringValue)start).getStringValue().toLowerCase());
                    NGramQNameKey endRef = new NGramQNameKey(collectionId, (QName)qnames.get(q), context.getBroker().getBrokerPool().getSymbols(), ((StringValue)end).getStringValue().toLowerCase());
                    query = new IndexQuery(4, (Value)startRef, (Value)endRef);
                }
                try {
                    lock.acquire(0);
                    this.index.db.query(query, (BTreeCallback)cb);
                }
                catch (LockException e) {
                    LOG.warn((Object)("Failed to acquire lock for '" + this.index.db.getFile().getName() + "'"), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BTreeException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (TerminatedException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.release(0);
                }
            }
        }
        Occurrences[] result = new Occurrences[cb.map.size()];
        return cb.map.values().toArray(result);
    }

    public StreamListener getListener() {
        return this.listener;
    }

    public MatchListener getMatchListener(DBBroker broker, NodeProxy proxy) {
        return this.getMatchListener(broker, proxy, null);
    }

    public MatchListener getMatchListener(DBBroker broker, NodeProxy proxy, NGramMatchCallback callback) {
        boolean needToFilter = false;
        for (Match nextMatch = proxy.getMatches(); nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (nextMatch.getIndexId() != NGramIndex.ID) continue;
            needToFilter = true;
            break;
        }
        if (!needToFilter) {
            return null;
        }
        if (this.matchListener == null) {
            this.matchListener = new NGramMatchListener(broker, proxy);
        } else {
            this.matchListener.reset(broker, proxy);
        }
        this.matchListener.setMatchCallback(callback);
        return this.matchListener;
    }

    public StoredNode getReindexRoot(StoredNode node, NodePath path, boolean includeSelf) {
        if (node.getNodeType() == 2) {
            return null;
        }
        IndexSpec indexConf = node.getDocument().getCollection().getIndexConfiguration(this.broker);
        if (indexConf != null) {
            Map config = (Map)indexConf.getCustomIndexSpec(NGramIndex.ID);
            if (config == null) {
                return null;
            }
            boolean reindexRequired = false;
            int len = node.getNodeType() == 1 && !includeSelf ? path.length() - 1 : path.length();
            for (int i = 0; i < len; ++i) {
                QName qn = path.getComponent(i);
                if (config.get(qn) == null) continue;
                reindexRequired = true;
                break;
            }
            if (reindexRequired) {
                StoredNode topMost = null;
                for (StoredNode currentNode = node; currentNode != null; currentNode = (StoredNode)currentNode.getParentNode()) {
                    if (config.get(currentNode.getQName()) != null) {
                        topMost = currentNode;
                    }
                    if (currentNode.getDocument().getCollection().isTempCollection() && currentNode.getNodeId().getTreeLevel() == 2) break;
                }
                return topMost;
            }
        }
        return null;
    }

    public String[] tokenize(CharSequence text) {
        int len = text.length();
        int gramSize = this.index.getN();
        String[] ngrams = new String[len];
        int next = 0;
        for (int i = 0; i < len; ++i) {
            this.checkBuffer();
            for (int j = 0; j < gramSize && i + j < len; ++j) {
                this.buf[this.currentChar + j] = Character.toLowerCase(text.charAt(i + j));
            }
            ngrams[next++] = new String(this.buf, this.currentChar, gramSize);
            this.currentChar += gramSize;
        }
        return ngrams;
    }

    public String[] getDistinctNGrams(CharSequence text) {
        int ngramSize = this.index.getN();
        int count = text.length() / ngramSize;
        int remainder = text.length() % ngramSize;
        String[] n = new String[remainder > 0 ? count + 1 : count];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            char[] ch = new char[ngramSize];
            for (int j = 0; j < ngramSize; ++j) {
                ch[j] = Character.toLowerCase(text.charAt(pos++));
            }
            n[i] = new String(ch);
        }
        if (remainder > 0) {
            char[] ch = new char[remainder];
            for (int i = 0; i < remainder; ++i) {
                ch[i] = Character.toLowerCase(text.charAt(pos++));
            }
            n[count] = new String(ch);
        }
        return n;
    }

    private void indexText(NodeId nodeId, QName qname, CharSequence text) {
        String[] ngram = this.tokenize(text);
        int len = ngram.length;
        for (int i = 0; i < len; ++i) {
            QNameTerm key = new QNameTerm(qname, ngram[i]);
            OccurrenceList list = (OccurrenceList)this.ngrams.get(key);
            if (list == null) {
                list = new OccurrenceList();
                list.add(nodeId, i);
                this.ngrams.put(key, list);
                continue;
            }
            list.add(nodeId, i);
        }
    }

    private void checkBuffer() {
        if (this.currentChar + this.index.getN() > this.buf.length) {
            this.buf = new char[1024];
            Arrays.fill(this.buf, ' ');
            this.currentChar = 0;
        }
    }

    public void setDocument(DocumentImpl document) {
        this.setDocument(document, -1);
    }

    public void setMode(int newMode) {
        this.mode = newMode;
    }

    public DocumentImpl getDocument() {
        return this.currentDoc;
    }

    public int getMode() {
        return this.mode;
    }

    public void setDocument(DocumentImpl document, int newMode) {
        this.currentDoc = document;
        this.contentStack = null;
        IndexSpec indexConf = document.getCollection().getIndexConfiguration(this.broker);
        if (indexConf != null) {
            this.config = (Map)indexConf.getCustomIndexSpec(NGramIndex.ID);
        }
        this.mode = newMode;
    }

    public class NGramMatch
    extends Match {
        public NGramMatch(int contextId, NodeId nodeId, String matchTerm) {
            super(contextId, nodeId, matchTerm);
        }

        public NGramMatch(int contextId, NodeId nodeId, String matchTerm, int frequency) {
            super(contextId, nodeId, matchTerm, frequency);
        }

        public NGramMatch(Match match) {
            super(match);
        }

        public Match createInstance(int contextId, NodeId nodeId, String matchTerm) {
            return new NGramMatch(contextId, nodeId, matchTerm);
        }

        public Match newCopy() {
            return new NGramMatch(this);
        }

        public String getIndexId() {
            return NGramIndex.ID;
        }
    }

    private final class IndexScanCallback
    implements BTreeCallback {
        private DocumentSet docs;
        private NodeSet contextSet;
        private Map map = new TreeMap();

        IndexScanCallback(DocumentSet docs) {
            this.docs = docs;
        }

        IndexScanCallback(DocumentSet docs, NodeSet contextSet) {
            this.docs = docs;
            this.contextSet = contextSet;
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            VariableByteInput is;
            String term;
            try {
                term = new String(key.getData(), NGramQNameKey.NGRAM_OFFSET, key.getLength() - NGramQNameKey.NGRAM_OFFSET, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
            try {
                is = ((NGramIndexWorker)NGramIndexWorker.this).index.db.getAsStream(pointer);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
            try {
                while (is.available() > 0) {
                    boolean docAdded = false;
                    int storedDocId = is.readInt();
                    byte nameType = is.readByte();
                    int occurrences = is.readInt();
                    int length = is.readFixedInt();
                    DocumentImpl storedDocument = this.docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes((long)length);
                        continue;
                    }
                    NodeId previous = null;
                    for (int m = 0; m < occurrences; ++m) {
                        NodeId nodeId;
                        previous = nodeId = NGramIndexWorker.this.index.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        int freq = is.readInt();
                        is.skip(freq);
                        boolean include = true;
                        if (this.contextSet != null) {
                            NodeProxy parentNode = this.contextSet.parentWithChild(storedDocument, nodeId, false, true);
                            boolean bl = include = parentNode != null;
                        }
                        if (!include) continue;
                        Occurrences oc = (Occurrences)this.map.get(term);
                        if (oc == null) {
                            oc = new Occurrences((Comparable)((Object)term));
                            this.map.put(term, oc);
                        }
                        if (!docAdded) {
                            oc.addDocument(storedDocument);
                            docAdded = true;
                        }
                        oc.addOccurrences(freq);
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)(e.getMessage() + " in '" + ((NGramIndexWorker)NGramIndexWorker.this).index.db.getFile().getName() + "'"), (Throwable)e);
            }
            return true;
        }
    }

    private final class SearchCallback
    implements BTreeCallback {
        private int contextId;
        private String query;
        private String ngram;
        private DocumentSet docs;
        private NodeSet contextSet;
        private XQueryContext context;
        private NodeSet resultSet;
        private boolean returnAncestor;

        public SearchCallback(int contextId, String query, String ngram, DocumentSet docs, NodeSet contextSet, XQueryContext context, NodeSet result, boolean returnAncestor) {
            this.contextId = contextId;
            this.query = query;
            this.ngram = ngram;
            this.docs = docs;
            this.context = context;
            this.contextSet = contextSet;
            this.resultSet = result;
            this.returnAncestor = returnAncestor;
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            String ngram;
            try {
                ngram = new String(key.getData(), NGramQNameKey.NGRAM_OFFSET, key.getLength() - NGramQNameKey.NGRAM_OFFSET, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
            try {
                VariableByteInput is = ((NGramIndexWorker)NGramIndexWorker.this).index.db.getAsStream(pointer);
                if (is == null) {
                    return true;
                }
                while (is.available() > 0) {
                    int storedDocId = is.readInt();
                    is.readByte();
                    int occurrences = is.readInt();
                    int length = is.readFixedInt();
                    DocumentImpl storedDocument = this.docs.getDoc(storedDocId);
                    if (storedDocument == null) {
                        is.skipBytes((long)length);
                        continue;
                    }
                    NodeId previous = null;
                    for (int m = 0; m < occurrences; ++m) {
                        NodeId nodeId;
                        previous = nodeId = NGramIndexWorker.this.index.getBrokerPool().getNodeFactory().createFromStream(previous, is);
                        int freq = is.readInt();
                        NodeProxy storedNode = new NodeProxy(storedDocument, nodeId);
                        if (this.contextSet != null) {
                            int sizeHint = this.contextSet.getSizeHint(storedDocument);
                            if (this.returnAncestor) {
                                NodeProxy parentNode = this.contextSet.parentWithChild(storedNode, false, true, -1);
                                if (parentNode != null) {
                                    this.readMatches(ngram, is, nodeId, freq, parentNode);
                                    this.resultSet.add(parentNode, sizeHint);
                                } else {
                                    is.skip(freq);
                                }
                            } else {
                                this.readMatches(ngram, is, nodeId, freq, storedNode);
                                this.resultSet.add(storedNode, sizeHint);
                            }
                        } else {
                            this.readMatches(ngram, is, nodeId, freq, storedNode);
                            this.resultSet.add(storedNode, -1);
                        }
                        this.context.proceed();
                    }
                }
                return false;
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
        }

        private void readMatches(String current, VariableByteInput is, NodeId nodeId, int freq, NodeProxy parentNode) throws IOException {
            int diff = 0;
            if (current.length() > this.ngram.length()) {
                diff = current.indexOf(this.ngram);
            }
            NGramMatch match = new NGramMatch(this.contextId, nodeId, this.ngram, freq);
            for (int n = 0; n < freq; ++n) {
                int offset = is.readInt();
                if (diff > 0) {
                    offset += diff;
                }
                match.addOffset(offset, this.ngram.length());
            }
            parentNode.addMatch((Match)match);
        }
    }

    private static class NGramQNameKey
    extends Value {
        private static final int COLLECTION_ID_OFFSET = 1;
        private static final int NAMETYPE_OFFSET = 1 + Collection.LENGTH_COLLECTION_ID;
        private static final int NAMESPACE_OFFSET = NAMETYPE_OFFSET + ElementValue.LENGTH_TYPE;
        private static final int LOCALNAME_OFFSET = NAMESPACE_OFFSET + SymbolTable.LENGTH_NS_URI;
        private static final int NGRAM_OFFSET = LOCALNAME_OFFSET + SymbolTable.LENGTH_LOCAL_NAME;

        public NGramQNameKey(int collectionId) {
            this.len = Collection.LENGTH_COLLECTION_ID + 1;
            this.data = new byte[this.len];
            this.data[0] = 0;
            ByteConversion.intToByte((int)collectionId, (byte[])this.data, (int)1);
        }

        public NGramQNameKey(int collectionId, QName qname, SymbolTable symbols) {
            this.len = NGRAM_OFFSET;
            this.data = new byte[this.len];
            this.data[0] = 0;
            ByteConversion.intToByte((int)collectionId, (byte[])this.data, (int)1);
            short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
            short localNameId = symbols.getSymbol(qname.getLocalName());
            this.data[NGramQNameKey.NAMETYPE_OFFSET] = qname.getNameType();
            ByteConversion.shortToByte((short)namespaceId, (byte[])this.data, (int)NAMESPACE_OFFSET);
            ByteConversion.shortToByte((short)localNameId, (byte[])this.data, (int)LOCALNAME_OFFSET);
        }

        public NGramQNameKey(int collectionId, QName qname, SymbolTable symbols, String ngram) {
            this.len = UTF8.encoded((String)ngram) + NGRAM_OFFSET;
            this.data = new byte[this.len];
            this.data[0] = 0;
            ByteConversion.intToByte((int)collectionId, (byte[])this.data, (int)1);
            short namespaceId = symbols.getNSSymbol(qname.getNamespaceURI());
            short localNameId = symbols.getSymbol(qname.getLocalName());
            this.data[NGramQNameKey.NAMETYPE_OFFSET] = qname.getNameType();
            ByteConversion.shortToByte((short)namespaceId, (byte[])this.data, (int)NAMESPACE_OFFSET);
            ByteConversion.shortToByte((short)localNameId, (byte[])this.data, (int)LOCALNAME_OFFSET);
            UTF8.encode((String)ngram, (byte[])this.data, (int)NGRAM_OFFSET);
        }
    }

    private class QNameTerm
    implements Comparable {
        QName qname;
        String term;

        public QNameTerm(QName qname, String term) {
            this.qname = qname;
            this.term = term;
        }

        public int compareTo(Object o) {
            QNameTerm other = (QNameTerm)o;
            int cmp = this.qname.compareTo((Object)other.qname);
            if (cmp == 0) {
                return this.term.compareTo(other.term);
            }
            return cmp;
        }
    }

    private class NodeOffset {
        NodeId nodeId;
        int offset = 0;

        public NodeOffset(NodeId nodeId) {
            this.nodeId = nodeId;
        }

        public NodeOffset(NodeId nodeId, int offset) {
            this.nodeId = nodeId;
            this.offset = offset;
        }
    }

    private class NGramMatchListener
    extends AbstractMatchListener {
        private Match match;
        private Stack offsetStack = null;
        private NGramMatchCallback callback = null;
        private NodeProxy root;

        public NGramMatchListener(DBBroker broker, NodeProxy proxy) {
            this.reset(broker, proxy);
        }

        protected void setMatchCallback(NGramMatchCallback cb) {
            this.callback = cb;
        }

        protected void reset(DBBroker broker, NodeProxy proxy) {
            this.root = proxy;
            this.match = proxy.getMatches();
            this.setNextInChain(null);
            ExtArrayNodeSet ancestors = null;
            for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
                if (!proxy.getNodeId().isDescendantOf(nextMatch.getNodeId())) continue;
                if (ancestors == null) {
                    ancestors = new ExtArrayNodeSet();
                }
                ancestors.add(new NodeProxy(proxy.getDocument(), nextMatch.getNodeId()));
            }
            if (ancestors != null && !ancestors.isEmpty()) {
                NodeSetIterator i = ancestors.iterator();
                while (i.hasNext()) {
                    NodeProxy p = (NodeProxy)i.next();
                    int startOffset = 0;
                    try {
                        EmbeddedXMLStreamReader reader = broker.getXMLStreamReader(p, false);
                        while (reader.hasNext()) {
                            int ev = reader.next();
                            NodeId nodeId = (NodeId)reader.getProperty("node-id");
                            if (!nodeId.equals(proxy.getNodeId())) {
                                if (ev != 4) continue;
                                startOffset += reader.getText().length();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Problem found while serializing XML: " + e.getMessage()), (Throwable)e);
                    }
                    catch (XMLStreamException e) {
                        LOG.warn((Object)("Problem found while serializing XML: " + e.getMessage()), (Throwable)e);
                    }
                    if (this.offsetStack == null) {
                        this.offsetStack = new Stack();
                    }
                    this.offsetStack.push(new NodeOffset(p.getNodeId(), startOffset));
                }
            }
        }

        public void startElement(QName qname, AttrList attribs) throws SAXException {
            for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
                if (!nextMatch.getNodeId().equals(this.getCurrentNode().getNodeId())) continue;
                if (this.offsetStack == null) {
                    this.offsetStack = new Stack();
                }
                this.offsetStack.push(new NodeOffset(nextMatch.getNodeId()));
                break;
            }
            super.startElement(qname, attribs);
        }

        public void endElement(QName qname) throws SAXException {
            for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
                if (!nextMatch.getNodeId().equals(this.getCurrentNode().getNodeId())) continue;
                this.offsetStack.pop();
                break;
            }
            super.endElement(qname);
        }

        public void characters(CharSequence seq) throws SAXException {
            ArrayList<Match.Offset> offsets = null;
            if (this.offsetStack != null) {
                for (int i = 0; i < this.offsetStack.size(); ++i) {
                    NodeOffset no = (NodeOffset)this.offsetStack.get(i);
                    int end = no.offset + seq.length();
                    for (Match next = this.match; next != null; next = next.getNextMatch()) {
                        if (next.getIndexId() != NGramIndex.ID || !next.getNodeId().equals(no.nodeId)) continue;
                        int freq = next.getFrequency();
                        for (int j = 0; j < freq; ++j) {
                            Match.Offset offset = next.getOffset(j);
                            if (offset.getOffset() >= end || offset.getOffset() + offset.getLength() <= no.offset) continue;
                            if (offsets == null) {
                                offsets = new ArrayList<Match.Offset>(4);
                            }
                            int start = offset.getOffset() - no.offset;
                            int len = offset.getLength();
                            if (start < 0) {
                                len -= Math.abs(start);
                                start = 0;
                            }
                            if (start + len > seq.length()) {
                                len = seq.length() - start;
                            }
                            offsets.add(new Match.Offset(start, len));
                        }
                    }
                    no.offset = end;
                }
            }
            if (offsets != null) {
                FastQSort.sort((List)offsets, (int)0, (int)(offsets.size() - 1));
                String s = ((Object)seq).toString();
                int pos = 0;
                for (int i = 0; i < offsets.size(); ++i) {
                    Match.Offset offset = (Match.Offset)offsets.get(i);
                    if (offset.getOffset() > pos) {
                        super.characters((CharSequence)s.substring(pos, pos + (offset.getOffset() - pos)));
                    }
                    if (this.callback == null) {
                        super.startElement(MATCH_ELEMENT, null);
                        super.characters((CharSequence)s.substring(offset.getOffset(), offset.getOffset() + offset.getLength()));
                        super.endElement(MATCH_ELEMENT);
                    } else {
                        try {
                            this.callback.match(this.nextListener, s.substring(offset.getOffset(), offset.getOffset() + offset.getLength()), new NodeProxy(this.getCurrentNode()));
                        }
                        catch (XPathException e) {
                            throw new SAXException("An error occurred while calling match callback: " + e.getMessage(), (Exception)((Object)e));
                        }
                    }
                    pos = offset.getOffset() + offset.getLength();
                }
                if (pos < s.length()) {
                    super.characters((CharSequence)s.substring(pos));
                }
            } else {
                super.characters(seq);
            }
        }
    }

    private class NGramStreamListener
    extends AbstractStreamListener {
        public void startElement(Txn transaction, ElementImpl element, NodePath path) {
            if (NGramIndexWorker.this.config != null && NGramIndexWorker.this.config.get(element.getQName()) != null) {
                if (NGramIndexWorker.this.contentStack == null) {
                    NGramIndexWorker.this.contentStack = new Stack();
                }
                XMLString contentBuf = new XMLString();
                NGramIndexWorker.this.contentStack.push(contentBuf);
            }
            super.startElement(transaction, element, path);
        }

        public void attribute(Txn transaction, AttrImpl attrib, NodePath path) {
            if (NGramIndexWorker.this.config != null && NGramIndexWorker.this.config.get(attrib.getQName()) != null) {
                NGramIndexWorker.this.indexText(attrib.getNodeId(), attrib.getQName(), attrib.getValue());
            }
            super.attribute(transaction, attrib, path);
        }

        public void endElement(Txn transaction, ElementImpl element, NodePath path) {
            if (NGramIndexWorker.this.config != null && NGramIndexWorker.this.config.get(element.getQName()) != null) {
                XMLString content = (XMLString)NGramIndexWorker.this.contentStack.pop();
                NGramIndexWorker.this.indexText(element.getNodeId(), element.getQName(), (CharSequence)content);
            }
            super.endElement(transaction, element, path);
        }

        public void characters(Txn transaction, TextImpl text, NodePath path) {
            if (NGramIndexWorker.this.contentStack != null && !NGramIndexWorker.this.contentStack.isEmpty()) {
                for (int i = 0; i < NGramIndexWorker.this.contentStack.size(); ++i) {
                    XMLString next = (XMLString)NGramIndexWorker.this.contentStack.get(i);
                    next.append(text.getXMLString());
                }
            }
            super.characters(transaction, text, path);
        }

        public IndexWorker getWorker() {
            return NGramIndexWorker.this;
        }
    }
}

