/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram;

import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.indexing.MatchListener;
import org.exist.indexing.ngram.NGramIndex;
import org.exist.indexing.ngram.NGramIndexWorker;
import org.exist.indexing.ngram.NGramMatchCallback;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.Receiver;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.SAXException;

public class HighlightMatches
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("filter-matches", "http://exist-db.org/xquery/ngram", "ngram"), "Highlight matching strings within text nodes that resulted from a ngram search. The function takes a sequence of nodes as first argument $a and a callback function (defined with util:function) as second parameter $b. Each node in $a will be copied into a new document fragment. For each ngram match found while copying a node, the callback function in $b will be called once. The callback function should take 2 arguments: 1) the matching text string as xs:string, 2) the node to which this text string belongs. The callback function should return zero or more nodes, which will be inserted into the resulting node set at the place where the matching text sequence occurred. Note: a ngram match on mixed content may span multiple nodes. In this case, the callback function is called once for every text node which is part of the matching text sequence.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(101, 2)}, new SequenceType(-1, 7));

    public HighlightMatches(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        FunctionReference func = (FunctionReference)args[1].itemAt(0);
        FunctionCall call = func.getFunctionCall();
        NGramIndexWorker index = (NGramIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(NGramIndex.ID);
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        DocumentBuilderReceiver docBuilder = new DocumentBuilderReceiver(builder);
        MatchCallback matchCb = new MatchCallback(call, docBuilder);
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.reset();
        ValueSequence result = new ValueSequence();
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            NodeValue v = (NodeValue)i.nextItem();
            try {
                int nodeNr = builder.getDocument().getLastNode();
                if (v.getImplementationType() == 0) {
                    ((NodeImpl)v).copyTo(this.context.getBroker(), docBuilder);
                } else {
                    DocumentBuilderReceiver receiver;
                    NodeProxy p = (NodeProxy)v;
                    MatchListener ml = index.getMatchListener(this.context.getBroker(), p, matchCb);
                    if (ml == null) {
                        receiver = docBuilder;
                    } else {
                        ml.setNextInChain((Receiver)docBuilder);
                        receiver = ml;
                    }
                    serializer.setReceiver((Receiver)receiver);
                    serializer.toReceiver((NodeProxy)v, false);
                }
                result.add((Item)builder.getDocument().getNode(++nodeNr));
            }
            catch (SAXException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new XPathException(this.getASTNode(), e.getMessage());
            }
        }
        return result;
    }

    private class MatchCallback
    implements NGramMatchCallback {
        private FunctionCall callback;
        private DocumentBuilderReceiver docBuilder;

        private MatchCallback(FunctionCall callback, DocumentBuilderReceiver docBuilder) {
            this.callback = callback;
            this.docBuilder = docBuilder;
        }

        public void match(Receiver receiver, String matchingText, NodeProxy node) throws XPathException, SAXException {
            Sequence[] params = new Sequence[]{new StringValue(matchingText), node, Sequence.EMPTY_SEQUENCE};
            HighlightMatches.this.context.pushDocumentContext();
            Sequence seq = this.callback.evalFunction(null, null, params);
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                next.copyTo(HighlightMatches.this.context.getBroker(), this.docBuilder);
            }
            HighlightMatches.this.context.popDocumentContext();
        }
    }
}

