/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.indexing.ngram.NGramIndex;
import org.exist.indexing.ngram.NGramIndexWorker;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class NGramSearch
extends Function
implements Optimizable {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("contains", "http://exist-db.org/xquery/ngram", "ngram"), "Returns all nodes from $a containing the string $b at any position. Strings are compared case-insensitive.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 3)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("ends-with", "http://exist-db.org/xquery/ngram", "ngram"), "Returns all nodes from $a ending with the string $b. Strings are compared case-insensitive.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 3)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("starts-with", "http://exist-db.org/xquery/ngram", "ngram"), "Returns all nodes from $a starting with the string $b. Strings are compared case-insensitive.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 3)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("equals", "http://exist-db.org/xquery/ngram", "ngram"), "Returns all nodes from $a whose string content equals $b. Strings are compared case-insensitive", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 3)}, new SequenceType(-1, 7))};
    private LocationStep contextStep = null;
    protected QName contextQName = null;
    protected int axis = -1;
    private NodeSet preselectResult = null;
    protected boolean optimizeSelf = false;

    public NGramSearch(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void setArguments(List arguments) throws XPathException {
        Expression path = (Expression)arguments.get(0);
        this.steps.add(path);
        Expression arg = (Expression)arguments.get(1);
        arg = new DynamicCardinalityCheck(this.context, 3, arg, new Error("D02", (Object)"2", (Object)this.mySignature));
        if (!Type.subTypeOf((int)arg.returnsType(), (int)20)) {
            arg = new Atomize(this.context, arg);
        }
        this.steps.add(arg);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        List steps = BasicExpressionVisitor.findLocationSteps((Expression)this.getArgument(0));
        if (!steps.isEmpty()) {
            LocationStep firstStep = (LocationStep)steps.get(0);
            LocationStep lastStep = (LocationStep)steps.get(steps.size() - 1);
            if (steps.size() == 1 && firstStep.getAxis() == 12) {
                LocationStep outerStep;
                NodeTest test;
                Expression outerExpr = contextInfo.getContextStep();
                if (outerExpr != null && outerExpr instanceof LocationStep && !(test = (outerStep = (LocationStep)outerExpr).getTest()).isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (outerStep.getAxis() == 6 || outerStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.contextStep = firstStep;
                    this.axis = outerStep.getAxis();
                    this.optimizeSelf = true;
                }
            } else {
                NodeTest test = lastStep.getTest();
                if (!test.isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (lastStep.getAxis() == 6 || lastStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.axis = firstStep.getAxis();
                    this.contextStep = lastStep;
                }
            }
        }
    }

    public boolean canOptimize(Sequence contextSequence) {
        return this.contextQName != null;
    }

    public boolean optimizeOnSelf() {
        return this.optimizeSelf;
    }

    public int getOptimizeAxis() {
        return this.axis;
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        this.preselectResult = null;
        NGramIndexWorker index = (NGramIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(NGramIndex.ID);
        DocumentSet docs = contextSequence.getDocumentSet();
        String key = this.getArgument(1).eval(contextSequence).getStringValue();
        String[] ngrams = index.getDistinctNGrams(key);
        ArrayList<QName> qnames = new ArrayList<QName>(1);
        qnames.add(this.contextQName);
        this.preselectResult = this.processMatches(index, docs, qnames, key, ngrams, useContext ? contextSequence.toNodeSet() : null, 1);
        return this.preselectResult;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.preselectResult == null) {
            Sequence input = this.getArgument(0).eval(contextSequence, contextItem);
            if (input.isEmpty()) {
                result = NodeSet.EMPTY_SET;
            } else {
                NodeSet inNodes = input.toNodeSet();
                DocumentSet docs = inNodes.getDocumentSet();
                NGramIndexWorker index = (NGramIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(NGramIndex.ID);
                String key = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
                String[] ngrams = index.getDistinctNGrams(key);
                ArrayList<QName> qnames = null;
                if (this.contextQName != null) {
                    qnames = new ArrayList<QName>(1);
                    qnames.add(this.contextQName);
                }
                result = this.processMatches(index, docs, qnames, key, ngrams, inNodes, 0);
            }
        } else {
            this.contextStep.setPreloadNodeSets(true);
            this.contextStep.setPreloadedData(contextSequence.getDocumentSet(), this.preselectResult);
            result = this.getArgument(0).eval(contextSequence).toNodeSet();
        }
        return result;
    }

    private NodeSet processMatches(NGramIndexWorker index, DocumentSet docs, List qnames, String key, String[] ngrams, NodeSet nodeSet, int axis) throws TerminatedException {
        NodeSet result = null;
        for (int i = 0; i < ngrams.length; ++i) {
            long start = System.currentTimeMillis();
            String ngram = ngrams[i];
            if (ngram.length() < index.getN() && i > 0) {
                int fill = index.getN() - ngram.length();
                ngram = ngrams[i - 1].substring(index.getN() - fill) + ngram;
            }
            NodeSet nodes = index.search(this.getExpressionId(), docs, qnames, ngram, ngrams[i], this.context, nodeSet, axis);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found " + nodes.getLength() + " for " + ngram + " in " + (System.currentTimeMillis() - start)));
            }
            if (result == null) {
                if (this.isCalledAs("starts-with")) {
                    result = this.startsWith(nodes);
                    continue;
                }
                result = nodes;
                continue;
            }
            ExtArrayNodeSet temp = new ExtArrayNodeSet();
            NodeSetIterator iterator = nodes.iterator();
            while (iterator.hasNext()) {
                NodeProxy next = (NodeProxy)iterator.next();
                NodeProxy before = result.get(next);
                if (before == null) continue;
                Match match = null;
                boolean found = false;
                for (Match mb = before.getMatches(); mb != null && !found; mb = mb.getNextMatch()) {
                    for (Match mn = next.getMatches(); mn != null && !found; mn = mn.getNextMatch()) {
                        match = mb.isAfter(mn);
                        if (match == null) continue;
                        found = true;
                    }
                }
                if (!found) continue;
                next.setMatches(null);
                for (Match m = next.getMatches(); m != null; m = m.getNextMatch()) {
                    if (m.getContextId() == this.getExpressionId()) continue;
                    next.addMatch(m);
                }
                next.addMatch(match);
                temp.add(next);
            }
            result = temp;
        }
        if (this.isCalledAs("starts-with")) {
            result = this.startsWith(result);
        } else if (this.isCalledAs("ends-with")) {
            result = this.endsWith(result);
        } else if (this.isCalledAs("equals")) {
            result = this.equals(key, result);
        }
        return result;
    }

    private NodeSet startsWith(NodeSet nodes) {
        ExtArrayNodeSet temp = new ExtArrayNodeSet();
        NodeSetIterator iterator = nodes.iterator();
        block0: while (iterator.hasNext()) {
            NodeProxy next = (NodeProxy)iterator.next();
            for (Match mn = next.getMatches(); mn != null; mn = mn.getNextMatch()) {
                if (!mn.hasMatchAt(0)) continue;
                temp.add(next);
                continue block0;
            }
        }
        return temp;
    }

    private NodeSet endsWith(NodeSet nodes) {
        ExtArrayNodeSet temp = new ExtArrayNodeSet();
        NodeSetIterator iterator = nodes.iterator();
        block0: while (iterator.hasNext()) {
            NodeProxy next = (NodeProxy)iterator.next();
            String data = next.getNodeValue();
            int len = data.length();
            for (Match mn = next.getMatches(); mn != null; mn = mn.getNextMatch()) {
                if (!mn.hasMatchAround(len)) continue;
                temp.add(next);
                continue block0;
            }
        }
        return temp;
    }

    private NodeSet equals(String key, NodeSet nodes) {
        ExtArrayNodeSet temp = new ExtArrayNodeSet();
        NodeSetIterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            NodeProxy next = (NodeProxy)iterator.next();
            String data = next.getNodeValue();
            if (!key.equalsIgnoreCase(data)) continue;
            temp.add(next);
        }
        return temp;
    }

    public int getDependencies() {
        Expression stringArg = this.getArgument(0);
        if (Type.subTypeOf((int)stringArg.returnsType(), (int)-1) && !Dependency.dependsOn((Expression)stringArg, (int)2)) {
            return 1;
        }
        return 3;
    }

    public int returnsType() {
        return -1;
    }
}

