/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Marshaller;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class FD
extends Protocol {
    Address ping_dest = null;
    Address local_addr = null;
    long timeout = 3000L;
    long last_ack = System.currentTimeMillis();
    int num_tries = 0;
    int max_tries = 2;
    final List members = new CopyOnWriteArrayList();
    final Hashtable invalid_pingers = new Hashtable(7);
    final List pingable_mbrs = new CopyOnWriteArrayList();
    boolean shun = true;
    TimeScheduler timer = null;
    private Monitor monitor = null;
    private final Object monitor_mutex = new Object();
    protected int num_heartbeats = 0;
    protected int num_suspect_events = 0;
    protected final Broadcaster bcast_task = new Broadcaster();
    static final String name = "FD";
    BoundedList suspect_history = new BoundedList(20);
    static /* synthetic */ Class class$java$util$Vector;

    public String getName() {
        return name;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    public String getPingableMembers() {
        return this.pingable_mbrs != null ? this.pingable_mbrs.toString() : "null";
    }

    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    public int getNumberOfHeartbeatsSent() {
        return this.num_heartbeats;
    }

    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxTries() {
        return this.max_tries;
    }

    public void setMaxTries(int max_tries) {
        this.max_tries = max_tries;
    }

    public int getCurrentNumTries() {
        return this.num_tries;
    }

    public boolean isShun() {
        return this.shun;
    }

    public void setShun(boolean flag) {
        this.shun = flag;
    }

    public String printSuspectHistory() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.suspect_history.elements();
        while (en.hasMoreElements()) {
            sb.append(new Date()).append(": ").append(en.nextElement()).append("\n");
        }
        return sb.toString();
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("max_tries")) != null) {
            this.max_tries = Integer.parseInt(str);
            props.remove("max_tries");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats = 0;
        this.suspect_history.removeAll();
    }

    public void init() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("FD.init(): timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    public void stop() {
        this.stopMonitor();
    }

    private Object getPingDest(List mbrs) {
        Object retval = null;
        if (mbrs == null || mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            Object tmp = mbrs.get(i);
            if (!this.local_addr.equals(tmp)) continue;
            if (i + 1 >= mbrs.size()) {
                retval = mbrs.get(0);
                break;
            }
            retval = mbrs.get(i + 1);
            break;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitor() {
        Object object = this.monitor_mutex;
        synchronized (object) {
            if (this.monitor != null && !this.monitor.started) {
                this.monitor = null;
            }
            if (this.monitor == null) {
                this.monitor = this.createMonitor();
                this.last_ack = System.currentTimeMillis();
                this.timer.add(this.monitor, true);
                this.num_tries = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitor() {
        Object object = this.monitor_mutex;
        synchronized (object) {
            if (this.monitor != null) {
                this.monitor.stop();
                this.monitor = null;
            }
        }
    }

    protected Monitor createMonitor() {
        return new Monitor();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header tmphdr = msg.getHeader(name);
                if (tmphdr == null || !(tmphdr instanceof FdHeader)) {
                    Address sender;
                    if (this.ping_dest == null || (sender = msg.getSrc()) == null || !this.ping_dest.equals(sender)) break;
                    this.last_ack = System.currentTimeMillis();
                    if (this.trace) {
                        this.log.trace((Object)("received msg from " + sender + " (counts as ack)"));
                    }
                    this.num_tries = 0;
                    break;
                }
                FdHeader hdr = (FdHeader)msg.removeHeader(name);
                switch (hdr.type) {
                    case 0: {
                        Address hb_sender = msg.getSrc();
                        if (this.trace) {
                            this.log.trace((Object)("received are-you-alive from " + hb_sender + ", sending response"));
                        }
                        this.sendHeartbeatResponse(hb_sender);
                        if (!this.shun) break;
                        this.shunInvalidHeartbeatSender(hb_sender);
                        break;
                    }
                    case 1: {
                        if (this.ping_dest != null && this.ping_dest.equals(hdr.from)) {
                            this.last_ack = System.currentTimeMillis();
                            this.num_tries = 0;
                            if (!this.log.isDebugEnabled()) break;
                            this.log.debug((Object)("received ack from " + hdr.from));
                            break;
                        }
                        this.stop();
                        this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
                        if (this.ping_dest == null) break;
                        try {
                            this.startMonitor();
                        }
                        catch (Exception ex) {
                            if (!this.warn) break;
                            this.log.warn((Object)("exception when calling startMonitor(): " + ex));
                        }
                        break;
                    }
                    case 2: {
                        if (hdr.mbrs == null) break;
                        if (this.trace) {
                            this.log.trace((Object)("[SUSPECT] suspect hdr is " + hdr));
                        }
                        for (int i = 0; i < hdr.mbrs.size(); ++i) {
                            Address m = (Address)hdr.mbrs.elementAt(i);
                            if (this.local_addr != null && m.equals(this.local_addr)) {
                                if (this.warn) {
                                    this.log.warn((Object)("I was suspected by " + msg.getSrc() + "; ignoring the SUSPECT " + "message and sending back a HEARTBEAT_ACK"));
                                }
                                this.sendHeartbeatResponse(msg.getSrc());
                                continue;
                            }
                            this.pingable_mbrs.remove(m);
                            this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
                            this.passUp(new Event(9, m));
                            this.passDown(new Event(9, m));
                        }
                        break;
                    }
                    case 3: {
                        if (!this.shun) break;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"[NOT_MEMBER] I'm being shunned; exiting");
                        }
                        this.passUp(new Event(46));
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.passDown(evt);
                this.stop();
                FD fD = this;
                synchronized (fD) {
                    View v = (View)evt.getArg();
                    this.members.clear();
                    this.members.addAll(v.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.pingable_mbrs.clear();
                    this.pingable_mbrs.addAll(this.members);
                    this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
                    if (this.ping_dest == null) break;
                    try {
                        this.startMonitor();
                    }
                    catch (Exception ex) {
                        if (!this.warn) break;
                        this.log.warn((Object)("exception when calling startMonitor(): " + ex));
                    }
                    break;
                }
            }
            case 51: {
                this.unsuspect((Address)evt.getArg());
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private void sendHeartbeatResponse(Address dest) {
        Message hb_ack = new Message(dest, null, null);
        FdHeader tmp_hdr = new FdHeader(1);
        tmp_hdr.from = this.local_addr;
        hb_ack.putHeader(name, tmp_hdr);
        this.passDown(new Event(1, hb_ack));
    }

    private void unsuspect(Address mbr) {
        this.bcast_task.removeSuspectedMember(mbr);
        this.pingable_mbrs.clear();
        this.pingable_mbrs.addAll(this.members);
        this.pingable_mbrs.removeAll(this.bcast_task.getSuspectedMembers());
        this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
    }

    private void shunInvalidHeartbeatSender(Address hb_sender) {
        int num_pings = 0;
        if (hb_sender != null && this.members != null && !this.members.contains(hb_sender)) {
            if (this.invalid_pingers.containsKey(hb_sender)) {
                num_pings = (Integer)this.invalid_pingers.get(hb_sender);
                if (num_pings >= this.max_tries) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(hb_sender + " is not in " + this.members + " ! Shunning it"));
                    }
                    Message shun_msg = new Message(hb_sender, null, null);
                    shun_msg.putHeader(name, new FdHeader(3));
                    this.passDown(new Event(1, shun_msg));
                    this.invalid_pingers.remove(hb_sender);
                } else {
                    this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
                }
            } else {
                this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
            }
        }
    }

    protected final class BroadcastTask
    implements TimeScheduler.Task {
        boolean cancelled = false;
        private final Vector suspected_members = new Vector();

        BroadcastTask(Vector suspected_members) {
            this.suspected_members.addAll(suspected_members);
        }

        public void stop() {
            this.cancelled = true;
            this.suspected_members.clear();
            if (FD.this.trace) {
                FD.this.log.trace((Object)"BroadcastTask stopped");
            }
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public long nextInterval() {
            return FD.this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FdHeader hdr;
            Vector vector = this.suspected_members;
            synchronized (vector) {
                if (this.suspected_members.size() == 0) {
                    this.stop();
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)"task done (no suspected members)");
                    }
                    return;
                }
                hdr = new FdHeader(2);
                hdr.mbrs = (Vector)this.suspected_members.clone();
                hdr.from = FD.this.local_addr;
            }
            Message suspect_msg = new Message();
            suspect_msg.putHeader(FD.name, hdr);
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("broadcasting SUSPECT message [suspected_mbrs=" + this.suspected_members + "] to group"));
            }
            FD.this.passDown(new Event(1, suspect_msg));
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)"task done");
            }
        }

        public void addSuspectedMember(Address suspect) {
            if (suspect != null && !this.suspected_members.contains(suspect)) {
                this.suspected_members.add(suspect);
            }
        }
    }

    protected final class Broadcaster {
        final Vector suspected_mbrs = new Vector(7);
        BroadcastTask task = null;
        private final Object bcast_mutex = new Object();

        protected Broadcaster() {
        }

        Vector getSuspectedMembers() {
            return this.suspected_mbrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startBroadcastTask(Address suspect) {
            Object object = this.bcast_mutex;
            synchronized (object) {
                if (this.task == null || this.task.cancelled()) {
                    this.task = new BroadcastTask((Vector)this.suspected_mbrs.clone());
                    this.task.addSuspectedMember(suspect);
                    this.task.run();
                    FD.this.timer.add(this.task);
                    if (FD.this.trace) {
                        FD.this.log.trace((Object)"BroadcastTask started");
                    }
                } else {
                    this.task.addSuspectedMember(suspect);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopBroadcastTask() {
            Object object = this.bcast_mutex;
            synchronized (object) {
                if (this.task != null) {
                    this.task.stop();
                    this.task = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD.this.members.contains(mbr)) {
                return;
            }
            boolean added = false;
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                    added = true;
                }
            }
            if (added) {
                this.startBroadcastTask(mbr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("member is " + suspected_mbr));
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
                if (this.suspected_mbrs.size() == 0) {
                    this.stopBroadcastTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAll() {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeAllElements();
                this.stopBroadcastTask();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void adjustSuspectedMembers(List new_mbrship) {
            if (new_mbrship == null || new_mbrship.size() == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                sb.append("suspected_mbrs: ").append(this.suspected_mbrs);
                this.suspected_mbrs.retainAll(new_mbrship);
                if (this.suspected_mbrs.size() == 0) {
                    this.stopBroadcastTask();
                }
                sb.append(", after adjustment: ").append(this.suspected_mbrs);
                FD.this.log.debug((Object)sb.toString());
            }
        }
    }

    protected class Monitor
    implements TimeScheduler.Task {
        boolean started = true;

        protected Monitor() {
        }

        public void stop() {
            this.started = false;
        }

        public boolean cancelled() {
            return !this.started;
        }

        public long nextInterval() {
            return FD.this.timeout;
        }

        public void run() {
            if (FD.this.ping_dest == null) {
                if (FD.this.warn) {
                    FD.this.log.warn((Object)("ping_dest is null: members=" + FD.this.members + ", pingable_mbrs=" + FD.this.pingable_mbrs + ", local_addr=" + FD.this.local_addr));
                }
                return;
            }
            Message hb_req = new Message(FD.this.ping_dest, null, null);
            hb_req.putHeader(FD.name, new FdHeader(0));
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("sending are-you-alive msg to " + FD.this.ping_dest + " (own address=" + FD.this.local_addr + ')'));
            }
            FD.this.passDown(new Event(1, hb_req));
            ++FD.this.num_heartbeats;
            long not_heard_from = System.currentTimeMillis() - FD.this.last_ack;
            if (not_heard_from > FD.this.timeout + 500L) {
                if (FD.this.num_tries >= FD.this.max_tries) {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)("[" + FD.this.local_addr + "]: received no heartbeat ack from " + FD.this.ping_dest + " for " + (FD.this.num_tries + 1) + " times (" + (long)(FD.this.num_tries + 1) * FD.this.timeout + " milliseconds), suspecting it"));
                    }
                    FD.this.bcast_task.addSuspectedMember(FD.this.ping_dest);
                    FD.this.num_tries = 0;
                    if (FD.this.stats) {
                        ++FD.this.num_suspect_events;
                        FD.this.suspect_history.add(FD.this.ping_dest);
                    }
                } else {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)("heartbeat missing from " + FD.this.ping_dest + " (number=" + FD.this.num_tries + ')'));
                    }
                    ++FD.this.num_tries;
                }
            }
        }

        public String toString() {
            return Boolean.toString(this.started);
        }
    }

    public static class FdHeader
    extends Header
    implements Streamable {
        public static final byte HEARTBEAT = 0;
        public static final byte HEARTBEAT_ACK = 1;
        public static final byte SUSPECT = 2;
        public static final byte NOT_MEMBER = 3;
        byte type = 0;
        Vector mbrs = null;
        Address from = null;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Vector mbrs, Address from) {
            this(type);
            this.mbrs = mbrs;
            this.from = from;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "[FD: heartbeat]";
                }
                case 1: {
                    return "[FD: heartbeat ack]";
                }
                case 2: {
                    return "[FD: SUSPECT (suspected_mbrs=" + this.mbrs + ", from=" + this.from + ")]";
                }
                case 3: {
                    return "[FD: NOT_MEMBER]";
                }
            }
            return "[FD: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            if (this.mbrs == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(this.mbrs.size());
                Iterator it = this.mbrs.iterator();
                while (it.hasNext()) {
                    Address addr = (Address)it.next();
                    Marshaller.write(addr, out);
                }
            }
            Marshaller.write(this.from, out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            boolean mbrs_not_null = in.readBoolean();
            if (mbrs_not_null) {
                int len = in.readInt();
                this.mbrs = new Vector(11);
                for (int i = 0; i < len; ++i) {
                    Address addr = (Address)Marshaller.read(in);
                    this.mbrs.add(addr);
                }
            }
            this.from = (Address)Marshaller.read(in);
        }

        public long size() {
            int retval = 1;
            retval = (int)((long)retval + Util.size(this.mbrs));
            return retval += Util.size(this.from);
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddresses(this.mbrs, out);
            Util.writeAddress(this.from, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.mbrs = (Vector)Util.readAddresses(in, class$java$util$Vector == null ? (class$java$util$Vector = FD.class$("java.util.Vector")) : class$java$util$Vector);
            this.from = Util.readAddress(in);
        }
    }
}

