/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ReentrantLockTest
extends TestCase {
    ReentrantLock lock;

    public ReentrantLockTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.lock = new ReentrantLock();
    }

    public void tearDown() throws Exception {
        this.releaseAll(this.lock);
        this.lock = null;
        super.tearDown();
    }

    public void testAcquireLock() {
        try {
            this.lock.acquire();
            ReentrantLockTest.assertEquals((long)1L, (long)this.lock.holds());
            this.lock.acquire();
            ReentrantLockTest.assertEquals((long)2L, (long)this.lock.holds());
            this.release(this.lock);
            ReentrantLockTest.assertEquals((long)1L, (long)this.lock.holds());
            this.release(this.lock);
            ReentrantLockTest.assertEquals((long)0L, (long)this.lock.holds());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void testAcquireLock2() {
        try {
            this.lock.acquire();
            ReentrantLockTest.assertEquals((long)1L, (long)this.lock.holds());
            this.lock.acquire();
            ReentrantLockTest.assertEquals((long)2L, (long)this.lock.holds());
            this.releaseAll(this.lock);
            ReentrantLockTest.assertEquals((long)0L, (long)this.lock.holds());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void release(ReentrantLock lock) {
        if (lock != null && lock.holds() > 0L) {
            lock.release();
        }
    }

    private void releaseAll(ReentrantLock lock) {
        long holds;
        if (lock != null && (holds = lock.holds()) > 0L) {
            lock.release(holds);
        }
    }

    public static Test suite() {
        return new TestSuite(ReentrantLockTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ReentrantLockTest.suite());
    }
}

