/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;

public class JMXClient {
    private MBeanServerConnection connection;
    private String instance;
    private static final int HELP_OPT = 104;
    private static final int CACHE_OPT = 99;
    private static final int DB_OPT = 100;
    private static final int WAIT_OPT = 119;
    private static final int LOCK_OPT = 108;
    private static final int MEMORY_OPT = 109;
    private static final int PORT_OPT = 112;
    private static final int INSTANCE_OPT = 105;
    private static final int ADDRESS_OPT = 97;
    private static final int SANITY_OPT = 115;
    private static final int JOBS_OPT = 106;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print help on command line options and exit."), new CLOptionDescriptor("cache", 8, 99, "displays server statistics on cache and memory usage."), new CLOptionDescriptor("db", 8, 100, "display general info about the db instance."), new CLOptionDescriptor("wait", 2, 119, "while displaying server statistics: keep retrieving statistics, but wait the specified number of seconds between calls."), new CLOptionDescriptor("locks", 8, 108, "lock manager: display locking information on all threads currently waiting for a lock on a resource or collection. Useful to debug deadlocks. During normal operation, the list will usually be empty (means: no blocked threads)."), new CLOptionDescriptor("memory", 8, 109, "display info on free and total memory. Can be combined with other parameters."), new CLOptionDescriptor("port", 2, 112, "RMI port of the server"), new CLOptionDescriptor("address", 2, 97, "RMI address of the server"), new CLOptionDescriptor("instance", 2, 105, "the ID of the database instance to connect to"), new CLOptionDescriptor("report", 8, 115, "retrieve sanity check report from the db"), new CLOptionDescriptor("jobs", 8, 106, "list currently running jobs")};
    private static final int MODE_STATS = 0;
    private static final int MODE_LOCKS = 1;

    public JMXClient(String instanceName) {
        this.instance = instanceName;
    }

    public void connect(String address, int port) throws IOException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + address + ":" + port + "/jmxrmi");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] creds = new String[]{"guest", "guest"};
        env.put("jmx.remote.credentials", creds);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
        this.connection = jmxc.getMBeanServerConnection();
        this.echo("Connected to MBean server.");
    }

    public void memoryStats() {
        try {
            ObjectName name = new ObjectName("java.lang:type=Memory");
            CompositeData composite = (CompositeData)this.connection.getAttribute(name, "HeapMemoryUsage");
            if (composite != null) {
                this.echo("\nMEMORY:");
                this.echo(String.format("Current heap: %,12d k        Committed memory:  %,12d k", (Long)composite.get("used") / 1024L, (Long)composite.get("committed") / 1024L));
                this.echo(String.format("Max memory:   %,12d k", (Long)composite.get("max") / 1024L));
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void instanceStats() {
        try {
            this.echo("\nINSTANCE:");
            ObjectName name = new ObjectName("org.exist.management." + this.instance + ":type=Database");
            Long memReserved = (Long)this.connection.getAttribute(name, "ReservedMem");
            this.echo(String.format("%25s: %10d k", "Reserved memory", memReserved / 1024L));
            Long memCache = (Long)this.connection.getAttribute(name, "CacheMem");
            this.echo(String.format("%25s: %10d k", "Cache memory", memCache / 1024L));
            Long memCollCache = (Long)this.connection.getAttribute(name, "CollectionCacheMem");
            this.echo(String.format("%25s: %10d k", "Collection cache memory", memCollCache / 1024L));
            String[] cols = new String[]{"MaxBrokers", "AvailableBrokers", "ActiveBrokers"};
            this.echo(String.format("\n%17s %17s %17s", cols[0], cols[1], cols[2]));
            AttributeList attrs = this.connection.getAttributes(name, cols);
            Object[] values = this.getValues(attrs);
            this.echo(String.format("%17d %17d %17d", values[0], values[1], values[2]));
            TabularData table = (TabularData)this.connection.getAttribute(name, "ActiveBrokersMap");
            if (table.size() > 0) {
                this.echo("\nCurrently active threads:");
            }
            for (CompositeData data : table.values()) {
                this.echo(String.format("\t%20s: %3d", data.get("owner"), data.get("referenceCount")));
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void cacheStats() {
        try {
            ObjectName name2 = new ObjectName("org.exist.management." + this.instance + ":type=CacheManager");
            String[] cols = new String[]{"MaxTotal", "CurrentSize"};
            AttributeList attrs = this.connection.getAttributes(name2, cols);
            Object[] values = this.getValues(attrs);
            this.echo(String.format("\nCACHE [%8d pages max. / %8d pages allocated]", values[0], values[1]));
            Set<ObjectName> beans = this.connection.queryNames(new ObjectName("org.exist.management." + this.instance + ":type=CacheManager.Cache,*"), null);
            cols = new String[]{"Type", "FileName", "Size", "Used", "Hits", "Fails"};
            this.echo(String.format("%10s %20s %10s %10s %10s %10s", cols[0], cols[1], cols[2], cols[3], cols[4], cols[5]));
            for (ObjectName name2 : beans) {
                attrs = this.connection.getAttributes(name2, cols);
                values = this.getValues(attrs);
                this.echo(String.format("%10s %20s %,10d %,10d %,10d %,10d", values[0], values[1], values[2], values[3], values[4], values[5]));
            }
        }
        catch (IOException e) {
            this.error(e);
        }
        catch (MalformedObjectNameException e) {
            this.error(e);
        }
        catch (InstanceNotFoundException e) {
            this.error(e);
        }
        catch (ReflectionException e) {
            this.error(e);
        }
    }

    public void lockTable() {
        this.echo("\nList of threads currently waiting for a lock:");
        this.echo("-----------------------------------------------");
        try {
            TabularData table = (TabularData)this.connection.getAttribute(new ObjectName("org.exist.management:type=LockManager"), "WaitingThreads");
            for (CompositeData data : table.values()) {
                Object[] writers;
                this.echo("Thread " + data.get("waitingThread"));
                this.echo(String.format("%20s: %s", "Lock type", data.get("lockType")));
                this.echo(String.format("%20s: %s", "Lock mode", data.get("lockMode")));
                this.echo(String.format("%20s: %s", "Lock id", data.get("id")));
                this.echo(String.format("%20s: %s", "Held by", Arrays.toString((String[])data.get("owner"))));
                Object[] readers = (String[])data.get("waitingForRead");
                if (readers.length > 0) {
                    this.echo(String.format("%20s: %s", "Wait for read", Arrays.toString(readers)));
                }
                if ((writers = (String[])data.get("waitingForWrite")).length <= 0) continue;
                this.echo(String.format("%20s: %s", "Wait for write", Arrays.toString(writers)));
            }
        }
        catch (MBeanException e) {
            this.error(e);
        }
        catch (AttributeNotFoundException e) {
            this.error(e);
        }
        catch (InstanceNotFoundException e) {
            this.error(e);
        }
        catch (ReflectionException e) {
            this.error(e);
        }
        catch (IOException e) {
            this.error(e);
        }
        catch (MalformedObjectNameException e) {
            this.error(e);
        }
    }

    public void sanityReport() {
        this.echo("\nSanity report");
        this.echo("-----------------------------------------------");
        try {
            ObjectName name = new ObjectName("org.exist.management." + this.instance + ".tasks:type=SanityReport");
            String status = (String)this.connection.getAttribute(name, "Status");
            Date lastCheckStart = (Date)this.connection.getAttribute(name, "LastCheckStart");
            Date lastCheckEnd = (Date)this.connection.getAttribute(name, "LastCheckEnd");
            this.echo(String.format("%22s: %s", "Status", status));
            this.echo(String.format("%22s: %s", "Last check start", lastCheckStart));
            this.echo(String.format("%22s: %s", "Last check end", lastCheckEnd));
            if (lastCheckStart != null && lastCheckEnd != null) {
                this.echo(String.format("%22s: %dms", "Check took", lastCheckEnd.getTime() - lastCheckStart.getTime()));
            }
            TabularData table = (TabularData)this.connection.getAttribute(name, "Errors");
            for (CompositeData data : table.values()) {
                this.echo(String.format("%22s: %s", "Error code", data.get("errcode")));
                this.echo(String.format("%22s: %s", "Description", data.get("description")));
            }
        }
        catch (MBeanException e) {
            this.error(e);
        }
        catch (AttributeNotFoundException e) {
            this.error(e);
        }
        catch (InstanceNotFoundException e) {
            this.error(e);
        }
        catch (ReflectionException e) {
            this.error(e);
        }
        catch (IOException e) {
            this.error(e);
        }
        catch (MalformedObjectNameException e) {
            this.error(e);
        }
    }

    public void jobReport() {
        this.echo("\nRunning jobs report");
        this.echo("-----------------------------------------------");
        try {
            ObjectName name = new ObjectName("org.exist.management." + this.instance + ":type=ProcessReport");
            TabularData table = (TabularData)this.connection.getAttribute(name, "RunningJobs");
            String[] cols = new String[]{"ID", "Action", "Info"};
            this.echo(String.format("%15s %30s %30s", cols[0], cols[1], cols[2]));
            for (CompositeData data : table.values()) {
                this.echo(String.format("%15s %30s %30s", data.get("id"), data.get("action"), data.get("info")));
            }
            this.echo("\nRunning queries");
            this.echo("-----------------------------------------------");
            table = (TabularData)this.connection.getAttribute(name, "RunningQueries");
            cols = new String[]{"ID", "Type", "Key", "Terminating"};
            this.echo(String.format("%10s %10s %30s %s", cols[0], cols[1], cols[2], cols[3]));
            for (CompositeData data : table.values()) {
                this.echo(String.format("%15s %15s %30s %6s", data.get("id"), data.get("sourceType"), data.get("sourceKey"), data.get("terminating")));
            }
        }
        catch (MBeanException e) {
            this.error(e);
        }
        catch (AttributeNotFoundException e) {
            this.error(e);
        }
        catch (InstanceNotFoundException e) {
            this.error(e);
        }
        catch (ReflectionException e) {
            this.error(e);
        }
        catch (IOException e) {
            this.error(e);
        }
        catch (MalformedObjectNameException e) {
            this.error(e);
        }
    }

    private Object[] getValues(AttributeList attribs) {
        Object[] v = new Object[attribs.size()];
        for (int i = 0; i < attribs.size(); ++i) {
            v[i] = ((Attribute)attribs.get(i)).getValue();
        }
        return v;
    }

    private void echo(String msg) {
        System.out.println(msg);
    }

    private void error(Exception e) {
        System.err.println("ERROR: " + e.getMessage());
        e.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CLArgsParser optParser = new CLArgsParser(args, OPTIONS);
        if (optParser.getErrorString() != null) {
            System.err.println("ERROR: " + optParser.getErrorString());
            return;
        }
        String dbInstance = "exist";
        long waitTime = 0L;
        Vector opt = optParser.getArguments();
        int size = opt.size();
        int mode = -1;
        int port = 1099;
        String address = "localhost";
        boolean displayMem = false;
        boolean displayInstance = false;
        boolean displayReport = false;
        boolean jobReport = false;
        block30: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)opt.get(i);
            switch (option.getId()) {
                case 104: {
                    System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
                    return;
                }
                case 119: {
                    try {
                        waitTime = Integer.parseInt(option.getArgument()) * 1000;
                        continue block30;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("option -w|--wait requires a numeric argument");
                        return;
                    }
                }
                case 99: {
                    mode = 0;
                    continue block30;
                }
                case 108: {
                    mode = 1;
                    continue block30;
                }
                case 112: {
                    try {
                        port = Integer.parseInt(option.getArgument());
                        continue block30;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("option -p|--port requires a numeric argument");
                        return;
                    }
                }
                case 97: {
                    try {
                        address = option.getArgument();
                        continue block30;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("option -a|--address requires a numeric argument");
                        return;
                    }
                }
                case 109: {
                    displayMem = true;
                    continue block30;
                }
                case 100: {
                    displayInstance = true;
                    continue block30;
                }
                case 105: {
                    dbInstance = option.getArgument();
                    continue block30;
                }
                case 115: {
                    displayReport = true;
                    continue block30;
                }
                case 106: {
                    jobReport = true;
                }
            }
        }
        try {
            JMXClient stats = new JMXClient(dbInstance);
            stats.connect(address, port);
            stats.memoryStats();
            while (true) {
                switch (mode) {
                    case 0: {
                        stats.cacheStats();
                        break;
                    }
                    case 1: {
                        stats.lockTable();
                    }
                }
                if (displayInstance) {
                    stats.instanceStats();
                }
                if (displayMem) {
                    stats.memoryStats();
                }
                if (displayReport) {
                    stats.sanityReport();
                }
                if (jobReport) {
                    stats.jobReport();
                }
                if (waitTime <= 0L) break;
                JMXClient jMXClient = stats;
                synchronized (jMXClient) {
                    try {
                        stats.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        System.err.println("INTERRUPTED: " + e.getMessage());
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

